/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.knowm.xchart.internal.chartpart.Annotation;
import org.knowm.xchart.internal.chartpart.Chart;

public class AnnotationImage
extends Annotation {
    private BufferedImage image;
    protected double x;
    protected double y;

    public AnnotationImage(BufferedImage image, double x, double y, boolean isValueInScreenSpace) {
        super(isValueInScreenSpace);
        this.image = image;
        this.x = x;
        this.y = y;
    }

    @Override
    public void init(Chart chart) {
        super.init(chart);
    }

    @Override
    public void paint(Graphics2D g2) {
        int yOffset;
        int xOffset;
        if (!this.isVisible) {
            return;
        }
        if (this.isValueInScreenSpace) {
            xOffset = (int)this.x - this.image.getWidth() / 2;
            yOffset = this.chart.getHeight() - (int)this.y - this.image.getWidth() / 2;
        } else {
            xOffset = (int)((double)this.getXAxisScreenValue(this.x) + 0.5) - this.image.getWidth() / 2;
            yOffset = (int)((double)this.getYAxisScreenValue(this.y) + 0.5) - this.image.getHeight() / 2;
        }
        g2.drawImage((Image)this.image, xOffset, yOffset, null);
        this.bounds = new Rectangle2D.Double(xOffset, yOffset, this.image.getWidth(), this.image.getHeight());
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
}

