/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jaitools.CollectionFactory;
import org.jaitools.numeric.Processor;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;

public abstract class AbstractProcessor
implements Processor {
    protected long numOffered;
    protected long numAccepted;
    protected long numNaN;
    protected long numNoData;
    private List<Range<Double>> ranges = CollectionFactory.list();
    private Range.Type rangesType;
    private List<Range<Double>> noDataRanges = CollectionFactory.list();

    public AbstractProcessor() {
        this.rangesType = Range.Type.UNDEFINED;
        this.numNoData = 0L;
        this.numNaN = 0L;
        this.numAccepted = 0L;
        this.numOffered = 0L;
    }

    public AbstractProcessor(Range.Type rangesType) {
        this.rangesType = rangesType;
        this.numNoData = 0L;
        this.numNaN = 0L;
        this.numAccepted = 0L;
        this.numOffered = 0L;
    }

    @Override
    public void addNoDataRange(Range<Double> noData) {
        if (noData != null) {
            this.noDataRanges.add(new Range<Double>(noData));
        }
    }

    @Override
    public void addNoDataValue(Double noData) {
        if (noData != null && !noData.isNaN()) {
            this.noDataRanges.add(new Range<Double>(noData, new int[0]));
        }
    }

    @Override
    public final long getNumOffered() {
        return this.numOffered;
    }

    @Override
    public final long getNumAccepted() {
        return this.numAccepted;
    }

    @Override
    public long getNumNaN() {
        return this.numNaN;
    }

    @Override
    public void offer(Double sample) {
        ++this.numOffered;
        if (this.update(sample)) {
            ++this.numAccepted;
        }
    }

    @Override
    public Map<Statistic, Double> get() {
        Map<Statistic, Double> stats = CollectionFactory.map();
        for (Statistic s2 : this.getSupported()) {
            stats.put(s2, this.get(s2));
        }
        return stats;
    }

    protected abstract boolean update(Double var1);

    @Override
    public void addRange(Range<Double> range) {
        if (range != null) {
            if (this.rangesType == Range.Type.UNDEFINED) {
                this.rangesType = Range.Type.EXCLUDE;
            }
            this.ranges.add(new Range<Double>(range));
        }
    }

    @Override
    public void addRange(Range<Double> range, Range.Type rangesType) {
        if (range != null) {
            if (this.rangesType == Range.Type.UNDEFINED) {
                this.rangesType = rangesType;
            } else if (this.rangesType != rangesType) {
                throw new IllegalArgumentException("The provided rangesType is not compatible with the processors rangesType");
            }
            this.ranges.add(new Range<Double>(range));
        }
    }

    @Override
    public List<Range<Double>> getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    @Override
    public List<Range<Double>> getNoDataRanges() {
        return Collections.unmodifiableList(this.noDataRanges);
    }

    @Override
    public void setRangesType(Range.Type rangesType) {
        if (this.rangesType != Range.Type.UNDEFINED) {
            throw new UnsupportedOperationException("Cannot change RangesType once already defined");
        }
        this.rangesType = rangesType;
    }

    @Override
    public final Range.Type getRangesType() {
        return this.rangesType;
    }

    @Override
    public boolean isAccepted(Double sample) {
        if (sample == null) {
            return false;
        }
        if (sample.isNaN()) {
            ++this.numNaN;
            ++this.numNoData;
            return false;
        }
        if (this.noDataRanges != null) {
            for (Range<Double> r : this.noDataRanges) {
                if (!r.contains(sample)) continue;
                ++this.numNoData;
                return false;
            }
        }
        if (this.ranges == null || this.ranges.isEmpty()) {
            return true;
        }
        boolean isAccepted = this.rangesType != Range.Type.INCLUDE;
        for (Range<Double> r : this.ranges) {
            switch (this.rangesType) {
                case EXCLUDE: {
                    isAccepted &= !r.contains(sample);
                    break;
                }
                case INCLUDE: {
                    isAccepted |= r.contains(sample);
                }
            }
        }
        return isAccepted;
    }

    @Override
    public long getNumNoData() {
        return this.numNoData;
    }
}

