/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.geotools.metadata.i18n.Errors;

public class URLs {
    static final boolean IS_WINDOWS_OS = System.getProperty("os.name").toUpperCase().contains("WINDOWS");

    public static URL changeUrlExt(URL url, String postfix) throws IllegalArgumentException {
        String a2 = url.toString();
        int lastDotPos = a2.lastIndexOf(46);
        if (lastDotPos >= 0) {
            a2 = a2.substring(0, lastDotPos);
        }
        a2 = a2 + "." + postfix;
        try {
            return new URL(a2);
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException("Failed to create a new URL for " + url + " with new extension " + postfix, e2);
        }
    }

    public static URL extendUrl(URL base, String extension) throws MalformedURLException {
        if (base == null) {
            throw new NullPointerException(Errors.format(143, "base"));
        }
        if (extension == null) {
            throw new NullPointerException(Errors.format(143, "extension"));
        }
        String a2 = base.toString();
        if (!a2.endsWith("/")) {
            a2 = a2 + "/";
        }
        a2 = a2 + extension;
        return new URL(a2);
    }

    public static URL fileToUrl(File file) {
        try {
            String string = file.toURI().toASCIIString();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException e2) {
            return null;
        }
    }

    public static URL getParentUrl(URL url) throws MalformedURLException {
        String a2 = url.toString();
        int lastDotPos = a2.lastIndexOf(47);
        if (lastDotPos >= 0) {
            a2 = a2.substring(0, lastDotPos);
        }
        if (a2.endsWith("!")) {
            a2 = a2 + "/";
        }
        return new URL(a2);
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toString();
        if (url.getQuery() != null) {
            string = string.substring(0, string.indexOf("?"));
        }
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException("UTF-8 encoding not supported", e2);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        if (IS_WINDOWS_OS && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
            File f = new File(path3);
            if (!f.exists()) {
                path3 = path3.substring(2, path3.length());
            }
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath();
            try {
                path2 = URLDecoder.decode(path2, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e3) {
                throw new IllegalArgumentException("UTF-8 encoding not supported", e3);
            }
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }
}

