/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.measure.Units;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.CodeList;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class Parameter<T>
extends AbstractParameter
implements ParameterValue<T> {
    private static final long serialVersionUID = -5837826787089486776L;
    private T value;
    private Unit<?> unit;

    public Parameter(ParameterDescriptor<T> descriptor) {
        super(descriptor);
        this.value = descriptor.getDefaultValue();
        this.unit = descriptor.getUnit();
    }

    public Parameter(ParameterDescriptor<T> descriptor, T value) throws InvalidParameterValueException {
        super(descriptor);
        this.unit = descriptor.getUnit();
        this.setValue(value);
    }

    public static Parameter<Integer> create(String name, int value) {
        DefaultParameterDescriptor<Integer> descriptor = DefaultParameterDescriptor.create(name, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        Parameter<Integer> parameter = new Parameter<Integer>(descriptor);
        parameter.value = value;
        return parameter;
    }

    public static Parameter<Double> create(String name, double value, Unit<?> unit) {
        if (unit != null) {
            if (SI.METRE.isCompatible(unit)) {
                unit = SI.METRE;
            } else if (SI.DAY.isCompatible(unit)) {
                unit = SI.DAY;
            } else if (NonSI.DEGREE_ANGLE.isCompatible(unit)) {
                unit = NonSI.DEGREE_ANGLE;
            }
        }
        DefaultParameterDescriptor<Double> descriptor = DefaultParameterDescriptor.create(name, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, unit);
        Parameter<Double> parameter = new Parameter<Double>(descriptor);
        parameter.value = value;
        parameter.unit = unit;
        return parameter;
    }

    public static <T extends CodeList> Parameter<T> create(String name, Class<T> type, T value) {
        DefaultParameterDescriptor<Object> descriptor = DefaultParameterDescriptor.create(name, null, type, null, true);
        Parameter<Object> parameter = new Parameter<Object>(descriptor);
        parameter.value = value;
        return parameter;
    }

    public static <T> T ensureValidValue(ParameterDescriptor<T> descriptor, Object value) throws InvalidParameterValueException {
        String error;
        if (value == null) {
            return null;
        }
        Class<T> type = descriptor.getValueClass();
        if (!type.isInstance(value)) {
            error = Errors.format(72, Classes.getClass(value));
        } else {
            Comparable<Object> minimum = descriptor.getMinimumValue();
            Comparable<Object> maximum = descriptor.getMaximumValue();
            if (minimum != null && minimum.compareTo(value) > 0 || maximum != null && maximum.compareTo(value) < 0) {
                error = Errors.format(201, value, minimum, maximum);
            } else {
                Set<T> validValues = descriptor.getValidValues();
                if (validValues != null && !validValues.contains(value)) {
                    error = Errors.format(58, Parameter.getName(descriptor), value);
                } else {
                    return type.cast(value);
                }
            }
        }
        throw new InvalidParameterValueException(error, Parameter.getName(descriptor), value);
    }

    private String getClassTypeError() {
        return Errors.format(72, ((ParameterDescriptor)this.descriptor).getValueClass());
    }

    @Override
    public ParameterDescriptor<T> getDescriptor() {
        return (ParameterDescriptor)super.getDescriptor();
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    static int getUnitMessageID(Unit<?> unit) {
        if (AbstractUnit.ONE.isCompatible(unit) || Units.PPM.equals(unit)) {
            return 116;
        }
        if (SI.METRE.isCompatible(unit)) {
            return 113;
        }
        if (SI.SECOND.isCompatible(unit)) {
            return 117;
        }
        if (SI.RADIAN.isCompatible(unit)) {
            return 107;
        }
        return 76;
    }

    @Override
    public double doubleValue(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int expectedID = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        return Units.getConverterToAny(this.unit, unit).convert(this.doubleValue());
    }

    @Override
    public double doubleValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public int intValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public boolean booleanValue() throws InvalidParameterTypeException {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public String stringValue() throws InvalidParameterTypeException {
        if (this.value instanceof CharSequence) {
            return this.value.toString();
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int expectedID = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        UnitConverter converter = Units.getConverterToAny(this.unit, unit);
        double[] values = (double[])this.doubleValueList().clone();
        for (int i = 0; i < values.length; ++i) {
            values[i] = converter.convert(values[i]);
        }
        return values;
    }

    @Override
    public double[] doubleValueList() throws InvalidParameterTypeException {
        if (this.value instanceof double[]) {
            return (double[])this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public int[] intValueList() throws InvalidParameterTypeException {
        if (this.value instanceof int[]) {
            return (int[])this.value;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public URI valueFile() throws InvalidParameterTypeException {
        if (this.value instanceof URI) {
            return (URI)this.value;
        }
        if (this.value instanceof File) {
            return ((File)this.value).toURI();
        }
        URISyntaxException cause = null;
        try {
            if (this.value instanceof URL) {
                return ((URL)this.value).toURI();
            }
            if (this.value instanceof String) {
                return new URI((String)this.value);
            }
        }
        catch (URISyntaxException exception) {
            cause = exception;
        }
        String name = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, name));
        }
        InvalidParameterTypeException exception = new InvalidParameterTypeException(this.getClassTypeError(), name);
        if (cause != null) {
            exception.initCause(cause);
        }
        throw exception;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> targetUnit = descriptor.getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter(descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(targetUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new InvalidParameterValueException(Errors.format(expectedID, unit), descriptor.getName().getCode(), value);
        }
        Double converted = Units.getConverterToAny(unit, targetUnit).convert(value);
        Parameter.ensureValidValue(descriptor, converted);
        this.value = descriptor.getValueClass().cast(value);
        this.unit = unit;
    }

    @Override
    public void setValue(double value) throws InvalidParameterValueException {
        Double check = value;
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(descriptor, check);
    }

    @Override
    public void setValue(int value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Class type = descriptor.getValueClass();
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            this.setValue((double)value);
            return;
        }
        Integer check = value;
        this.value = Parameter.ensureValidValue(descriptor, check);
    }

    @Override
    public void setValue(boolean value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Boolean check = value;
        this.value = Parameter.ensureValidValue(descriptor, check);
    }

    @Override
    public void setValue(Object value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(descriptor, value);
    }

    @Override
    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> targetUnit = descriptor.getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter(descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(targetUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        double[] converted = (double[])values.clone();
        UnitConverter converter = Units.getConverterToAny(unit, targetUnit);
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = converter.convert(converted[i]);
        }
        this.value = Parameter.ensureValidValue(descriptor, converted);
        this.unit = unit;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter that = (Parameter)object;
            return Utilities.equals(this.value, that.value) && Utilities.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() * 37;
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.unit != null) {
            code += 37 * this.unit.hashCode();
        }
        return code ^ 0x9F456C48;
    }

    @Override
    public Parameter clone() {
        return (Parameter)super.clone();
    }
}

