/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Color;
import java.io.Writer;
import java.util.Locale;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.parameter.ParameterWriter;
import org.opengis.util.InternationalString;

final class CoverageParameterWriter
extends ParameterWriter {
    public CoverageParameterWriter(Writer out) {
        super(out);
    }

    @Override
    protected String formatValue(Object value) {
        if (KernelJAI.GRADIENT_MASK_SOBEL_HORIZONTAL.equals(value)) {
            return "GRADIENT_MASK_SOBEL_HORIZONTAL";
        }
        if (KernelJAI.GRADIENT_MASK_SOBEL_VERTICAL.equals(value)) {
            return "GRADIENT_MASK_SOBEL_VERTICAL";
        }
        if (value instanceof AbstractCoverage) {
            InternationalString name = ((AbstractCoverage)value).getName();
            Locale locale = this.getLocale();
            return name != null ? name.toString(locale) : Vocabulary.getResources(locale).getString(232);
        }
        if (value instanceof Interpolation) {
            return ImageUtilities.getInterpolationName((Interpolation)value);
        }
        if (value instanceof EnumeratedParameter) {
            return ((EnumeratedParameter)value).getName();
        }
        if (value instanceof Color) {
            Color c2 = (Color)value;
            return "RGB[" + c2.getRed() + ',' + c2.getGreen() + ',' + c2.getBlue() + ']';
        }
        return super.formatValue(value);
    }
}

