/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.regular.square.PartialRegularSquareGrid;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.LandscapeStructureSolver;
import org.flsgen.utils.CheckLandscape;
import org.flsgen.utils.RasterConnectivityFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;

public class LandscapeStructure {
    protected int nbRows;
    protected int nbCols;
    protected String[] names;
    protected int[] totalSize;
    protected int[] nbPatches;
    protected int[][] patchSizes;
    protected long[] npro;
    protected LandscapeStructureSolver s;
    protected RegularSquareGrid grid;
    protected String maskRasterPath;

    public LandscapeStructure(int nbRows, int nbCols, String maskRasterPath, int[] noDataCells, String[] names, int[] totalSize, int[] nbPatches, int[][] patchSizes, long[] npro) {
        this.nbRows = nbRows;
        this.nbCols = nbCols;
        this.maskRasterPath = maskRasterPath;
        this.names = names;
        this.totalSize = totalSize;
        this.nbPatches = nbPatches;
        this.patchSizes = patchSizes;
        this.npro = npro;
        this.grid = noDataCells.length > 0 ? new PartialRegularSquareGrid(nbRows, nbCols, noDataCells) : new RegularSquareGrid(nbRows, nbCols);
    }

    public LandscapeStructure(int nbRows, int nbCols, String[] names, int[] totalSize, int[] nbPatches, int[][] patchSizes, long[] npro) {
        this(nbRows, nbCols, null, new int[0], names, totalSize, nbPatches, patchSizes, npro);
    }

    public LandscapeStructure(LandscapeStructureSolver s2) {
        this.s = s2;
        this.grid = s2.getGrid();
        this.nbRows = s2.getGrid().getNbRows();
        this.nbCols = s2.getGrid().getNbCols();
        if (s2.maskRasterPath != null) {
            this.maskRasterPath = s2.maskRasterPath;
        }
        this.names = new String[s2.landscapeClasses.size()];
        this.totalSize = new int[s2.landscapeClasses.size()];
        this.nbPatches = new int[s2.landscapeClasses.size()];
        this.patchSizes = new int[s2.landscapeClasses.size()][];
        this.npro = new long[s2.landscapeClasses.size()];
        for (int i = 0; i < s2.landscapeClasses.size(); ++i) {
            this.names[i] = s2.landscapeClasses.get((int)i).name;
            this.nbPatches[i] = s2.landscapeClasses.get(i).getNbPatches();
            this.patchSizes[i] = s2.landscapeClasses.get(i).getPatchSizes();
            this.npro[i] = s2.landscapeClasses.get(i).getNetProduct();
            this.totalSize[i] = s2.landscapeClasses.get(i).getTotalSize();
        }
    }

    public String toJSON() {
        JsonObject json = new JsonObject();
        json.put("nbRows", this.getNbRows());
        json.put("nbCols", this.getNbCols());
        if (this.maskRasterPath != null) {
            json.put("maskRasterPath", this.maskRasterPath);
        }
        json.put("NON_FOCAL_PLAND", this.getNonFocalLandscapeProportion());
        JsonArray classes = new JsonArray();
        for (int i = 0; i < this.names.length; ++i) {
            JsonObject cl = new JsonObject();
            cl.put("name", this.names[i]);
            cl.put("CA", this.totalSize[i]);
            cl.put("NP", this.nbPatches[i]);
            JsonArray sizes = new JsonArray();
            for (int s2 : this.patchSizes[i]) {
                sizes.add(s2);
            }
            cl.put("AREA", sizes);
            cl.put("AREA_MN", this.getMeanPatchArea(i));
            cl.put("NPRO", this.npro[i]);
            cl.put("MESH", this.getMesh(i));
            cl.put("SPLI", this.getSplittingIndex(i));
            cl.put("SDEN", this.getSplittingDensity(i));
            cl.put("COHE", this.getDegreeOfCoherence(i));
            cl.put("DIVI", this.getDegreeOfDivision(i));
            cl.put("PLAND", this.getLandscapeProportion(i));
            cl.put("PD", this.getPatchDensity(i));
            cl.put("SPI", this.getSmallestPatchIndex(i));
            cl.put("LPI", this.getLargestPatchIndex(i));
            classes.add(cl);
        }
        json.put("classes", classes);
        return Jsoner.prettyPrint(json.toJson());
    }

    public static LandscapeStructure fromJSON(Reader reader) throws JsonException, IOException {
        JsonObject structure = (JsonObject)Jsoner.deserialize(reader);
        JsonArray classes = (JsonArray)structure.get("classes");
        String[] names = new String[classes.size()];
        int[] totalSize = new int[classes.size()];
        int[] nbPatches = new int[classes.size()];
        int[][] patchSizes = new int[classes.size()][];
        long[] npro = new long[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            JsonObject c2 = (JsonObject)classes.get(i);
            names[i] = (String)c2.get("name");
            JsonArray sizes = (JsonArray)c2.get("AREA");
            patchSizes[i] = new int[sizes.size()];
            for (int j = 0; j < sizes.size(); ++j) {
                patchSizes[i][j] = Integer.parseInt(sizes.get(j).toString());
            }
            nbPatches[i] = patchSizes[i].length;
            if (c2.containsKey("NPRO")) {
                npro[i] = Long.parseLong(c2.get("NPRO").toString());
                continue;
            }
            long netProduct = 0L;
            for (int p : patchSizes[i]) {
                netProduct += Long.valueOf(p) * Long.valueOf(p);
            }
            npro[i] = netProduct;
        }
        if (structure.containsKey("maskRasterPath")) {
            String maskRasterPath = structure.get("maskRasterPath").toString();
            int[] dimensions = CheckLandscape.getDimensions(maskRasterPath);
            return new LandscapeStructure(dimensions[0], dimensions[1], maskRasterPath, CheckLandscape.getNodataCells(maskRasterPath), names, totalSize, nbPatches, patchSizes, npro);
        }
        int nbRows = Integer.parseInt(structure.get("nbRows").toString());
        int nbCols = Integer.parseInt(structure.get("nbCols").toString());
        return new LandscapeStructure(nbRows, nbCols, names, totalSize, nbPatches, patchSizes, npro);
    }

    public static LandscapeStructure fromRaster(String rasterPath, int[] focalClasses, INeighborhood neighborhood) throws IOException {
        return LandscapeStructure.fromRaster(rasterPath, focalClasses, neighborhood, true);
    }

    public static LandscapeStructure fromRaster(String rasterPath, int[] focalClasses, INeighborhood neighborhood, boolean discardNoData) throws IOException {
        File file = new File(rasterPath);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        int nbRows = gridCov.getRenderedImage().getHeight();
        int nbCols = gridCov.getRenderedImage().getWidth();
        int[] values = new int[nbRows * nbCols];
        gridCov.getRenderedImage().getData().getSamples(0, 0, nbCols, nbRows, 0, values);
        gridCov.dispose(true);
        reader.dispose();
        String[] names = (String[])IntStream.of(focalClasses).mapToObj(i -> "" + i).toArray(String[]::new);
        int[] nbPatches = new int[focalClasses.length];
        int[] totalSize = new int[focalClasses.length];
        int[][] patchSizes = new int[focalClasses.length][];
        long[] npro = new long[focalClasses.length];
        for (int k = 0; k < focalClasses.length; ++k) {
            int nbCC;
            int classId = focalClasses[k];
            RasterConnectivityFinder cf = new RasterConnectivityFinder(nbRows, nbCols, values, classId, neighborhood);
            totalSize[k] = cf.getNbNodes();
            cf.findAllCC();
            nbPatches[k] = nbCC = cf.getNBCC();
            patchSizes[k] = new int[nbCC];
            for (int i2 = 0; i2 < nbCC; ++i2) {
                patchSizes[k][i2] = cf.getSizeCC()[i2];
            }
            npro[k] = cf.getNpro();
            Arrays.sort(patchSizes[k]);
        }
        if (discardNoData) {
            int[] noDataCells = CheckLandscape.getNodataCells(rasterPath);
            return new LandscapeStructure(nbRows, nbCols, rasterPath, noDataCells, names, totalSize, nbPatches, patchSizes, npro);
        }
        return new LandscapeStructure(nbRows, nbCols, names, totalSize, nbPatches, patchSizes, npro);
    }

    public int getLandscapeSize() {
        return this.grid.getNbCells();
    }

    public double getNonFocalLandscapeProportion() {
        return 100.0 * (1.0 * (double)(this.getLandscapeSize() - Arrays.stream(this.totalSize).sum()) / (1.0 * (double)this.getLandscapeSize()));
    }

    public int getNbPatches(int classId) {
        return this.nbPatches[classId];
    }

    public int[] getPatchSizes(int classId) {
        return this.patchSizes[classId];
    }

    public double getMeanPatchArea(int classId) {
        return 1.0 * (double)this.totalSize[classId] / (1.0 * (double)this.nbPatches[classId]);
    }

    public int getTotalSize(int classId) {
        return this.totalSize[classId];
    }

    public double getLandscapeProportion(int classId) {
        return 100.0 * (1.0 * (double)this.getTotalSize(classId)) / (1.0 * (double)this.getLandscapeSize());
    }

    public double getPatchDensity(int classId) {
        return 1.0 * (double)this.getNbPatches(classId) / (1.0 * (double)this.getLandscapeSize());
    }

    public int getSmallestPatchIndex(int classId) {
        if (this.getNbPatches(classId) > 0) {
            return this.getPatchSizes(classId)[0];
        }
        return -1;
    }

    public int getLargestPatchIndex(int classId) {
        if (this.getNbPatches(classId) > 0) {
            return this.getPatchSizes(classId)[this.getNbPatches(classId) - 1];
        }
        return -1;
    }

    public long getNetProduct(int classId) {
        return this.npro[classId];
    }

    public double getMesh(int classId) {
        return 1.0 * (double)this.getNetProduct(classId) / (1.0 * (double)this.getLandscapeSize());
    }

    public double getSplittingIndex(int classId) {
        return 1.0 * (double)this.getLandscapeSize() * (double)this.getLandscapeSize() / (1.0 * (double)this.getNetProduct(classId));
    }

    public double getSplittingDensity(int classId) {
        return 1.0 * (double)this.getLandscapeSize() / (1.0 * (double)this.getNetProduct(classId));
    }

    public double getDegreeOfCoherence(int classId) {
        return 1.0 * (double)this.getNetProduct(classId) / (1.0 * (double)this.getLandscapeSize() * (double)this.getLandscapeSize());
    }

    public double getDegreeOfDivision(int classId) {
        return 1.0 - this.getDegreeOfCoherence(classId);
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public int getNbCols() {
        return this.nbCols;
    }
}

