/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.block;

import org.ejml.data.DSubmatrixD1;
import org.ejml.dense.block.InnerMultiplication_DDRB;

public class InnerRankUpdate_DDRB {
    public static void rankNUpdate(int blockLength, double alpha, DSubmatrixD1 A2, DSubmatrixD1 B) {
        int heightB = B.row1 - B.row0;
        if (heightB > blockLength) {
            throw new IllegalArgumentException("Height of B cannot be greater than the block length");
        }
        int N = B.col1 - B.col0;
        if (A2.col1 - A2.col0 != N) {
            throw new IllegalArgumentException("A does not have the expected number of columns based on B's width");
        }
        if (A2.row1 - A2.row0 != N) {
            throw new IllegalArgumentException("A does not have the expected number of rows based on B's width");
        }
        for (int i = B.col0; i < B.col1; i += blockLength) {
            int indexB_i = B.row0 * B.original.numCols + i * heightB;
            int widthB_i = Math.min(blockLength, B.col1 - i);
            int rowA = i - B.col0 + A2.row0;
            int heightA = Math.min(blockLength, A2.row1 - rowA);
            for (int j = B.col0; j < B.col1; j += blockLength) {
                int widthB_j = Math.min(blockLength, B.col1 - j);
                int indexA = rowA * A2.original.numCols + (j - B.col0 + A2.col0) * heightA;
                int indexB_j = B.row0 * B.original.numCols + j * heightB;
                InnerMultiplication_DDRB.blockMultPlusTransA(alpha, B.original.data, B.original.data, A2.original.data, indexB_i, indexB_j, indexA, heightB, widthB_i, widthB_j);
            }
        }
    }

    public static void symmRankNMinus_U(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B) {
        int heightB = B.row1 - B.row0;
        if (heightB > blockLength) {
            throw new IllegalArgumentException("Height of B cannot be greater than the block length");
        }
        int N = B.col1 - B.col0;
        if (A2.col1 - A2.col0 != N) {
            throw new IllegalArgumentException("A does not have the expected number of columns based on B's width");
        }
        if (A2.row1 - A2.row0 != N) {
            throw new IllegalArgumentException("A does not have the expected number of rows based on B's width");
        }
        for (int i = B.col0; i < B.col1; i += blockLength) {
            int indexB_i = B.row0 * B.original.numCols + i * heightB;
            int widthB_i = Math.min(blockLength, B.col1 - i);
            int rowA = i - B.col0 + A2.row0;
            int heightA = Math.min(blockLength, A2.row1 - rowA);
            for (int j = i; j < B.col1; j += blockLength) {
                int widthB_j = Math.min(blockLength, B.col1 - j);
                int indexA = rowA * A2.original.numCols + (j - B.col0 + A2.col0) * heightA;
                int indexB_j = B.row0 * B.original.numCols + j * heightB;
                if (i == j) {
                    InnerRankUpdate_DDRB.multTransABlockMinus_U(B.original.data, A2.original.data, indexB_i, indexB_j, indexA, heightB, widthB_i, widthB_j);
                    continue;
                }
                InnerRankUpdate_DDRB.multTransABlockMinus(B.original.data, A2.original.data, indexB_i, indexB_j, indexA, heightB, widthB_i, widthB_j);
            }
        }
    }

    public static void symmRankNMinus_L(int blockLength, DSubmatrixD1 A2, DSubmatrixD1 B) {
        int widthB = B.col1 - B.col0;
        if (widthB > blockLength) {
            throw new IllegalArgumentException("Width of B cannot be greater than the block length");
        }
        int N = B.row1 - B.row0;
        if (A2.col1 - A2.col0 != N) {
            throw new IllegalArgumentException("A does not have the expected number of columns based on B's height");
        }
        if (A2.row1 - A2.row0 != N) {
            throw new IllegalArgumentException("A does not have the expected number of rows based on B's height");
        }
        for (int i = B.row0; i < B.row1; i += blockLength) {
            int heightB_i = Math.min(blockLength, B.row1 - i);
            int indexB_i = i * B.original.numCols + heightB_i * B.col0;
            int rowA = i - B.row0 + A2.row0;
            int heightA = Math.min(blockLength, A2.row1 - rowA);
            for (int j = B.row0; j <= i; j += blockLength) {
                int widthB_j = Math.min(blockLength, B.row1 - j);
                int indexA = rowA * A2.original.numCols + (j - B.row0 + A2.col0) * heightA;
                int indexB_j = j * B.original.numCols + widthB_j * B.col0;
                if (i == j) {
                    InnerRankUpdate_DDRB.multTransBBlockMinus_L(B.original.data, A2.original.data, indexB_i, indexB_j, indexA, widthB, heightB_i, widthB_j);
                    continue;
                }
                InnerRankUpdate_DDRB.multTransBBlockMinus(B.original.data, A2.original.data, indexB_i, indexB_j, indexA, widthB, heightB_i, widthB_j);
            }
        }
    }

    protected static void multTransABlockMinus(double[] dataA, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        int rowB = indexB;
        int endLoopK = rowB + heightA * widthC;
        int startA = indexA;
        while (rowB != endLoopK) {
            int a2 = startA;
            int c2 = indexC;
            int endA = a2 + widthA;
            int endB = rowB + widthC;
            while (a2 != endA) {
                double valA = dataA[a2++];
                int b2 = rowB;
                while (b2 != endB) {
                    int n = c2++;
                    dataC[n] = dataC[n] - valA * dataA[b2++];
                }
            }
            rowB += widthC;
            startA += widthA;
        }
    }

    protected static void multTransABlockMinus_U(double[] dataA, double[] dataC, int indexA, int indexB, int indexC, int heightA, int widthA, int widthC) {
        for (int i = 0; i < widthA; ++i) {
            for (int k = 0; k < heightA; ++k) {
                double valA = dataA[k * widthA + i + indexA];
                int b2 = k * widthC + indexB + i;
                int c2 = i * widthC + indexC + i;
                int endC = c2 - i + widthC;
                while (c2 != endC) {
                    int n = c2++;
                    dataC[n] = dataC[n] - valA * dataA[b2++];
                }
            }
        }
    }

    protected static void multTransBBlockMinus(double[] dataA, double[] dataC, int indexA, int indexB, int indexC, int widthA, int heightA, int widthC) {
        int rowA = indexA;
        int c2 = indexC;
        int i = 0;
        while (i < heightA) {
            int endA = rowA + widthA;
            int rowB = indexB;
            int endLoopJ = c2 + widthC;
            while (c2 != endLoopJ) {
                int a2 = rowA;
                int b2 = rowB;
                double sum = 0.0;
                while (a2 != endA) {
                    sum += dataA[a2++] * dataA[b2++];
                }
                int n = c2++;
                dataC[n] = dataC[n] - sum;
                rowB += widthA;
            }
            ++i;
            rowA += widthA;
        }
    }

    protected static void multTransBBlockMinus_L(double[] dataA, double[] dataC, int indexA, int indexB, int indexC, int widthA, int heightA, int widthC) {
        for (int i = 0; i < heightA; ++i) {
            int rowA = i * widthA + indexA;
            int endA = rowA + widthA;
            int rowB = indexB;
            int rowC = i * widthC + indexC;
            int j = 0;
            while (j <= i) {
                double sum = 0.0;
                int a2 = rowA;
                int b2 = rowB;
                while (a2 != endA) {
                    sum += dataA[a2++] * dataA[b2++];
                }
                int n = rowC + j;
                dataC[n] = dataC[n] - sum;
                ++j;
                rowB += widthA;
            }
        }
    }
}

