/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropImplied
extends Propagator<Variable> {
    private final BoolVar impR;
    private final Constraint impC;

    private static Variable[] extractVars(Constraint c2, BoolVar r) {
        HashSet<BoolVar> setOfVars = new HashSet<BoolVar>();
        setOfVars.add(r);
        for (Propagator p : c2.getPropagators()) {
            Collections.addAll(setOfVars, p.getVars());
        }
        Variable[] allVars = setOfVars.toArray(new Variable[0]);
        Arrays.sort(allVars, Comparator.comparingInt(Identity::getId));
        return allVars;
    }

    public PropImplied(BoolVar r, Constraint c2) {
        super(PropImplied.extractVars(c2, r), (Priority)PropagatorPriority.LINEAR, false);
        this.impC = c2;
        this.impC.ignore();
        this.impR = r;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.impR.isInstantiated()) {
            if (this.impR.isInstantiatedTo(1)) {
                this.model.postTemp(this.impC);
            }
            this.setPassive();
        } else if (ESat.FALSE.equals((Object)this.impC.isSatisfied())) {
            this.impR.instantiateTo(0, this);
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.impR.isInstantiatedTo(1)) {
            return this.impC.isSatisfied();
        }
        if (this.impR.isInstantiatedTo(0)) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

