/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.FA;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.util.tools.StringUtils;

public class FiniteAutomaton
implements IAutomaton {
    private Automaton representedBy;
    private TObjectIntHashMap<State> stateToIndex;
    private ArrayList<State> states;
    private TIntHashSet alphabet;
    private int nbStates;
    private final HashSet<State> nexts = new HashSet();
    private int min = 0;
    private int max = 65535;
    private static final TIntIntHashMap charFromIntMap = new TIntIntHashMap(16, 0.5f, -1, -1);
    private static final TIntIntHashMap intFromCharMap = new TIntIntHashMap(16, 0.5f, -1, -1);

    public FiniteAutomaton() {
        this.representedBy = new Automaton();
        this.stateToIndex = new TObjectIntHashMap();
        this.states = new ArrayList();
        this.alphabet = new TIntHashSet();
    }

    public FiniteAutomaton(String regexp, int min2, int max) {
        this();
        String correct = StringUtils.toCharExp(regexp);
        this.representedBy = new RegExp(correct).toAutomaton();
        this.min = Math.max(0, min2);
        this.max = Math.min(65535, max);
        this.syncStates();
    }

    public FiniteAutomaton(String regexp) {
        this(regexp, 0, 65535);
    }

    public FiniteAutomaton(FiniteAutomaton other) {
        this.perfectCopy(other);
    }

    private FiniteAutomaton(Automaton a2, TIntHashSet alphabet) {
        this();
        this.fill(a2, alphabet);
    }

    public static int getIntFromChar(char c2) {
        return intFromCharMap.get(c2);
    }

    public static char getCharFromInt(int i) {
        int c2 = charFromIntMap.get(i);
        if (c2 > -1) {
            return (char)charFromIntMap.get(i);
        }
        throw new SolverException("Unknown value \"" + i + "\". Note that only integers in [" + 0 + "," + 65535 + "] are allowed by FiniteAutomaton.");
    }

    public static int max(TIntHashSet hs) {
        int max = Integer.MIN_VALUE;
        TIntIterator it = hs.iterator();
        while (it.hasNext()) {
            int n = it.next();
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private static int min(TIntHashSet hs) {
        int min2 = Integer.MAX_VALUE;
        TIntIterator it = hs.iterator();
        while (it.hasNext()) {
            int n = it.next();
            if (n >= min2) continue;
            min2 = n;
        }
        return min2;
    }

    public void fill(Automaton a2, TIntHashSet alphabet) {
        int max = FiniteAutomaton.max(alphabet);
        int min2 = FiniteAutomaton.min(alphabet);
        this.setDeterministic(a2.isDeterministic());
        HashMap<State, State> m3 = new HashMap<State, State>();
        Set<State> states = a2.getStates();
        for (State s2 : states) {
            this.addState();
            State ns = this.states.get(this.states.size() - 1);
            m3.put(s2, ns);
        }
        for (State s2 : states) {
            State p = (State)m3.get(s2);
            int source = this.stateToIndex.get(p);
            p.setAccept(s2.isAccept());
            if (a2.getInitialState().equals(s2)) {
                this.representedBy.setInitialState(p);
            }
            for (Transition t : s2.getTransitions()) {
                int tmin = FiniteAutomaton.getIntFromChar(t.getMin());
                int tmax = FiniteAutomaton.getIntFromChar(t.getMax());
                State dest = (State)m3.get(t.getDest());
                int desti = this.stateToIndex.get(dest);
                int minmax = Math.min(max, tmax);
                for (int i = Math.max(min2, tmin); i <= minmax; ++i) {
                    if (!alphabet.contains(i)) continue;
                    this.addTransition(source, desti, i);
                }
            }
        }
    }

    @Override
    public int getNbStates() {
        return this.nbStates;
    }

    public int getNbSymbols() {
        return this.alphabet.size();
    }

    public int addState() {
        int idx = this.states.size();
        State s2 = new State();
        this.states.add(s2);
        this.stateToIndex.put(s2, idx);
        ++this.nbStates;
        return idx;
    }

    public void removeSymbolFromAutomaton(int symbol) {
        char c2 = FiniteAutomaton.getCharFromInt(symbol);
        ArrayList<IAutomaton.Triple> triples = new ArrayList<IAutomaton.Triple>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s2 = this.states.get(i);
            for (Transition transition : s2.getTransitions()) {
                if (transition.getMin() > c2 || transition.getMax() < c2) continue;
                triples.add(new IAutomaton.Triple(i, this.stateToIndex.get(transition.getDest()), symbol));
            }
            for (IAutomaton.Triple triple : triples) {
                this.deleteTransition(triple.a, triple.b, triple.c);
            }
            triples.clear();
        }
        this.alphabet.remove(symbol);
    }

    public void addTransition(int source, int destination, int ... symbols) {
        for (int symbol : symbols) {
            try {
                this.checkState(source, destination);
            }
            catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
                // empty catch block
            }
            this.alphabet.add(symbol);
            State s2 = this.states.get(source);
            State d2 = this.states.get(destination);
            s2.addTransition(new Transition(FiniteAutomaton.getCharFromInt(symbol), d2));
        }
    }

    public void deleteTransition(int source, int destination, int symbol) {
        try {
            this.checkState(source, destination);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        State s2 = this.states.get(source);
        State d2 = this.states.get(destination);
        Set<Transition> transitions = s2.getTransitions();
        HashSet<Transition> nTrans = new HashSet<Transition>();
        char c2 = FiniteAutomaton.getCharFromInt(symbol);
        Iterator<Transition> it = transitions.iterator();
        while (it.hasNext()) {
            Transition t = it.next();
            if (!t.getDest().equals(d2) || t.getMin() > c2 || t.getMax() < c2) continue;
            it.remove();
            if (t.getMin() == c2 && c2 < t.getMax()) {
                nTrans.add(new Transition((char)(c2 + '\u0001'), t.getMax(), d2));
                continue;
            }
            if (t.getMin() > c2 && c2 == t.getMax()) {
                nTrans.add(new Transition(t.getMin(), (char)(c2 - '\u0001'), d2));
                continue;
            }
            if (t.getMin() >= c2 || c2 >= t.getMax()) continue;
            nTrans.add(new Transition(t.getMin(), (char)(c2 - '\u0001'), d2));
            nTrans.add(new Transition((char)(c2 + '\u0001'), t.getMax(), d2));
        }
        transitions.addAll(nTrans);
    }

    @Override
    public int delta(int source, int symbol) throws IAutomaton.NonDeterministicOperationException {
        if (!this.representedBy.isDeterministic()) {
            throw new IAutomaton.NonDeterministicOperationException();
        }
        try {
            this.checkState(source);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        State s2 = this.states.get(source);
        State d2 = s2.step(FiniteAutomaton.getCharFromInt(symbol));
        if (d2 != null) {
            return this.stateToIndex.get(d2);
        }
        return -1;
    }

    @Override
    public void delta(int source, int symbol, TIntHashSet states) {
        try {
            this.checkState(source);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        State s2 = this.states.get(source);
        this.nexts.clear();
        s2.step(FiniteAutomaton.getCharFromInt(symbol), this.nexts);
        for (State to : this.nexts) {
            states.add(this.stateToIndex.get(to));
        }
    }

    public void addToAlphabet(int a2) {
        this.alphabet.add(a2);
    }

    public void removeFromAlphabet(int a2) {
        this.alphabet.remove(a2);
    }

    @Override
    public int getInitialState() {
        State s2 = this.representedBy.getInitialState();
        if (s2 == null) {
            return -1;
        }
        return this.stateToIndex.get(s2);
    }

    @Override
    public boolean isFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        return this.states.get(state).isAccept();
    }

    @Override
    public boolean isNotFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        return !this.states.get(state).isAccept();
    }

    public void setInitialState(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        this.representedBy.setInitialState(this.states.get(state));
    }

    public void setFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        this.states.get(state).setAccept(true);
    }

    public void setFinal(int ... states) {
        for (int s2 : states) {
            this.setFinal(s2);
        }
    }

    public void setNonFinal(int state) {
        try {
            this.checkState(state);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        this.states.get(state).setAccept(false);
    }

    public void setNonFInal(int ... states) {
        for (int s2 : states) {
            this.setNonFinal(s2);
        }
    }

    @Override
    public boolean run(int[] word) {
        StringBuilder b2 = new StringBuilder();
        for (int i : word) {
            char c2 = FiniteAutomaton.getCharFromInt(i);
            b2.append(c2);
        }
        return this.representedBy.run(b2.toString());
    }

    public Automaton makeBricsAutomaton() {
        return this.representedBy.clone();
    }

    public IAutomaton repeat() {
        return new FiniteAutomaton(this.representedBy.repeat(), this.alphabet);
    }

    public IAutomaton repeat(int min2) {
        return new FiniteAutomaton(this.representedBy.repeat(min2), this.alphabet);
    }

    public IAutomaton repeat(int min2, int max) {
        return new FiniteAutomaton(this.representedBy.repeat(min2, max), this.alphabet);
    }

    public void minimize() {
        this.representedBy.minimize();
        this.syncStates();
    }

    public void reduce() {
        this.representedBy.reduce();
        this.syncStates();
    }

    public void removeDeadTransitions() {
        this.representedBy.removeDeadTransitions();
        this.syncStates();
    }

    public FiniteAutomaton union(FiniteAutomaton otherI) {
        Automaton union = this.representedBy.union(otherI.representedBy);
        TIntHashSet alphabet = new TIntHashSet(this.alphabet.toArray());
        alphabet.addAll(otherI.alphabet.toArray());
        return new FiniteAutomaton(union, alphabet);
    }

    public FiniteAutomaton intersection(IAutomaton otherI) {
        FiniteAutomaton other = (FiniteAutomaton)otherI;
        Automaton inter = this.representedBy.intersection(other.representedBy);
        TIntHashSet alphabet = new TIntHashSet();
        for (int a2 : this.alphabet.toArray()) {
            if (!other.alphabet.contains(a2)) continue;
            alphabet.add(a2);
        }
        return new FiniteAutomaton(inter, alphabet);
    }

    public FiniteAutomaton complement(TIntHashSet alphabet) {
        Automaton comp = this.representedBy.complement();
        return new FiniteAutomaton(comp, alphabet);
    }

    public FiniteAutomaton complement() {
        return this.complement(this.alphabet);
    }

    public FiniteAutomaton concatenate(FiniteAutomaton otherI) {
        Automaton conc = this.representedBy.concatenate(otherI.representedBy);
        TIntHashSet alphabet = new TIntHashSet(this.alphabet.toArray());
        alphabet.addAll(otherI.alphabet.toArray());
        return new FiniteAutomaton(conc, alphabet);
    }

    public void addEpsilon(int source, int destination) {
        try {
            this.checkState(source, destination);
        }
        catch (IAutomaton.StateNotInAutomatonException stateNotInAutomatonException) {
            // empty catch block
        }
        State s2 = this.states.get(source);
        State d2 = this.states.get(destination);
        ArrayList<StatePair> pairs = new ArrayList<StatePair>();
        pairs.add(new StatePair(s2, d2));
        this.representedBy.addEpsilons(pairs);
    }

    public boolean isDeterministic() {
        return this.representedBy.isDeterministic();
    }

    public void setDeterministic(boolean deterministic) {
        this.representedBy.setDeterministic(deterministic);
    }

    public TIntHashSet getFinalStates() {
        TIntHashSet finals = new TIntHashSet();
        for (int i = 0; i < this.states.size(); ++i) {
            if (!this.states.get(i).isAccept()) continue;
            finals.add(i);
        }
        return finals;
    }

    public void toDotty(String f) {
        String s2 = this.toDot();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(f)));
            bw.write(s2);
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toDot() {
        StringBuilder b2 = new StringBuilder("digraph Automaton {\n");
        b2.append("  rankdir = LR;\n");
        Set<State> states = this.representedBy.getStates();
        for (State s2 : states) {
            int idx = this.stateToIndex.get(s2);
            b2.append("  ").append(idx);
            if (s2.isAccept()) {
                b2.append(" [shape=doublecircle];\n");
            } else {
                b2.append(" [shape=circle];\n");
            }
            if (s2 == this.representedBy.getInitialState()) {
                b2.append("  initial [shape=plaintext,label=\"\"];\n");
                b2.append("  initial -> ").append(idx).append("\n");
            }
            for (Transition t : s2.getTransitions()) {
                b2.append("  ").append(idx);
                this.appendDot(t, b2);
            }
        }
        return b2.append("}\n").toString();
    }

    public TIntHashSet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public List<int[]> getTransitions() {
        ArrayList<int[]> transitions = new ArrayList<int[]>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s2 = this.states.get(i);
            for (Transition t : s2.getTransitions()) {
                int dest = this.stateToIndex.get(t.getDest());
                char m3 = (char)Math.max(this.min, t.getMin());
                char M = (char)Math.min(this.max, t.getMax());
                for (char c2 = m3; c2 <= M; c2 = (char)(c2 + '\u0001')) {
                    int symbol = FiniteAutomaton.getIntFromChar(c2);
                    transitions.add(new int[]{i, dest, symbol});
                }
            }
        }
        return transitions;
    }

    @Override
    public List<int[]> getTransitions(int state) {
        ArrayList<int[]> transitions = new ArrayList<int[]>();
        for (Transition t : this.states.get(state).getTransitions()) {
            int dest = this.stateToIndex.get(t.getDest());
            char m3 = (char)Math.max(this.min, t.getMin());
            char M = (char)Math.min(this.max, t.getMax());
            for (char c2 = m3; c2 <= M; c2 = (char)(c2 + '\u0001')) {
                int symbol = FiniteAutomaton.getIntFromChar(c2);
                transitions.add(new int[]{state, dest, symbol});
            }
        }
        return transitions;
    }

    public ArrayList<int[]> _removeSymbolFromAutomaton(int alpha) {
        char c2 = FiniteAutomaton.getCharFromInt(alpha);
        TIntHashSet setOfRemoved = new TIntHashSet();
        ArrayList<IAutomaton.Triple> triples = new ArrayList<IAutomaton.Triple>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s2 = this.states.get(i);
            for (Transition transition : s2.getTransitions()) {
                if (transition.getMin() > c2 || transition.getMax() < c2) continue;
                triples.add(new IAutomaton.Triple(i, this.stateToIndex.get(transition.getDest()), alpha));
                setOfRemoved.add(i);
            }
            for (IAutomaton.Triple triple : triples) {
                this.deleteTransition(triple.a, triple.b, triple.c);
            }
            triples.clear();
        }
        this.alphabet.remove(alpha);
        ArrayList<int[]> couple = new ArrayList<int[]>();
        for (int i = 0; i < this.states.size(); ++i) {
            State s3 = this.states.get(i);
            for (Transition t : s3.getTransitions()) {
                int dest = this.stateToIndex.get(t.getDest());
                if (!setOfRemoved.contains(dest)) continue;
                for (char d2 = t.getMin(); d2 <= t.getMax(); d2 = (char)(d2 + '\u0001')) {
                    couple.add(new int[]{i, FiniteAutomaton.getIntFromChar(d2)});
                }
            }
        }
        return couple;
    }

    @Override
    public FiniteAutomaton clone() throws CloneNotSupportedException {
        FiniteAutomaton auto = (FiniteAutomaton)super.clone();
        auto.representedBy = new Automaton();
        auto.states = new ArrayList();
        auto.stateToIndex = new TObjectIntHashMap();
        auto.alphabet = new TIntHashSet();
        auto.nbStates = this.nbStates;
        for (int i = 0; i < this.nbStates; ++i) {
            State s2 = new State();
            auto.states.add(s2);
            auto.stateToIndex.put(s2, i);
            if (!this.isNotFinal(i)) {
                s2.setAccept(true);
            }
            if (this.getInitialState() != i) continue;
            auto.representedBy.setInitialState(s2);
        }
        List<int[]> transitions = this.getTransitions();
        for (int[] t : transitions) {
            auto.addTransition(t[0], t[1], t[2]);
        }
        return auto;
    }

    public String toString() {
        return this.representedBy.toString();
    }

    private void perfectCopy(FiniteAutomaton other) {
        this.representedBy = new Automaton();
        this.states = new ArrayList();
        this.stateToIndex = new TObjectIntHashMap();
        this.alphabet = new TIntHashSet();
        this.nbStates = other.nbStates;
        for (int i = 0; i < other.nbStates; ++i) {
            State s2 = new State();
            this.states.add(s2);
            this.stateToIndex.put(s2, i);
            if (!other.isNotFinal(i)) {
                s2.setAccept(true);
            }
            if (other.getInitialState() != i) continue;
            this.representedBy.setInitialState(s2);
        }
        List<int[]> transitions = other.getTransitions();
        for (int[] t : transitions) {
            this.addTransition(t[0], t[1], t[2]);
        }
    }

    private void checkState(int ... state) throws IAutomaton.StateNotInAutomatonException {
        int sz = this.states.size();
        for (int s2 : state) {
            if (s2 < sz) continue;
            throw new IAutomaton.StateNotInAutomatonException(s2);
        }
    }

    private void syncStates() {
        this.alphabet.clear();
        this.states.clear();
        this.stateToIndex.clear();
        int idx = 0;
        for (State s2 : this.representedBy.getStates()) {
            this.states.add(s2);
            this.stateToIndex.put(s2, idx++);
            for (Transition t : s2.getTransitions()) {
                char m3 = (char)Math.max(this.min, t.getMin());
                char M = (char)Math.min(this.max, t.getMax());
                for (char c2 = m3; c2 <= M; c2 = (char)(c2 + '\u0001')) {
                    this.alphabet.add(FiniteAutomaton.getIntFromChar(c2));
                }
            }
        }
        this.nbStates = this.states.size();
    }

    private void appendDot(Transition t, StringBuilder b2) {
        int destIdx = this.stateToIndex.get(t.getDest());
        b2.append(" -> ").append(destIdx).append(" [label=\"");
        b2.append("{");
        b2.append(FiniteAutomaton.getIntFromChar(t.getMin()));
        if (t.getMin() != t.getMax()) {
            char m3 = (char)(Math.max(this.min, t.getMin()) + 1);
            char M = (char)Math.min(this.max, t.getMax());
            for (char c2 = m3; c2 <= M; c2 = (char)(c2 + '\u0001')) {
                b2.append(",");
                b2.append(FiniteAutomaton.getIntFromChar(c2));
            }
        }
        b2.append("}");
        b2.append("\"]\n");
    }

    static {
        int delta = 0;
        for (int i = 0; i <= 65535; ++i) {
            while ((char)(i + delta) == '\"' || (char)(i + delta) == '{' || (char)(i + delta) == '}' || (char)(i + delta) == '<' || (char)(i + delta) == '>' || (char)(i + delta) == '[' || (char)(i + delta) == ']' || (char)(i + delta) == '(' || (char)(i + delta) == ')') {
                ++delta;
            }
            charFromIntMap.put(i, i + delta);
            intFromCharMap.put(i + delta, i);
        }
    }
}

