/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.conditions;

import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffAC;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffACFast;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.PropCondAllDiffBase;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

public class PropCondAllDiffAC
extends PropCondAllDiffBase {
    protected final boolean fast;

    public PropCondAllDiffAC(IntVar[] variables, Condition condition, boolean fast) {
        super(variables, condition, PropagatorPriority.QUADRATIC);
        this.fast = fast;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        IntVar[] vars = this.filterVariables();
        if (vars.length == 0) {
            return;
        }
        if (this.fast) {
            AlgoAllDiffACFast filter = new AlgoAllDiffACFast(vars, this);
            filter.propagate();
        } else {
            AlgoAllDiffAC filter = new AlgoAllDiffAC(vars, this);
            filter.propagate();
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

