/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.symmbreaking;

import java.util.HashSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.graph.symmbreaking.Pair;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropGirth
extends Propagator<Variable> {
    private final UndirectedGraphVar graph;
    private final int n;
    private final IntVar girth;

    public PropGirth(UndirectedGraphVar graphVar, IntVar girth) {
        super(new Variable[]{girth, graphVar}, (Priority)PropagatorPriority.LINEAR, false);
        this.graph = graphVar;
        this.n = graphVar.getNbMaxNodes();
        this.girth = girth;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int upperGraphGirth = this.getUpperGraphGirth();
        int lowerGraphGirth = this.getLowerGraphGirth();
        if (upperGraphGirth < this.girth.getUB()) {
            this.girth.updateUpperBound(upperGraphGirth, this);
        }
        if (upperGraphGirth < this.girth.getLB()) {
            throw new ContradictionException();
        }
        if (lowerGraphGirth > this.girth.getLB()) {
            this.girth.updateLowerBound(lowerGraphGirth, this);
        }
        if (lowerGraphGirth > this.girth.getUB()) {
            throw new ContradictionException();
        }
    }

    @Override
    public ESat isEntailed() {
        int upperGraphGirth = this.getUpperGraphGirth();
        int lowerGraphGirth = this.getLowerGraphGirth();
        if (upperGraphGirth < this.girth.getLB()) {
            return ESat.FALSE;
        }
        if (lowerGraphGirth > this.girth.getUB()) {
            return ESat.FALSE;
        }
        if (this.graph.isInstantiated() && this.girth.isInstantiatedTo(lowerGraphGirth)) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private int getUpperGraphGirth() {
        int g2 = this.n + 1;
        for (int i = 0; i < this.n; ++i) {
            int pg = this.getUpperGraphGirth(i);
            if (pg >= g2) continue;
            g2 = pg;
        }
        return g2;
    }

    private int getLowerGraphGirth() {
        int g2 = this.n + 1;
        for (int i = 0; i < this.n; ++i) {
            int pg = this.getLowerGraphGirth(i);
            if (pg >= g2) continue;
            g2 = pg;
        }
        return g2;
    }

    private int getUpperGraphGirth(int vertex) {
        HashSet<Pair<Integer, Integer>> reachable = new HashSet<Pair<Integer, Integer>>();
        reachable.add(new Pair<Integer, Integer>(vertex, -1));
        for (int i = 1; i <= this.n; ++i) {
            HashSet<Pair<Integer, Integer>> set = new HashSet<Pair<Integer, Integer>>();
            for (Pair pair : reachable) {
                ISetIterator iSetIterator = this.graph.getMandatoryNeighborsOf((Integer)pair.getA()).iterator();
                while (iSetIterator.hasNext()) {
                    int v = (Integer)iSetIterator.next();
                    if (v == (Integer)pair.getB()) continue;
                    if (v == vertex) {
                        return i;
                    }
                    set.add(new Pair<Integer, Integer>(v, (Integer)pair.getA()));
                }
            }
            reachable = set;
        }
        return this.n + 1;
    }

    private int getLowerGraphGirth(int vertex) {
        HashSet<Pair<Integer, Integer>> reachable = new HashSet<Pair<Integer, Integer>>();
        reachable.add(new Pair<Integer, Integer>(vertex, -1));
        for (int i = 1; i <= this.n; ++i) {
            HashSet<Pair<Integer, Integer>> set = new HashSet<Pair<Integer, Integer>>();
            for (Pair pair : reachable) {
                ISetIterator iSetIterator = this.graph.getPotentialNeighborsOf((Integer)pair.getA()).iterator();
                while (iSetIterator.hasNext()) {
                    int v = (Integer)iSetIterator.next();
                    if (v == (Integer)pair.getB()) continue;
                    if (v == vertex) {
                        return i;
                    }
                    set.add(new Pair<Integer, Integer>(v, (Integer)pair.getA()));
                }
            }
            reachable = set;
        }
        return this.n + 1;
    }
}

