/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.decoder;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.ByteInputBuffer;
import jj2000.j2k.entropy.decoder.ByteToBitInput;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.entropy.decoder.MQDecoder;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class StdEntropyDecoder
extends EntropyDecoder
implements StdEntropyCoderOptions {
    private static final boolean DO_TIMING = false;
    private long[] time;
    private ByteToBitInput bin;
    private MQDecoder mq;
    private DecoderSpecs decSpec;
    private int options;
    private final boolean doer;
    private final boolean verber;
    private static final int ZC_LUT_BITS = 8;
    private static final int[] ZC_LUT_LH;
    private static final int[] ZC_LUT_HL;
    private static final int[] ZC_LUT_HH;
    private static final int SC_LUT_BITS = 9;
    private static final int[] SC_LUT;
    private static final int SC_LUT_MASK = 15;
    private static final int SC_SPRED_SHIFT = 31;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;
    private static final int MR_LUT_BITS = 9;
    private static final int[] MR_LUT;
    private static final int NUM_CTXTS = 19;
    private static final int RLC_CTXT = 1;
    private static final int UNIF_CTXT = 0;
    private static final int[] MQ_INIT;
    private static final int SEG_SYMBOL = 10;
    private final int[] state;
    private static final int STATE_SEP = 16;
    private static final int STATE_SIG_R1 = 32768;
    private static final int STATE_VISITED_R1 = 16384;
    private static final int STATE_NZ_CTXT_R1 = 8192;
    private static final int STATE_H_L_SIGN_R1 = 4096;
    private static final int STATE_H_R_SIGN_R1 = 2048;
    private static final int STATE_V_U_SIGN_R1 = 1024;
    private static final int STATE_V_D_SIGN_R1 = 512;
    private static final int STATE_PREV_MR_R1 = 256;
    private static final int STATE_H_L_R1 = 128;
    private static final int STATE_H_R_R1 = 64;
    private static final int STATE_V_U_R1 = 32;
    private static final int STATE_V_D_R1 = 16;
    private static final int STATE_D_UL_R1 = 8;
    private static final int STATE_D_UR_R1 = 4;
    private static final int STATE_D_DL_R1 = 2;
    private static final int STATE_D_DR_R1 = 1;
    private static final int STATE_SIG_R2 = Integer.MIN_VALUE;
    private static final int STATE_VISITED_R2 = 0x40000000;
    private static final int STATE_NZ_CTXT_R2 = 0x20000000;
    private static final int STATE_H_L_SIGN_R2 = 0x10000000;
    private static final int STATE_H_R_SIGN_R2 = 0x8000000;
    private static final int STATE_V_U_SIGN_R2 = 0x4000000;
    private static final int STATE_V_D_SIGN_R2 = 0x2000000;
    private static final int STATE_PREV_MR_R2 = 0x1000000;
    private static final int STATE_H_L_R2 = 0x800000;
    private static final int STATE_H_R_R2 = 0x400000;
    private static final int STATE_V_U_R2 = 0x200000;
    private static final int STATE_V_D_R2 = 0x100000;
    private static final int STATE_D_UL_R2 = 524288;
    private static final int STATE_D_UR_R2 = 262144;
    private static final int STATE_D_DL_R2 = 131072;
    private static final int STATE_D_DR_R2 = 65536;
    private static final int SIG_MASK_R1R2 = -2147450880;
    private static final int VSTD_MASK_R1R2 = 0x40004000;
    private static final int RLC_MASK_R1R2 = -536813568;
    private static final int ZC_MASK = 255;
    private static final int SC_SHIFT_R1 = 4;
    private static final int SC_SHIFT_R2 = 20;
    private static final int SC_MASK = 511;
    private static final int MR_MASK = 511;
    private DecLyrdCBlk srcblk;
    private int mQuit;

    public StdEntropyDecoder(CodedCBlkDataSrcDec src, DecoderSpecs decSpec, boolean doer, boolean verber, int mQuit) {
        super(src);
        this.decSpec = decSpec;
        this.doer = doer;
        this.verber = verber;
        this.mQuit = mQuit;
        this.state = new int[(decSpec.cblks.getMaxCBlkWidth() + 2) * ((decSpec.cblks.getMaxCBlkHeight() + 1) / 2 + 2)];
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - void declaration
     */
    public DataBlk getCodeBlock(int c2, int m3, int n, SubbandSyn sb, DataBlk cblk) {
        void var8_13;
        boolean isterm;
        long stime = 0L;
        ByteInputBuffer in = null;
        this.srcblk = this.src.getCodeBlock(c2, m3, n, sb, 1, -1, this.srcblk);
        this.options = (Integer)this.decSpec.ecopts.getTileCompVal(this.tIdx, c2);
        ArrayUtil.intArraySet(this.state, 0);
        if (cblk == null) {
            cblk = new DataBlkInt();
        }
        cblk.progressive = this.srcblk.prog;
        cblk.ulx = this.srcblk.ulx;
        cblk.uly = this.srcblk.uly;
        cblk.w = this.srcblk.w;
        cblk.h = this.srcblk.h;
        cblk.offset = 0;
        cblk.scanw = cblk.w;
        int[] out_data = (int[])cblk.getData();
        if (out_data == null || out_data.length < this.srcblk.w * this.srcblk.h) {
            out_data = new int[this.srcblk.w * this.srcblk.h];
            cblk.setData(out_data);
        } else {
            ArrayUtil.intArraySet(out_data, 0);
        }
        if (this.srcblk.nl <= 0 || this.srcblk.nTrunc <= 0) {
            return cblk;
        }
        int tslen = this.srcblk.tsLengths == null ? this.srcblk.dl : this.srcblk.tsLengths[0];
        int tsidx = 0;
        int npasses = this.srcblk.nTrunc;
        if (this.mq == null) {
            in = new ByteInputBuffer(this.srcblk.data, 0, tslen);
            this.mq = new MQDecoder(in, 19, MQ_INIT);
        } else {
            this.mq.nextSegment(this.srcblk.data, 0, tslen);
            this.mq.resetCtxts();
        }
        boolean error = false;
        if ((this.options & 1) != 0 && this.bin == null) {
            if (in == null) {
                in = this.mq.getByteInputBuffer();
            }
            this.bin = new ByteToBitInput(in);
        }
        switch (sb.orientation) {
            case 1: {
                int[] zc_lut = ZC_LUT_HL;
                break;
            }
            case 0: 
            case 2: {
                int[] zc_lut = ZC_LUT_LH;
                break;
            }
            case 3: {
                int[] zc_lut = ZC_LUT_HH;
                break;
            }
            default: {
                throw new Error("JJ2000 internal error");
            }
        }
        int curbp = 30 - this.srcblk.skipMSBP;
        if (this.mQuit != -1 && this.mQuit * 3 - 2 < npasses) {
            npasses = this.mQuit * 3 - 2;
        }
        if (curbp >= 0 && npasses > 0) {
            isterm = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP >= curbp;
            error = this.cleanuppass(cblk, this.mq, curbp, this.state, (int[])var8_13, isterm);
            --npasses;
            if (!error || !this.doer) {
                --curbp;
            }
        }
        if (!error || !this.doer) {
            while (curbp >= 0 && npasses > 0) {
                if ((this.options & 1) != 0 && curbp < 27 - this.srcblk.skipMSBP) {
                    this.bin.setByteArray(null, -1, this.srcblk.tsLengths[++tsidx]);
                    isterm = (this.options & 4) != 0;
                    error = this.rawSigProgPass(cblk, this.bin, curbp, this.state, isterm);
                    if (--npasses <= 0 || error && this.doer) break;
                    if ((this.options & 4) != 0) {
                        this.bin.setByteArray(null, -1, this.srcblk.tsLengths[++tsidx]);
                    }
                    isterm = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP > curbp;
                    error = this.rawMagRefPass(cblk, this.bin, curbp, this.state, isterm);
                } else {
                    if ((this.options & 4) != 0) {
                        this.mq.nextSegment(null, -1, this.srcblk.tsLengths[++tsidx]);
                    }
                    isterm = (this.options & 4) != 0;
                    error = this.sigProgPass(cblk, this.mq, curbp, this.state, (int[])var8_13, isterm);
                    if (--npasses <= 0 || error && this.doer) break;
                    if ((this.options & 4) != 0) {
                        this.mq.nextSegment(null, -1, this.srcblk.tsLengths[++tsidx]);
                    }
                    isterm = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP > curbp;
                    error = this.magRefPass(cblk, this.mq, curbp, this.state, isterm);
                }
                if (--npasses <= 0 || error && this.doer) break;
                if ((this.options & 4) != 0 || (this.options & 1) != 0 && curbp < 27 - this.srcblk.skipMSBP) {
                    this.mq.nextSegment(null, -1, this.srcblk.tsLengths[++tsidx]);
                }
                isterm = (this.options & 4) != 0 || (this.options & 1) != 0 && 27 - this.srcblk.skipMSBP >= curbp;
                error = this.cleanuppass(cblk, this.mq, curbp, this.state, (int[])var8_13, isterm);
                --npasses;
                if (error) break;
                --curbp;
            }
        }
        if (error && this.doer) {
            if (this.verber) {
                FacilityManager.getMsgLogger().printmsg(2, "Error detected at bit-plane " + curbp + " in code-block (" + m3 + "," + n + "), sb_idx " + sb.sbandIdx + ", res. level " + sb.resLvl + ". Concealing...");
            }
            this.conceal(cblk, curbp);
        }
        return cblk;
    }

    public DataBlk getInternCodeBlock(int c2, int m3, int n, SubbandSyn sb, DataBlk cblk) {
        return this.getCodeBlock(c2, m3, n, sb, cblk);
    }

    /*
     * Unable to fully structure code
     */
    private boolean sigProgPass(DataBlk cblk, MQDecoder mq, int bp, int[] state, int[] zc_lut, boolean isterm) {
        dscanw = cblk.scanw;
        sscanw = cblk.w + 2;
        jstep = sscanw * 4 / 2 - cblk.w;
        kstep = dscanw * 4 - cblk.w;
        setmask = 3 << bp >> 1;
        data = (int[])cblk.getData();
        nstripes = (cblk.h + 4 - 1) / 4;
        causal = (this.options & 8) != 0;
        off_ul = -sscanw - 1;
        off_ur = -sscanw + 1;
        off_dr = sscanw + 1;
        off_dl = sscanw - 1;
        sk = cblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : cblk.h - (nstripes - 1) * 4;
            stopsk = sk + cblk.w;
            while (sk < stopsk) {
                j = sj;
                csj = state[j];
                if ((~csj & csj << 2 & -2147450880) == 0) ** GOTO lbl86
                k = sk;
                if ((csj & 40960) == 8192) {
                    if (mq.decodeSymbol(zc_lut[csj & 255]) != 0) {
                        ctxt = StdEntropyDecoder.SC_LUT[csj >>> 4 & 511];
                        sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                        data[k] = sym << 31 | setmask;
                        if (!causal) {
                            v0 = j + off_ul;
                            state[v0] = state[v0] | 0x20010000;
                            v1 = j + off_ur;
                            state[v1] = state[v1] | 0x20020000;
                        }
                        if (sym != 0) {
                            csj |= 606126080;
                            if (!causal) {
                                v2 = j - sscanw;
                                state[v2] = state[v2] | 0x22100000;
                            }
                            v3 = j + 1;
                            state[v3] = state[v3] | 537407616;
                            v4 = j - 1;
                            state[v4] = state[v4] | 537143360;
                        } else {
                            csj |= 0x2020C000;
                            if (!causal) {
                                v5 = j - sscanw;
                                state[v5] = state[v5] | 0x20100000;
                            }
                            v6 = j + 1;
                            state[v6] = state[v6] | 0x20082080;
                            v7 = j - 1;
                            state[v7] = state[v7] | 0x20042040;
                        }
                    } else {
                        csj |= 16384;
                    }
                }
                if (sheight < 2) {
                    state[j] = csj;
                } else {
                    if ((csj & -1610612736) == 0x20000000) {
                        k += dscanw;
                        if (mq.decodeSymbol(zc_lut[csj >>> 16 & 255]) != 0) {
                            ctxt = StdEntropyDecoder.SC_LUT[csj >>> 20 & 511];
                            sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                            data[k] = sym << 31 | setmask;
                            v8 = j + off_dl;
                            state[v8] = state[v8] | 8196;
                            v9 = j + off_dr;
                            state[v9] = state[v9] | 8200;
                            if (sym != 0) {
                                csj |= -1073733104;
                                v10 = j + sscanw;
                                state[v10] = state[v10] | 9248;
                                v11 = j + 1;
                                state[v11] = state[v11] | 813703170;
                                v12 = j - 1;
                                state[v12] = state[v12] | 675291137;
                            } else {
                                csj |= -1073733616;
                                v13 = j + sscanw;
                                state[v13] = state[v13] | 8224;
                                v14 = j + 1;
                                state[v14] = state[v14] | 0x20802002;
                                v15 = j - 1;
                                state[v15] = state[v15] | 541073409;
                            }
                        } else {
                            csj |= 0x40000000;
                        }
                    }
                    state[j] = csj;
lbl86:
                    // 2 sources

                    if (sheight >= 3 && (~(csj = state[j += sscanw]) & csj << 2 & -2147450880) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 40960) == 8192) {
                            if (mq.decodeSymbol(zc_lut[csj & 255]) != 0) {
                                ctxt = StdEntropyDecoder.SC_LUT[csj >>> 4 & 511];
                                sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                data[k] = sym << 31 | setmask;
                                v16 = j + off_ul;
                                state[v16] = state[v16] | 0x20010000;
                                v17 = j + off_ur;
                                state[v17] = state[v17] | 0x20020000;
                                if (sym != 0) {
                                    csj |= 606126080;
                                    v18 = j - sscanw;
                                    state[v18] = state[v18] | 0x22100000;
                                    v19 = j + 1;
                                    state[v19] = state[v19] | 537407616;
                                    v20 = j - 1;
                                    state[v20] = state[v20] | 537143360;
                                } else {
                                    csj |= 0x2020C000;
                                    v21 = j - sscanw;
                                    state[v21] = state[v21] | 0x20100000;
                                    v22 = j + 1;
                                    state[v22] = state[v22] | 0x20082080;
                                    v23 = j - 1;
                                    state[v23] = state[v23] | 0x20042040;
                                }
                            } else {
                                csj |= 16384;
                            }
                        }
                        if (sheight < 4) {
                            state[j] = csj;
                        } else {
                            if ((csj & -1610612736) == 0x20000000) {
                                k += dscanw;
                                if (mq.decodeSymbol(zc_lut[csj >>> 16 & 255]) != 0) {
                                    ctxt = StdEntropyDecoder.SC_LUT[csj >>> 20 & 511];
                                    sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                    data[k] = sym << 31 | setmask;
                                    v24 = j + off_dl;
                                    state[v24] = state[v24] | 8196;
                                    v25 = j + off_dr;
                                    state[v25] = state[v25] | 8200;
                                    if (sym != 0) {
                                        csj |= -1073733104;
                                        v26 = j + sscanw;
                                        state[v26] = state[v26] | 9248;
                                        v27 = j + 1;
                                        state[v27] = state[v27] | 813703170;
                                        v28 = j - 1;
                                        state[v28] = state[v28] | 675291137;
                                    } else {
                                        csj |= -1073733616;
                                        v29 = j + sscanw;
                                        state[v29] = state[v29] | 8224;
                                        v30 = j + 1;
                                        state[v30] = state[v30] | 0x20802002;
                                        v31 = j - 1;
                                        state[v31] = state[v31] | 541073409;
                                    }
                                } else {
                                    csj |= 0x40000000;
                                }
                            }
                            state[j] = csj;
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        error = false;
        if (isterm && (this.options & 16) != 0) {
            error = mq.checkPredTerm();
        }
        if ((this.options & 2) != 0) {
            mq.resetCtxts();
        }
        return error;
    }

    /*
     * Unable to fully structure code
     */
    private boolean rawSigProgPass(DataBlk cblk, ByteToBitInput bin, int bp, int[] state, boolean isterm) {
        dscanw = cblk.scanw;
        sscanw = cblk.w + 2;
        jstep = sscanw * 4 / 2 - cblk.w;
        kstep = dscanw * 4 - cblk.w;
        setmask = 3 << bp >> 1;
        data = (int[])cblk.getData();
        nstripes = (cblk.h + 4 - 1) / 4;
        causal = (this.options & 8) != 0;
        off_ul = -sscanw - 1;
        off_ur = -sscanw + 1;
        off_dr = sscanw + 1;
        off_dl = sscanw - 1;
        sk = cblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : cblk.h - (nstripes - 1) * 4;
            stopsk = sk + cblk.w;
            while (sk < stopsk) {
                j = sj;
                csj = state[j];
                if ((~csj & csj << 2 & -2147450880) == 0) ** GOTO lbl84
                k = sk;
                if ((csj & 40960) == 8192) {
                    if (bin.readBit() != 0) {
                        sym = bin.readBit();
                        data[k] = sym << 31 | setmask;
                        if (!causal) {
                            v0 = j + off_ul;
                            state[v0] = state[v0] | 0x20010000;
                            v1 = j + off_ur;
                            state[v1] = state[v1] | 0x20020000;
                        }
                        if (sym != 0) {
                            csj |= 606126080;
                            if (!causal) {
                                v2 = j - sscanw;
                                state[v2] = state[v2] | 0x22100000;
                            }
                            v3 = j + 1;
                            state[v3] = state[v3] | 537407616;
                            v4 = j - 1;
                            state[v4] = state[v4] | 537143360;
                        } else {
                            csj |= 0x2020C000;
                            if (!causal) {
                                v5 = j - sscanw;
                                state[v5] = state[v5] | 0x20100000;
                            }
                            v6 = j + 1;
                            state[v6] = state[v6] | 0x20082080;
                            v7 = j - 1;
                            state[v7] = state[v7] | 0x20042040;
                        }
                    } else {
                        csj |= 16384;
                    }
                }
                if (sheight < 2) {
                    state[j] = csj;
                } else {
                    if ((csj & -1610612736) == 0x20000000) {
                        k += dscanw;
                        if (bin.readBit() != 0) {
                            sym = bin.readBit();
                            data[k] = sym << 31 | setmask;
                            v8 = j + off_dl;
                            state[v8] = state[v8] | 8196;
                            v9 = j + off_dr;
                            state[v9] = state[v9] | 8200;
                            if (sym != 0) {
                                csj |= -1073733104;
                                v10 = j + sscanw;
                                state[v10] = state[v10] | 9248;
                                v11 = j + 1;
                                state[v11] = state[v11] | 813703170;
                                v12 = j - 1;
                                state[v12] = state[v12] | 675291137;
                            } else {
                                csj |= -1073733616;
                                v13 = j + sscanw;
                                state[v13] = state[v13] | 8224;
                                v14 = j + 1;
                                state[v14] = state[v14] | 0x20802002;
                                v15 = j - 1;
                                state[v15] = state[v15] | 541073409;
                            }
                        } else {
                            csj |= 0x40000000;
                        }
                    }
                    state[j] = csj;
lbl84:
                    // 2 sources

                    if (sheight >= 3 && (~(csj = state[j += sscanw]) & csj << 2 & -2147450880) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 40960) == 8192) {
                            if (bin.readBit() != 0) {
                                sym = bin.readBit();
                                data[k] = sym << 31 | setmask;
                                v16 = j + off_ul;
                                state[v16] = state[v16] | 0x20010000;
                                v17 = j + off_ur;
                                state[v17] = state[v17] | 0x20020000;
                                if (sym != 0) {
                                    csj |= 606126080;
                                    v18 = j - sscanw;
                                    state[v18] = state[v18] | 0x22100000;
                                    v19 = j + 1;
                                    state[v19] = state[v19] | 537407616;
                                    v20 = j - 1;
                                    state[v20] = state[v20] | 537143360;
                                } else {
                                    csj |= 0x2020C000;
                                    v21 = j - sscanw;
                                    state[v21] = state[v21] | 0x20100000;
                                    v22 = j + 1;
                                    state[v22] = state[v22] | 0x20082080;
                                    v23 = j - 1;
                                    state[v23] = state[v23] | 0x20042040;
                                }
                            } else {
                                csj |= 16384;
                            }
                        }
                        if (sheight < 4) {
                            state[j] = csj;
                        } else {
                            if ((csj & -1610612736) == 0x20000000) {
                                k += dscanw;
                                if (bin.readBit() != 0) {
                                    sym = bin.readBit();
                                    data[k] = sym << 31 | setmask;
                                    v24 = j + off_dl;
                                    state[v24] = state[v24] | 8196;
                                    v25 = j + off_dr;
                                    state[v25] = state[v25] | 8200;
                                    if (sym != 0) {
                                        csj |= -1073733104;
                                        v26 = j + sscanw;
                                        state[v26] = state[v26] | 9248;
                                        v27 = j + 1;
                                        state[v27] = state[v27] | 813703170;
                                        v28 = j - 1;
                                        state[v28] = state[v28] | 675291137;
                                    } else {
                                        csj |= -1073733616;
                                        v29 = j + sscanw;
                                        state[v29] = state[v29] | 8224;
                                        v30 = j + 1;
                                        state[v30] = state[v30] | 0x20802002;
                                        v31 = j - 1;
                                        state[v31] = state[v31] | 541073409;
                                    }
                                } else {
                                    csj |= 0x40000000;
                                }
                            }
                            state[j] = csj;
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        error = false;
        if (isterm) {
            error = bin.checkBytePadding();
        }
        return error;
    }

    /*
     * Unable to fully structure code
     */
    private boolean magRefPass(DataBlk cblk, MQDecoder mq, int bp, int[] state, boolean isterm) {
        dscanw = cblk.scanw;
        sscanw = cblk.w + 2;
        jstep = sscanw * 4 / 2 - cblk.w;
        kstep = dscanw * 4 - cblk.w;
        setmask = 1 << bp >> 1;
        resetmask = -1 << bp + 1;
        data = (int[])cblk.getData();
        nstripes = (cblk.h + 4 - 1) / 4;
        sk = cblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : cblk.h - (nstripes - 1) * 4;
            stopsk = sk + cblk.w;
            while (sk < stopsk) {
                j = sj;
                csj = state[j];
                if ((csj >>> 1 & ~csj & 0x40004000) == 0) ** GOTO lbl38
                k = sk;
                if ((csj & 49152) == 32768) {
                    sym = mq.decodeSymbol(StdEntropyDecoder.MR_LUT[csj & 511]);
                    v0 = k;
                    data[v0] = data[v0] & resetmask;
                    v1 = k;
                    data[v1] = data[v1] | (sym << bp | setmask);
                    csj |= 256;
                }
                if (sheight < 2) {
                    state[j] = csj;
                } else {
                    if ((csj & -1073741824) == -2147483648) {
                        sym = mq.decodeSymbol(StdEntropyDecoder.MR_LUT[csj >>> 16 & 511]);
                        v2 = k += dscanw;
                        data[v2] = data[v2] & resetmask;
                        v3 = k;
                        data[v3] = data[v3] | (sym << bp | setmask);
                        csj |= 0x1000000;
                    }
                    state[j] = csj;
lbl38:
                    // 2 sources

                    if (sheight >= 3 && ((csj = state[j += sscanw]) >>> 1 & ~csj & 0x40004000) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 49152) == 32768) {
                            sym = mq.decodeSymbol(StdEntropyDecoder.MR_LUT[csj & 511]);
                            v4 = k;
                            data[v4] = data[v4] & resetmask;
                            v5 = k;
                            data[v5] = data[v5] | (sym << bp | setmask);
                            csj |= 256;
                        }
                        if (sheight < 4) {
                            state[j] = csj;
                        } else {
                            if ((state[j] & -1073741824) == -2147483648) {
                                sym = mq.decodeSymbol(StdEntropyDecoder.MR_LUT[csj >>> 16 & 511]);
                                v6 = k += dscanw;
                                data[v6] = data[v6] & resetmask;
                                v7 = k;
                                data[v7] = data[v7] | (sym << bp | setmask);
                                csj |= 0x1000000;
                            }
                            state[j] = csj;
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        error = false;
        if (isterm && (this.options & 16) != 0) {
            error = mq.checkPredTerm();
        }
        if ((this.options & 2) != 0) {
            mq.resetCtxts();
        }
        return error;
    }

    private boolean rawMagRefPass(DataBlk cblk, ByteToBitInput bin, int bp, int[] state, boolean isterm) {
        int dscanw = cblk.scanw;
        int sscanw = cblk.w + 2;
        int jstep = sscanw * 4 / 2 - cblk.w;
        int kstep = dscanw * 4 - cblk.w;
        int setmask = 1 << bp >> 1;
        int resetmask = -1 << bp + 1;
        int[] data = (int[])cblk.getData();
        int nstripes = (cblk.h + 4 - 1) / 4;
        int sk = cblk.offset;
        int sj = sscanw + 1;
        int s2 = nstripes - 1;
        while (s2 >= 0) {
            int sheight = s2 != 0 ? 4 : cblk.h - (nstripes - 1) * 4;
            int stopsk = sk + cblk.w;
            while (sk < stopsk) {
                block12: {
                    int sym;
                    int k;
                    int csj;
                    int j;
                    block11: {
                        j = sj;
                        csj = state[j];
                        if ((csj >>> 1 & ~csj & 0x40004000) == 0) break block11;
                        k = sk;
                        if ((csj & 0xC000) == 32768) {
                            sym = bin.readBit();
                            int n = k;
                            data[n] = data[n] & resetmask;
                            int n2 = k;
                            data[n2] = data[n2] | (sym << bp | setmask);
                        }
                        if (sheight < 2) break block12;
                        if ((csj & 0xC0000000) == Integer.MIN_VALUE) {
                            sym = bin.readBit();
                            int n = k += dscanw;
                            data[n] = data[n] & resetmask;
                            int n3 = k;
                            data[n3] = data[n3] | (sym << bp | setmask);
                        }
                    }
                    if (sheight >= 3 && ((csj = state[j += sscanw]) >>> 1 & ~csj & 0x40004000) != 0) {
                        k = sk + (dscanw << 1);
                        if ((csj & 0xC000) == 32768) {
                            sym = bin.readBit();
                            int n = k;
                            data[n] = data[n] & resetmask;
                            int n4 = k;
                            data[n4] = data[n4] | (sym << bp | setmask);
                        }
                        if (sheight >= 4 && (state[j] & 0xC0000000) == Integer.MIN_VALUE) {
                            sym = bin.readBit();
                            int n = k += dscanw;
                            data[n] = data[n] & resetmask;
                            int n5 = k;
                            data[n5] = data[n5] | (sym << bp | setmask);
                        }
                    }
                }
                ++sk;
                ++sj;
            }
            --s2;
            sk += kstep;
            sj += jstep;
        }
        boolean error = false;
        if (isterm && (this.options & 0x10) != 0) {
            error = bin.checkBytePadding();
        }
        return error;
    }

    /*
     * Unable to fully structure code
     */
    private boolean cleanuppass(DataBlk cblk, MQDecoder mq, int bp, int[] state, int[] zc_lut, boolean isterm) {
        dscanw = cblk.scanw;
        sscanw = cblk.w + 2;
        jstep = sscanw * 4 / 2 - cblk.w;
        kstep = dscanw * 4 - cblk.w;
        setmask = 3 << bp >> 1;
        data = (int[])cblk.getData();
        nstripes = (cblk.h + 4 - 1) / 4;
        causal = (this.options & 8) != 0;
        off_ul = -sscanw - 1;
        off_ur = -sscanw + 1;
        off_dr = sscanw + 1;
        off_dl = sscanw - 1;
        sk = cblk.offset;
        sj = sscanw + 1;
        s = nstripes - 1;
        while (s >= 0) {
            sheight = s != 0 ? 4 : cblk.h - (nstripes - 1) * 4;
            stopsk = sk + cblk.w;
            while (sk < stopsk) {
                block34: {
                    block36: {
                        block37: {
                            block38: {
                                block33: {
                                    block35: {
                                        j = sj;
                                        csj = state[j];
                                        if (csj != 0 || state[j + sscanw] != 0 || sheight != 4) break block33;
                                        if (mq.decodeSymbol(1) == 0) break block34;
                                        rlclen = mq.decodeSymbol(0) << 1;
                                        k = sk + (rlclen |= mq.decodeSymbol(0)) * dscanw;
                                        if (rlclen > 1) {
                                            csj = state[j += sscanw];
                                        }
                                        if ((rlclen & 1) != 0) break block35;
                                        ctxt = StdEntropyDecoder.SC_LUT[csj >> 4 & 511];
                                        sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                        data[k] = sym << 31 | setmask;
                                        if (rlclen != 0 || !causal) {
                                            v0 = j + off_ul;
                                            state[v0] = state[v0] | 0x20010000;
                                            v1 = j + off_ur;
                                            state[v1] = state[v1] | 0x20020000;
                                        }
                                        if (sym != 0) {
                                            csj |= 606126080;
                                            if (rlclen != 0 || !causal) {
                                                v2 = j - sscanw;
                                                state[v2] = state[v2] | 0x22100000;
                                            }
                                            v3 = j + 1;
                                            state[v3] = state[v3] | 537407616;
                                            v4 = j - 1;
                                            state[v4] = state[v4] | 537143360;
                                        } else {
                                            csj |= 0x2020C000;
                                            if (rlclen != 0 || !causal) {
                                                v5 = j - sscanw;
                                                state[v5] = state[v5] | 0x20100000;
                                            }
                                            v6 = j + 1;
                                            state[v6] = state[v6] | 0x20082080;
                                            v7 = j - 1;
                                            state[v7] = state[v7] | 0x20042040;
                                        }
                                        if (rlclen >> 1 == 0) break block33;
                                        break block36;
                                    }
                                    ctxt = StdEntropyDecoder.SC_LUT[csj >> 20 & 511];
                                    sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                    data[k] = sym << 31 | setmask;
                                    v8 = j + off_dl;
                                    state[v8] = state[v8] | 8196;
                                    v9 = j + off_dr;
                                    state[v9] = state[v9] | 8200;
                                    if (sym != 0) {
                                        csj |= -2147474928;
                                        v10 = j + sscanw;
                                        state[v10] = state[v10] | 9248;
                                        v11 = j + 1;
                                        state[v11] = state[v11] | 813703170;
                                        v12 = j - 1;
                                        state[v12] = state[v12] | 675291137;
                                    } else {
                                        csj |= -2147475440;
                                        v13 = j + sscanw;
                                        state[v13] = state[v13] | 8224;
                                        v14 = j + 1;
                                        state[v14] = state[v14] | 0x20802002;
                                        v15 = j - 1;
                                        state[v15] = state[v15] | 541073409;
                                    }
                                    state[j] = csj;
                                    if (rlclen >> 1 != 0) break block34;
                                    csj = state[j += sscanw];
                                    break block36;
                                }
                                if (((csj >> 1 | csj) & 0x40004000) == 0x40004000) break block37;
                                k = sk;
                                if ((csj & 49152) == 0 && mq.decodeSymbol(zc_lut[csj & 255]) != 0) {
                                    ctxt = StdEntropyDecoder.SC_LUT[csj >>> 4 & 511];
                                    sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                    data[k] = sym << 31 | setmask;
                                    if (!causal) {
                                        v16 = j + off_ul;
                                        state[v16] = state[v16] | 0x20010000;
                                        v17 = j + off_ur;
                                        state[v17] = state[v17] | 0x20020000;
                                    }
                                    if (sym != 0) {
                                        csj |= 606126080;
                                        if (!causal) {
                                            v18 = j - sscanw;
                                            state[v18] = state[v18] | 0x22100000;
                                        }
                                        v19 = j + 1;
                                        state[v19] = state[v19] | 537407616;
                                        v20 = j - 1;
                                        state[v20] = state[v20] | 537143360;
                                    } else {
                                        csj |= 0x2020C000;
                                        if (!causal) {
                                            v21 = j - sscanw;
                                            state[v21] = state[v21] | 0x20100000;
                                        }
                                        v22 = j + 1;
                                        state[v22] = state[v22] | 0x20082080;
                                        v23 = j - 1;
                                        state[v23] = state[v23] | 0x20042040;
                                    }
                                }
                                if (sheight >= 2) break block38;
                                state[j] = csj &= -1073758209;
                                break block34;
                            }
                            if ((csj & -1073741824) == 0) {
                                k += dscanw;
                                if (mq.decodeSymbol(zc_lut[csj >>> 16 & 255]) != 0) {
                                    ctxt = StdEntropyDecoder.SC_LUT[csj >>> 20 & 511];
                                    sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                    data[k] = sym << 31 | setmask;
                                    v24 = j + off_dl;
                                    state[v24] = state[v24] | 8196;
                                    v25 = j + off_dr;
                                    state[v25] = state[v25] | 8200;
                                    if (sym != 0) {
                                        csj |= -1073733104;
                                        v26 = j + sscanw;
                                        state[v26] = state[v26] | 9248;
                                        v27 = j + 1;
                                        state[v27] = state[v27] | 813703170;
                                        v28 = j - 1;
                                        state[v28] = state[v28] | 675291137;
                                    } else {
                                        csj |= -1073733616;
                                        v29 = j + sscanw;
                                        state[v29] = state[v29] | 8224;
                                        v30 = j + 1;
                                        state[v30] = state[v30] | 0x20802002;
                                        v31 = j - 1;
                                        state[v31] = state[v31] | 541073409;
                                    }
                                }
                            }
                        }
                        state[j] = csj &= -1073758209;
                        if (sheight < 3) break block34;
                        csj = state[j += sscanw];
                    }
                    if (((csj >> 1 | csj) & 0x40004000) == 0x40004000) ** GOTO lbl205
                    k = sk + (dscanw << 1);
                    if ((csj & 49152) == 0 && mq.decodeSymbol(zc_lut[csj & 255]) != 0) {
                        ctxt = StdEntropyDecoder.SC_LUT[csj >> 4 & 511];
                        sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                        data[k] = sym << 31 | setmask;
                        v32 = j + off_ul;
                        state[v32] = state[v32] | 0x20010000;
                        v33 = j + off_ur;
                        state[v33] = state[v33] | 0x20020000;
                        if (sym != 0) {
                            csj |= 606126080;
                            v34 = j - sscanw;
                            state[v34] = state[v34] | 0x22100000;
                            v35 = j + 1;
                            state[v35] = state[v35] | 537407616;
                            v36 = j - 1;
                            state[v36] = state[v36] | 537143360;
                        } else {
                            csj |= 0x2020C000;
                            v37 = j - sscanw;
                            state[v37] = state[v37] | 0x20100000;
                            v38 = j + 1;
                            state[v38] = state[v38] | 0x20082080;
                            v39 = j - 1;
                            state[v39] = state[v39] | 0x20042040;
                        }
                    }
                    if (sheight < 4) {
                        state[j] = csj &= -1073758209;
                    } else {
                        if ((csj & -1073741824) == 0) {
                            k += dscanw;
                            if (mq.decodeSymbol(zc_lut[csj >>> 16 & 255]) != 0) {
                                ctxt = StdEntropyDecoder.SC_LUT[csj >>> 20 & 511];
                                sym = mq.decodeSymbol(ctxt & 15) ^ ctxt >>> 31;
                                data[k] = sym << 31 | setmask;
                                v40 = j + off_dl;
                                state[v40] = state[v40] | 8196;
                                v41 = j + off_dr;
                                state[v41] = state[v41] | 8200;
                                if (sym != 0) {
                                    csj |= -1073733104;
                                    v42 = j + sscanw;
                                    state[v42] = state[v42] | 9248;
                                    v43 = j + 1;
                                    state[v43] = state[v43] | 813703170;
                                    v44 = j - 1;
                                    state[v44] = state[v44] | 675291137;
                                } else {
                                    csj |= -1073733616;
                                    v45 = j + sscanw;
                                    state[v45] = state[v45] | 8224;
                                    v46 = j + 1;
                                    state[v46] = state[v46] | 0x20802002;
                                    v47 = j - 1;
                                    state[v47] = state[v47] | 541073409;
                                }
                            }
                        }
lbl205:
                        // 7 sources

                        state[j] = csj &= -1073758209;
                    }
                }
                ++sk;
                ++sj;
            }
            --s;
            sk += kstep;
            sj += jstep;
        }
        if ((this.options & 32) != 0) {
            sym = mq.decodeSymbol(0) << 3;
            sym |= mq.decodeSymbol(0) << 2;
            sym |= mq.decodeSymbol(0) << 1;
            error = (sym |= mq.decodeSymbol(0)) != 10;
        } else {
            error = false;
        }
        if (isterm && (this.options & 16) != 0) {
            error = mq.checkPredTerm();
        }
        if ((this.options & 2) != 0) {
            mq.resetCtxts();
        }
        return error;
    }

    private void conceal(DataBlk cblk, int bp) {
        int setmask = 1 << bp;
        int resetmask = -1 << bp;
        int[] data = (int[])cblk.getData();
        int k = cblk.offset;
        for (int l = cblk.h - 1; l >= 0; --l) {
            int kmax = k + cblk.w;
            while (k < kmax) {
                int dk = data[k];
                data[k] = (dk & resetmask & Integer.MAX_VALUE) != 0 ? dk & resetmask | setmask : 0;
                ++k;
            }
            k += cblk.scanw - cblk.w;
        }
    }

    static {
        int j;
        int i;
        ZC_LUT_LH = new int[256];
        ZC_LUT_HL = new int[256];
        ZC_LUT_HH = new int[256];
        SC_LUT = new int[512];
        MR_LUT = new int[512];
        MQ_INIT = new int[]{46, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        StdEntropyDecoder.ZC_LUT_LH[0] = 2;
        for (i = 1; i < 16; ++i) {
            StdEntropyDecoder.ZC_LUT_LH[i] = 4;
        }
        for (i = 0; i < 4; ++i) {
            StdEntropyDecoder.ZC_LUT_LH[1 << i] = 3;
        }
        for (i = 0; i < 16; ++i) {
            StdEntropyDecoder.ZC_LUT_LH[0x20 | i] = 5;
            StdEntropyDecoder.ZC_LUT_LH[0x10 | i] = 5;
            StdEntropyDecoder.ZC_LUT_LH[0x30 | i] = 6;
        }
        StdEntropyDecoder.ZC_LUT_LH[128] = 7;
        StdEntropyDecoder.ZC_LUT_LH[64] = 7;
        for (i = 1; i < 16; ++i) {
            StdEntropyDecoder.ZC_LUT_LH[0x80 | i] = 8;
            StdEntropyDecoder.ZC_LUT_LH[0x40 | i] = 8;
        }
        for (i = 1; i < 4; ++i) {
            for (j = 0; j < 16; ++j) {
                StdEntropyDecoder.ZC_LUT_LH[0x80 | i << 4 | j] = 9;
                StdEntropyDecoder.ZC_LUT_LH[0x40 | i << 4 | j] = 9;
            }
        }
        for (i = 0; i < 64; ++i) {
            StdEntropyDecoder.ZC_LUT_LH[0xC0 | i] = 10;
        }
        StdEntropyDecoder.ZC_LUT_HL[0] = 2;
        for (i = 1; i < 16; ++i) {
            StdEntropyDecoder.ZC_LUT_HL[i] = 4;
        }
        for (i = 0; i < 4; ++i) {
            StdEntropyDecoder.ZC_LUT_HL[1 << i] = 3;
        }
        for (i = 0; i < 16; ++i) {
            StdEntropyDecoder.ZC_LUT_HL[0x80 | i] = 5;
            StdEntropyDecoder.ZC_LUT_HL[0x40 | i] = 5;
            StdEntropyDecoder.ZC_LUT_HL[0xC0 | i] = 6;
        }
        StdEntropyDecoder.ZC_LUT_HL[32] = 7;
        StdEntropyDecoder.ZC_LUT_HL[16] = 7;
        for (i = 1; i < 16; ++i) {
            StdEntropyDecoder.ZC_LUT_HL[0x20 | i] = 8;
            StdEntropyDecoder.ZC_LUT_HL[0x10 | i] = 8;
        }
        for (i = 1; i < 4; ++i) {
            for (j = 0; j < 16; ++j) {
                StdEntropyDecoder.ZC_LUT_HL[i << 6 | 0x20 | j] = 9;
                StdEntropyDecoder.ZC_LUT_HL[i << 6 | 0x10 | j] = 9;
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 16; ++j) {
                StdEntropyDecoder.ZC_LUT_HL[i << 6 | 0x20 | 0x10 | j] = 10;
            }
        }
        int[] twoBits = new int[]{3, 5, 6, 9, 10, 12};
        int[] oneBit = new int[]{1, 2, 4, 8};
        int[] twoLeast = new int[]{3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15};
        int[] threeLeast = new int[]{7, 11, 13, 14, 15};
        StdEntropyDecoder.ZC_LUT_HH[0] = 2;
        for (i = 0; i < oneBit.length; ++i) {
            StdEntropyDecoder.ZC_LUT_HH[oneBit[i] << 4] = 3;
        }
        for (i = 0; i < twoLeast.length; ++i) {
            StdEntropyDecoder.ZC_LUT_HH[twoLeast[i] << 4] = 4;
        }
        for (i = 0; i < oneBit.length; ++i) {
            StdEntropyDecoder.ZC_LUT_HH[oneBit[i]] = 5;
        }
        for (i = 0; i < oneBit.length; ++i) {
            for (j = 0; j < oneBit.length; ++j) {
                StdEntropyDecoder.ZC_LUT_HH[oneBit[i] << 4 | oneBit[j]] = 6;
            }
        }
        for (i = 0; i < twoLeast.length; ++i) {
            for (j = 0; j < oneBit.length; ++j) {
                StdEntropyDecoder.ZC_LUT_HH[twoLeast[i] << 4 | oneBit[j]] = 7;
            }
        }
        for (i = 0; i < twoBits.length; ++i) {
            StdEntropyDecoder.ZC_LUT_HH[twoBits[i]] = 8;
        }
        for (j = 0; j < twoBits.length; ++j) {
            for (i = 1; i < 16; ++i) {
                StdEntropyDecoder.ZC_LUT_HH[i << 4 | twoBits[j]] = 9;
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < threeLeast.length; ++j) {
                StdEntropyDecoder.ZC_LUT_HH[i << 4 | threeLeast[j]] = 10;
            }
        }
        int[] inter_sc_lut = new int[36];
        inter_sc_lut[18] = 15;
        inter_sc_lut[17] = 14;
        inter_sc_lut[16] = 13;
        inter_sc_lut[10] = 12;
        inter_sc_lut[9] = 11;
        inter_sc_lut[8] = -2147483636;
        inter_sc_lut[2] = -2147483635;
        inter_sc_lut[1] = -2147483634;
        inter_sc_lut[0] = -2147483633;
        for (i = 0; i < 511; ++i) {
            int ds = i & 1;
            int us = i >> 1 & 1;
            int rs = i >> 2 & 1;
            int ls = i >> 3 & 1;
            int dsgn = i >> 5 & 1;
            int usgn = i >> 6 & 1;
            int lsgn = i >> 8 & 1;
            int rsgn = i >> 7 & 1;
            int h2 = ls * (1 - 2 * lsgn) + rs * (1 - 2 * rsgn);
            h2 = h2 >= -1 ? h2 : -1;
            h2 = h2 <= 1 ? h2 : 1;
            int v = us * (1 - 2 * usgn) + ds * (1 - 2 * dsgn);
            v = v >= -1 ? v : -1;
            v = v <= 1 ? v : 1;
            StdEntropyDecoder.SC_LUT[i] = inter_sc_lut[h2 + 1 << 3 | v + 1];
        }
        inter_sc_lut = null;
        StdEntropyDecoder.MR_LUT[0] = 16;
        for (i = 1; i < 256; ++i) {
            StdEntropyDecoder.MR_LUT[i] = 17;
        }
        while (i < 512) {
            StdEntropyDecoder.MR_LUT[i] = 18;
            ++i;
        }
    }
}

