/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.WarpOpImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

final class WarpGeneralOpImage
extends WarpOpImage {
    private static final int NODATA_VALUE = 0;
    private byte[][] ctable = null;
    private byte[][] byteLookupTable;

    public WarpGeneralOpImage(RenderedImage source, BorderExtender extender, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, double[] background, ROI sourceROI, Range noData) {
        super(source, layout, config, false, extender, interp, warp, background, sourceROI, noData);
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcColorModel;
            this.ctable = new byte[3][icm.getMapSize()];
            icm.getReds(this.ctable[0]);
            icm.getGreens(this.ctable[1]);
            icm.getBlues(this.ctable[2]);
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        if (this.hasNoData && srcDataType == 0) {
            int numBands = this.getNumBands();
            this.byteLookupTable = new byte[numBands][256];
            for (int b2 = 0; b2 < numBands; ++b2) {
                for (int i = 0; i < this.byteLookupTable[0].length; ++i) {
                    byte value = (byte)i;
                    this.byteLookupTable[b2][i] = this.noDataRange.contains(value) ? (byte)this.backgroundValues[b2] : value;
                }
            }
        }
        if (interp != null) {
            this.leftPad = interp.getLeftPadding();
            this.rightPad = interp.getRightPadding();
            this.topPad = interp.getTopPadding();
            this.bottomPad = interp.getBottomPadding();
        } else {
            this.bottomPad = 0;
            this.topPad = 0;
            this.rightPad = 0;
            this.leftPad = 0;
        }
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        int[][] samples = new int[kheight][kwidth];
        if (this.ctable == null) {
            if (this.caseA || this.caseB && roiContainsTile) {
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b2;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b2 = 0; b2 < dstBands; ++b2) {
                                    data[b2][pixelOffset + bandOffsets[b2]] = (byte)this.backgroundValues[b2];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b2) & 0xFF;
                                    }
                                }
                                data[b2][pixelOffset + bandOffsets[b2]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseB) {
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b3;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b3 = 0; b3 < dstBands; ++b3) {
                                    data[b3][pixelOffset + bandOffsets[b3]] = (byte)this.backgroundValues[b3];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            boolean roiWeight = false;
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    int x = xint + i;
                                    int y = yint + j;
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    roiWeight |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            if (roiWeight) {
                                for (b3 = 0; b3 < dstBands; ++b3) {
                                    for (int j = 0; j < kheight; ++j) {
                                        for (int i = 0; i < kwidth; ++i) {
                                            samples[j][i] = iter.getSample(xint + i, yint + j, b3) & 0xFF;
                                        }
                                    }
                                    data[b3][pixelOffset + bandOffsets[b3]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                                }
                            } else {
                                for (b3 = 0; b3 < dstBands; ++b3) {
                                    data[b3][pixelOffset + bandOffsets[b3]] = (byte)this.backgroundValues[b3];
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b4;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    data[b4][pixelOffset + bandOffsets[b4]] = (byte)this.backgroundValues[b4];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            boolean roiWeight = false;
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    int x = xint + i;
                                    int y = yint + j;
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    roiWeight |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = this.byteLookupTable[b4][iter.getSample(xint + i, yint + j, b4) & 0xFF];
                                    }
                                }
                                data[b4][pixelOffset + bandOffsets[b4]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else {
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b5;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpGeneralOpImage.floor(sx);
                        int yint = WarpGeneralOpImage.floor(sy);
                        int xfrac = (int)((sx - (float)xint) * (float)precH);
                        int yfrac = (int)((sy - (float)yint) * (float)precV);
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b5 = 0; b5 < dstBands; ++b5) {
                                    data[b5][pixelOffset + bandOffsets[b5]] = (byte)this.backgroundValues[b5];
                                }
                            }
                        } else {
                            xint -= this.leftPad;
                            yint -= this.topPad;
                            boolean roiWeight = false;
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    int x = xint + i;
                                    int y = yint + j;
                                    if (!this.roiBounds.contains(x, y)) continue;
                                    roiWeight |= roiIter.getSample(x, y, 0) > 0;
                                }
                            }
                            if (roiWeight) {
                                for (b5 = 0; b5 < dstBands; ++b5) {
                                    for (int j = 0; j < kheight; ++j) {
                                        for (int i = 0; i < kwidth; ++i) {
                                            samples[j][i] = this.byteLookupTable[b5][iter.getSample(xint + i, yint + j, b5) & 0xFF];
                                        }
                                    }
                                    data[b5][pixelOffset + bandOffsets[b5]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                                }
                            } else {
                                for (b5 = 0; b5 < dstBands; ++b5) {
                                    data[b5][pixelOffset + bandOffsets[b5]] = (byte)this.backgroundValues[b5];
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            }
        } else if (this.caseA || this.caseB && roiContainsTile) {
            for (int h6 = 0; h6 < dstHeight; ++h6) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h6, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b6;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b6 = 0; b6 < dstBands; ++b6) {
                                data[b6][pixelOffset + bandOffsets[b6]] = (byte)this.backgroundValues[b6];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b6 = 0; b6 < dstBands; ++b6) {
                            byte[] t = this.ctable[b6];
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF;
                                }
                            }
                            data[b6][pixelOffset + bandOffsets[b6]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h7 = 0; h7 < dstHeight; ++h7) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h7, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b7;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = (byte)this.backgroundValues[b7];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                byte[] t = this.ctable[b7];
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF;
                                    }
                                }
                                data[b7][pixelOffset + bandOffsets[b7]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = (byte)this.backgroundValues[b7];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h8 = 0; h8 < dstHeight; ++h8) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h8, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b8;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                data[b8][pixelOffset + bandOffsets[b8]] = (byte)this.backgroundValues[b8];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b8 = 0; b8 < dstBands; ++b8) {
                            byte[] t = this.ctable[b8];
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = this.byteLookupTable[b8][t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF];
                                }
                            }
                            data[b8][pixelOffset + bandOffsets[b8]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h9 = 0; h9 < dstHeight; ++h9) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h9, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b9;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b9 = 0; b9 < dstBands; ++b9) {
                                data[b9][pixelOffset + bandOffsets[b9]] = (byte)this.backgroundValues[b9];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b9 = 0; b9 < dstBands; ++b9) {
                                byte[] t = this.ctable[b9];
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = this.byteLookupTable[b9][t[iter.getSample(xint + i, yint + j, 0) & 0xFF] & 0xFF];
                                    }
                                }
                                data[b9][pixelOffset + bandOffsets[b9]] = ImageUtil.clampByte(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b9 = 0; b9 < dstBands; ++b9) {
                                data[b9][pixelOffset + bandOffsets[b9]] = (byte)this.backgroundValues[b9];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        float[] warpData = new float[2 * dstWidth];
        int[][] samples = new int[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (short)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b2) & 0xFFFF;
                                }
                            }
                            data[b2][pixelOffset + bandOffsets[b2]] = ImageUtil.clampUShort(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b3) & 0xFFFF;
                                    }
                                }
                                data[b3][pixelOffset + bandOffsets[b3]] = ImageUtil.clampUShort(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int value = 0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSample(xint + i, yint + j, b4) & 0xFFFF;
                                    samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                }
                            }
                            data[b4][pixelOffset + bandOffsets[b4]] = ImageUtil.clampUShort(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int value = 0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSample(xint + i, yint + j, b5) & 0xFFFF;
                                        samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                    }
                                }
                                data[b5][pixelOffset + bandOffsets[b5]] = ImageUtil.clampUShort(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        float[] warpData = new float[2 * dstWidth];
        int[][] samples = new int[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (short)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b2);
                                }
                            }
                            data[b2][pixelOffset + bandOffsets[b2]] = ImageUtil.clampShort(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b3);
                                    }
                                }
                                data[b3][pixelOffset + bandOffsets[b3]] = ImageUtil.clampShort(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int value = 0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSample(xint + i, yint + j, b4);
                                    samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                }
                            }
                            data[b4][pixelOffset + bandOffsets[b4]] = ImageUtil.clampShort(this.interp.interpolate(samples, xfrac, yfrac));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int value = 0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSample(xint + i, yint + j, b5);
                                        samples[j][i] = this.noDataRange.contains((short)value) ? 0 : value;
                                    }
                                }
                                data[b5][pixelOffset + bandOffsets[b5]] = ImageUtil.clampShort(this.interp.interpolate(samples, xfrac, yfrac));
                            }
                        } else {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        int precH = 1 << this.interp.getSubsampleBitsH();
        int precV = 1 << this.interp.getSubsampleBitsV();
        float[] warpData = new float[2 * dstWidth];
        int[][] samples = new int[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (int)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSample(xint + i, yint + j, b2);
                                }
                            }
                            data[b2][pixelOffset + bandOffsets[b2]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (int)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSample(xint + i, yint + j, b3);
                                    }
                                }
                                data[b3][pixelOffset + bandOffsets[b3]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (int)this.backgroundValues[b3];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int value = 0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (int)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSample(xint + i, yint + j, b4);
                                    samples[j][i] = this.noDataRange.contains(value) ? 0 : value;
                                }
                            }
                            data[b4][pixelOffset + bandOffsets[b4]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int value = 0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    int xfrac = (int)((sx - (float)xint) * (float)precH);
                    int yfrac = (int)((sy - (float)yint) * (float)precV);
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (int)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSample(xint + i, yint + j, b5);
                                        samples[j][i] = this.noDataRange.contains(value) ? 0 : value;
                                    }
                                }
                                data[b5][pixelOffset + bandOffsets[b5]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (int)this.backgroundValues[b5];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        float[][] samples = new float[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (float)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSampleFloat(xint + i, yint + j, b2);
                                }
                            }
                            data[b2][pixelOffset + bandOffsets[b2]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (float)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSampleFloat(xint + i, yint + j, b3);
                                    }
                                }
                                data[b3][pixelOffset + bandOffsets[b3]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (float)this.backgroundValues[b3];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            float value = 0.0f;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (float)this.backgroundValues[b4];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSampleFloat(xint + i, yint + j, b4);
                                    samples[j][i] = this.noDataRange.contains(value) ? 0.0f : value;
                                }
                            }
                            data[b4][pixelOffset + bandOffsets[b4]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            float value = 0.0f;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (float)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSampleFloat(xint + i, yint + j, b5);
                                        samples[j][i] = this.noDataRange.contains(value) ? 0.0f : value;
                                    }
                                }
                                data[b5][pixelOffset + bandOffsets[b5]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (float)this.backgroundValues[b5];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        RandomIter iter;
        if (this.extended) {
            iter = this.getRandomIterator(src, this.leftPad, this.rightPad, this.topPad, this.bottomPad, this.extender);
            minX = src.getMinX();
            maxX = src.getMaxX();
            minY = src.getMinY();
            maxY = src.getMaxY();
        } else {
            iter = this.getRandomIterator(src, null);
            minX = src.getMinX() + this.leftPad;
            maxX = src.getMaxX() - this.rightPad;
            minY = src.getMinY() + this.topPad;
            maxY = src.getMaxY() - this.bottomPad;
        }
        int kwidth = this.interp.getWidth();
        int kheight = this.interp.getHeight();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        double[][] samples = new double[kheight][kwidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = this.backgroundValues[b2];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    samples[j][i] = iter.getSampleDouble(xint + i, yint + j, b2);
                                }
                            }
                            data[b2][pixelOffset + bandOffsets[b2]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b3;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = this.backgroundValues[b3];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        samples[j][i] = iter.getSampleDouble(xint + i, yint + j, b3);
                                    }
                                }
                                data[b3][pixelOffset + bandOffsets[b3]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = this.backgroundValues[b3];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            double value = 0.0;
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b4;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = this.backgroundValues[b4];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        for (b4 = 0; b4 < dstBands; ++b4) {
                            for (int j = 0; j < kheight; ++j) {
                                for (int i = 0; i < kwidth; ++i) {
                                    value = iter.getSampleDouble(xint + i, yint + j, b4);
                                    samples[j][i] = this.noDataRange.contains(value) ? 0.0 : value;
                                }
                            }
                            data[b4][pixelOffset + bandOffsets[b4]] = this.interp.interpolate(samples, xfrac, yfrac);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            double value = 0.0;
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpGeneralOpImage.floor(sx);
                    int yint = WarpGeneralOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = this.backgroundValues[b5];
                            }
                        }
                    } else {
                        xint -= this.leftPad;
                        yint -= this.topPad;
                        boolean roiWeight = false;
                        for (int j = 0; j < kheight; ++j) {
                            for (int i = 0; i < kwidth; ++i) {
                                int x = xint + i;
                                int y = yint + j;
                                if (!this.roiBounds.contains(x, y)) continue;
                                roiWeight |= roiIter.getSample(x, y, 0) > 0;
                            }
                        }
                        if (roiWeight) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                for (int j = 0; j < kheight; ++j) {
                                    for (int i = 0; i < kwidth; ++i) {
                                        value = iter.getSampleDouble(xint + i, yint + j, b5);
                                        samples[j][i] = this.noDataRange.contains(value) ? 0.0 : value;
                                    }
                                }
                                data[b5][pixelOffset + bandOffsets[b5]] = this.interp.interpolate(samples, xfrac, yfrac);
                            }
                        } else {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = this.backgroundValues[b5];
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }
}

