/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.I18N;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();
    int predictor;

    public TIFFDeflateDecompressor(int predictor) throws IIOException {
        if (predictor != 1 && predictor != 2 && predictor != 3) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = predictor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void decodeRaw(byte[] b2, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        int bps;
        int len;
        if (this.predictor == 2) {
            len = this.bitsPerSample.length;
            bps = this.bitsPerSample[0];
            if (bps != 8 && bps != 16 && bps != 32) {
                throw new IIOException(bps + "-bit samples are not supported for Horizontal differencing Predictor");
            }
            for (int i = 0; i < len; ++i) {
                if (this.bitsPerSample[i] == bps) continue;
                throw new IIOException("Varying sample width is not supported for Horizontal differencing Predictor (first: " + bps + ", unexpected:" + this.bitsPerSample[i] + ")");
            }
        } else if (this.predictor == 3) {
            len = this.bitsPerSample.length;
            bps = this.bitsPerSample[0];
            if (bps != 16 && bps != 24 && bps != 32 && bps != 64) {
                throw new IIOException(bps + "-bit samples are not supported for Floating point Predictor");
            }
            for (int i = 0; i < len; ++i) {
                if (this.bitsPerSample[i] == bps) continue;
                throw new IIOException("Varying sample width is not supported for Floating point Predictor (first: " + bps + ", unexpected:" + this.bitsPerSample[i] + ")");
            }
            for (int sf : this.sampleFormat) {
                if (sf == 3) continue;
                throw new IIOException("Floating point Predictor not supportedwith " + sf + " data format");
            }
        }
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b2;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.inflater.setInput(srcData);
        try {
            this.inflater.inflate(buf, bufOffset, bytesPerRow * this.srcHeight);
        }
        catch (DataFormatException dfe) {
            throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dfe);
        }
        this.inflater.reset();
        if (this.predictor == 2) {
            int i;
            int count;
            int j;
            if (this.bitsPerSample[0] == 8) {
                for (j = 0; j < this.srcHeight; ++j) {
                    count = bufOffset + this.samplesPerPixel * (j * this.srcWidth + 1);
                    for (i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                        int n = count;
                        buf[n] = (byte)(buf[n] + buf[count - this.samplesPerPixel]);
                        ++count;
                    }
                }
            } else if (this.bitsPerSample[0] == 16) {
                int curr;
                if (this.stream.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    for (j = 0; j < this.srcHeight; ++j) {
                        count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 2;
                        for (i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            curr = buf[count] & 0xFF | buf[count + 1] << 8;
                            int prev = buf[count - this.samplesPerPixel * 2] & 0xFF | buf[count + 1 - this.samplesPerPixel * 2] << 8;
                            buf[count] = (byte)(curr += prev);
                            buf[count + 1] = (byte)(curr >> 8);
                            count += 2;
                        }
                    }
                } else {
                    for (j = 0; j < this.srcHeight; ++j) {
                        count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 2;
                        for (i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            curr = buf[count + 1] & 0xFF | buf[count] << 8;
                            int prev = buf[count + 1 - this.samplesPerPixel * 2] & 0xFF | buf[count - this.samplesPerPixel * 2] << 8;
                            buf[count + 1] = (byte)(curr += prev);
                            buf[count] = (byte)(curr >> 8);
                            count += 2;
                        }
                    }
                }
            } else {
                int sum;
                int curr;
                int prev;
                int pbase;
                if (this.bitsPerSample[0] != 32) throw new IIOException("Unexpected branch of Horizontal differencing Predictor, bps=" + this.bitsPerSample[0]);
                if (this.stream.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    for (j = 0; j < this.srcHeight; ++j) {
                        count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 4;
                        pbase = count - this.samplesPerPixel * 4;
                        prev = this.readIntegerFromBuffer(buf, pbase, pbase + 1, pbase + 2, pbase + 3);
                        for (int i2 = this.samplesPerPixel; i2 < this.srcWidth * this.samplesPerPixel; ++i2) {
                            curr = this.readIntegerFromBuffer(buf, count, count + 1, count + 2, count + 3);
                            sum = curr + prev;
                            buf[count] = (byte)(sum & 0xFF);
                            buf[count + 1] = (byte)(sum >> 8 & 0xFF);
                            buf[count + 2] = (byte)(sum >> 16 & 0xFF);
                            buf[count + 3] = (byte)(sum >> 24 & 0xFF);
                            count += 4;
                            prev = sum;
                        }
                    }
                } else {
                    for (j = 0; j < this.srcHeight; ++j) {
                        count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 4;
                        pbase = count - this.samplesPerPixel * 4;
                        prev = this.readIntegerFromBuffer(buf, pbase + 3, pbase + 2, pbase + 1, pbase);
                        for (int i3 = this.samplesPerPixel; i3 < this.srcWidth * this.samplesPerPixel; ++i3) {
                            curr = this.readIntegerFromBuffer(buf, count + 3, count + 2, count + 1, count);
                            sum = curr + prev;
                            buf[count + 3] = (byte)(sum & 0xFF);
                            buf[count + 2] = (byte)(sum >> 8 & 0xFF);
                            buf[count + 1] = (byte)(sum >> 16 & 0xFF);
                            buf[count] = (byte)(sum >> 24 & 0xFF);
                            count += 4;
                            prev = sum;
                        }
                    }
                }
            }
        } else if (this.predictor == 3) {
            int bytesPerSample = this.bitsPerSample[0] / 8;
            if (bytesPerRow % (bytesPerSample * this.samplesPerPixel) != 0) {
                throw new IIOException("The number of bytes in a row (" + bytesPerRow + ") is not divisibleby the number of bytes per pixel (" + bytesPerSample * this.samplesPerPixel + ")");
            }
            for (int j = 0; j < this.srcHeight; ++j) {
                int k;
                int i;
                int offset = bufOffset + j * bytesPerRow;
                int count = offset + this.samplesPerPixel;
                for (int i4 = this.samplesPerPixel; i4 < bytesPerRow; ++i4) {
                    int n = count;
                    buf[n] = (byte)(buf[n] + buf[count - this.samplesPerPixel]);
                    ++count;
                }
                byte[] tmp = Arrays.copyOfRange(buf, offset, offset + bytesPerRow);
                int samplesPerRow = this.srcWidth * this.samplesPerPixel;
                if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                    for (i = 0; i < samplesPerRow; ++i) {
                        for (k = 0; k < bytesPerSample; ++k) {
                            buf[offset + i * bytesPerSample + k] = tmp[k * samplesPerRow + i];
                        }
                    }
                    continue;
                }
                for (i = 0; i < samplesPerRow; ++i) {
                    for (k = 0; k < bytesPerSample; ++k) {
                        buf[offset + i * bytesPerSample + k] = tmp[(bytesPerSample - k - 1) * samplesPerRow + i];
                    }
                }
            }
        }
        if (bytesPerRow == scanlineStride) return;
        int off = 0;
        for (int y = 0; y < this.srcHeight; ++y) {
            System.arraycopy(buf, off, b2, dstOffset, bytesPerRow);
            off += bytesPerRow;
            dstOffset += scanlineStride;
        }
    }

    private final int readIntegerFromBuffer(byte[] buf, int offset1, int offset2, int offset3, int offset4) {
        return buf[offset1] & 0xFF | (buf[offset2] & 0xFF) << 8 | (buf[offset3] & 0xFF) << 16 | (buf[offset4] & 0xFF) << 24;
    }
}

