/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import org.locationtech.jts.geom.Coordinate;

public class HilbertCode {
    public static final int MAX_LEVEL = 16;

    public static int size(int level) {
        HilbertCode.checkLevel(level);
        return (int)Math.pow(2.0, 2 * level);
    }

    public static int maxOrdinate(int level) {
        HilbertCode.checkLevel(level);
        return (int)Math.pow(2.0, level) - 1;
    }

    public static int level(int numPoints) {
        int pow2 = (int)(Math.log(numPoints) / Math.log(2.0));
        int level = pow2 / 2;
        int size = HilbertCode.size(level);
        if (size < numPoints) {
            ++level;
        }
        return level;
    }

    private static void checkLevel(int level) {
        if (level > 16) {
            throw new IllegalArgumentException("Level must be in range 0 to 16");
        }
    }

    public static int encode(int level, int x, int y) {
        int lvl = HilbertCode.levelClamp(level);
        long a2 = (x <<= 16 - lvl) ^ (y <<= 16 - lvl);
        long b2 = 0xFFFFL ^ a2;
        long c2 = 0xFFFF ^ (x | y);
        long d2 = x & (y ^ 0xFFFF);
        long A2 = a2 | b2 >> 1;
        long B = a2 >> 1 ^ a2;
        long C2 = c2 >> 1 ^ b2 & d2 >> 1 ^ c2;
        long D2 = a2 & c2 >> 1 ^ d2 >> 1 ^ d2;
        a2 = A2;
        b2 = B;
        c2 = C2;
        d2 = D2;
        A2 = a2 & a2 >> 2 ^ b2 & b2 >> 2;
        B = a2 & b2 >> 2 ^ b2 & (a2 ^ b2) >> 2;
        C2 ^= a2 & c2 >> 2 ^ b2 & d2 >> 2;
        D2 ^= b2 & c2 >> 2 ^ (a2 ^ b2) & d2 >> 2;
        a2 = A2;
        b2 = B;
        c2 = C2;
        d2 = D2;
        A2 = a2 & a2 >> 4 ^ b2 & b2 >> 4;
        B = a2 & b2 >> 4 ^ b2 & (a2 ^ b2) >> 4;
        C2 ^= a2 & c2 >> 4 ^ b2 & d2 >> 4;
        D2 ^= b2 & c2 >> 4 ^ (a2 ^ b2) & d2 >> 4;
        a2 = A2;
        b2 = B;
        c2 = C2;
        d2 = D2;
        C2 ^= a2 & c2 >> 8 ^ b2 & d2 >> 8;
        D2 ^= b2 & c2 >> 8 ^ (a2 ^ b2) & d2 >> 8;
        a2 = C2 ^ C2 >> 1;
        b2 = D2 ^ D2 >> 1;
        long i0 = x ^ y;
        long i1 = b2 | 0xFFFFL ^ (i0 | a2);
        i0 = (i0 | i0 << 8) & 0xFF00FFL;
        i0 = (i0 | i0 << 4) & 0xF0F0F0FL;
        i0 = (i0 | i0 << 2) & 0x33333333L;
        i0 = (i0 | i0 << 1) & 0x55555555L;
        i1 = (i1 | i1 << 8) & 0xFF00FFL;
        i1 = (i1 | i1 << 4) & 0xF0F0F0FL;
        i1 = (i1 | i1 << 2) & 0x33333333L;
        i1 = (i1 | i1 << 1) & 0x55555555L;
        long index = (i1 << 1 | i0) >> 32 - 2 * lvl;
        return (int)index;
    }

    private static int levelClamp(int level) {
        int lvl = level < 1 ? 1 : level;
        lvl = lvl > 16 ? 16 : lvl;
        return lvl;
    }

    public static Coordinate decode(int level, int index) {
        HilbertCode.checkLevel(level);
        int lvl = HilbertCode.levelClamp(level);
        long i0 = HilbertCode.deinterleave(index <<= 32 - 2 * lvl);
        long i1 = HilbertCode.deinterleave(index >> 1);
        long t0 = (i0 | i1) ^ 0xFFFFL;
        long t1 = i0 & i1;
        long prefixT0 = HilbertCode.prefixScan(t0);
        long prefixT1 = HilbertCode.prefixScan(t1);
        long a2 = (i0 ^ 0xFFFFL) & prefixT1 | i0 & prefixT0;
        long x = (a2 ^ i1) >> 16 - lvl;
        long y = (a2 ^ i0 ^ i1) >> 16 - lvl;
        return new Coordinate(x, y);
    }

    private static long prefixScan(long x) {
        x = x >> 8 ^ x;
        x = x >> 4 ^ x;
        x = x >> 2 ^ x;
        x = x >> 1 ^ x;
        return x;
    }

    private static long deinterleave(int x) {
        x &= 0x55555555;
        x = (x | x >> 1) & 0x33333333;
        x = (x | x >> 2) & 0xF0F0F0F;
        x = (x | x >> 4) & 0xFF00FF;
        x = (x | x >> 8) & 0xFFFF;
        return x;
    }
}

