/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.graph.GraphWalk;

public abstract class Cycles {
    public static <V, E> GraphPath<V, E> simpleCycleToGraphPath(Graph<V, E> graph, List<E> cycle) {
        Objects.requireNonNull(graph, "Graph cannot be null");
        Objects.requireNonNull(cycle, "Cycle cannot be null");
        if (cycle.isEmpty()) {
            return null;
        }
        HashMap<V, E> firstEdge = new HashMap<V, E>();
        HashMap<V, E> secondEdge = new HashMap<V, E>();
        for (E e2 : cycle) {
            V s2 = graph.getEdgeSource(e2);
            if (!firstEdge.containsKey(s2)) {
                firstEdge.put(s2, e2);
            } else if (!secondEdge.containsKey(s2)) {
                secondEdge.put(s2, e2);
            } else {
                throw new IllegalArgumentException("Not a simple cycle");
            }
            V t = graph.getEdgeTarget(e2);
            if (!firstEdge.containsKey(t)) {
                firstEdge.put(t, e2);
                continue;
            }
            if (!secondEdge.containsKey(t)) {
                secondEdge.put(t, e2);
                continue;
            }
            throw new IllegalArgumentException("Not a simple cycle");
        }
        ArrayList edges = new ArrayList();
        double weight = 0.0;
        Object e3 = cycle.stream().findAny().get();
        edges.add(e3);
        weight += graph.getEdgeWeight(e3);
        V start = graph.getEdgeSource(e3);
        V cur = Graphs.getOppositeVertex(graph, e3, start);
        while (!cur.equals(start)) {
            Object fe = firstEdge.get(cur);
            if (fe == null) {
                throw new IllegalArgumentException("Not a simple cycle");
            }
            Object se = secondEdge.get(cur);
            if (se == null) {
                throw new IllegalArgumentException("Not a simple cycle");
            }
            if (fe.equals(e3)) {
                e3 = se;
            } else if (se.equals(e3)) {
                e3 = fe;
            } else {
                throw new IllegalArgumentException("Not a simple cycle");
            }
            edges.add(e3);
            weight += graph.getEdgeWeight(e3);
            cur = Graphs.getOppositeVertex(graph, e3, cur);
        }
        return new GraphWalk<V, E>(graph, start, start, edges, weight);
    }
}

