/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.Collections;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.wms.Code;
import org.geotools.referencing.operation.DefiningConversion;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.ProjectedCRS;

abstract class Factlet {
    Factlet() {
    }

    public abstract int code();

    public abstract String getName();

    public abstract String getClassification();

    public final ProjectedCRS create(Code code, ReferencingFactoryContainer factories) throws FactoryException {
        String classification = this.getClassification();
        ParameterValueGroup parameters = factories.getMathTransformFactory().getDefaultParameters(classification);
        this.setProjectionParameters(parameters, code);
        String name = this.getName();
        DefiningConversion conversion = new DefiningConversion(name, parameters);
        return factories.getCRSFactory().createProjectedCRS(Collections.singletonMap("name", name), DefaultGeographicCRS.WGS84, conversion, DefaultCartesianCS.PROJECTED);
    }

    protected abstract void setProjectionParameters(ParameterValueGroup var1, Code var2);
}

