/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.directory.DirectoryFeatureLocking;
import org.geotools.data.directory.DirectoryFeatureSource;
import org.geotools.data.directory.DirectoryFeatureStore;
import org.geotools.data.directory.DirectoryLockingManager;
import org.geotools.data.directory.DirectoryTypeCache;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.util.URLs;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class DirectoryDataStore
implements DataStore {
    DirectoryTypeCache cache;
    DirectoryLockingManager lm;

    public DirectoryDataStore(File directory, FileStoreFactory dialect) throws IOException {
        this.cache = new DirectoryTypeCache(directory, dialect);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        String typeName = query.getTypeName();
        return this.getDataStore(typeName).getFeatureReader(query, transaction);
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        SimpleFeatureSource fs = this.getDataStore(typeName).getFeatureSource(typeName);
        if (fs instanceof SimpleFeatureLocking) {
            return new DirectoryFeatureLocking((SimpleFeatureLocking)fs);
        }
        if (fs instanceof FeatureStore) {
            return new DirectoryFeatureStore((SimpleFeatureStore)fs);
        }
        return new DirectoryFeatureSource(fs);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        return this.getDataStore(typeName).getFeatureWriter(typeName, filter, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getDataStore(typeName).getFeatureWriter(typeName, transaction);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        return this.getDataStore(typeName).getFeatureWriterAppend(typeName, transaction);
    }

    @Override
    public LockingManager getLockingManager() {
        if (this.lm == null) {
            this.lm = new DirectoryLockingManager(this.cache);
        }
        return this.lm;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getDataStore(typeName).getSchema(typeName);
    }

    @Override
    public String[] getTypeNames() throws IOException {
        Set<String> typeNames = this.cache.getTypeNames();
        return typeNames.toArray(new String[typeNames.size()]);
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        this.getDataStore(typeName).updateSchema(typeName, featureType);
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        File f = new File(this.cache.directory, featureType.getTypeName() + ".shp");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("url", URLs.fileToUrl(f));
        params.put("filetype", "shapefile");
        DataStore ds = null;
        try {
            ds = DataStoreFinder.getDataStore(params);
            if (ds != null) {
                ds.createSchema(featureType);
                ds.dispose();
                this.cache.refreshCacheContents();
            }
        }
        catch (Exception e2) {
            throw (IOException)new IOException("Error creating new data store").initCause(e2);
        }
        if (ds == null) {
            throw new IOException("Could not find the shapefile data store in the classpath");
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.cache.directory);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.cache.directory.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(typeName));
        }
        return names;
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public DataStore getDataStore(String typeName) throws IOException {
        DataStore store = this.cache.getDataStore(typeName, true);
        if (store == null) {
            throw new IOException("Feature type " + typeName + " is unknown");
        }
        return store;
    }

    @Override
    public void removeSchema(Name name) throws IOException {
        this.removeSchema(name.getLocalPart());
    }

    @Override
    public void removeSchema(String name) throws IOException {
        this.getDataStore(name).removeSchema(name);
    }
}

