/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.util.ColorUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.util.Classes;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.ParameterValueGroup;

abstract class IndexColorOperation
extends Operation2D {
    public IndexColorOperation(DefaultParameterDescriptorGroup descriptor) {
        super(descriptor);
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        GridCoverage2D source;
        GridCoverage2D visual = source = (GridCoverage2D)parameters.parameter("Source").getValue();
        RenderedImage image = visual.getRenderedImage();
        GridSampleDimension[] bands = visual.getSampleDimensions();
        int visibleBand = CoverageUtilities.getVisibleBand(image);
        ColorModel model = image.getColorModel();
        boolean colorChanged = false;
        for (int i = 0; i < bands.length; ++i) {
            ColorModel candidate;
            GridSampleDimension band = bands[i];
            ColorModel colorModel = candidate = i == visibleBand ? image.getColorModel() : band.getColorModel();
            if (!(candidate instanceof IndexColorModel)) {
                throw new IllegalArgumentException(Errors.format(61, Classes.getClass(candidate), IndexColorModel.class));
            }
            IndexColorModel colors = (IndexColorModel)candidate;
            int mapSize = colors.getMapSize();
            int[] ARGB = new int[mapSize];
            colors.getRGBs(ARGB);
            band = this.transformColormap(ARGB, i, band, parameters);
            if (!bands[i].equals(band)) {
                bands[i] = band;
                colorChanged = true;
            } else if (!colorChanged) {
                for (int j = 0; j < mapSize; ++j) {
                    if (ARGB[j] == colors.getRGB(j)) continue;
                    colorChanged = true;
                    break;
                }
            }
            if (!colorChanged || i != visibleBand) continue;
            model = ColorUtilities.getIndexColorModel(ARGB, bands.length, visibleBand);
        }
        if (!colorChanged) {
            return source;
        }
        ImageLayout layout = new ImageLayout().setColorModel(model);
        NullOpImage newImage = new NullOpImage(image, layout, null, 1);
        GridCoverage2D target = CoverageFactoryFinder.getGridCoverageFactory(GeoTools.getDefaultHints()).create(visual.getName(), newImage, visual.getCoordinateReferenceSystem2D(), visual.getGridGeometry().getGridToCRS(), bands, new GridCoverage[]{visual}, null);
        return target;
    }

    protected abstract GridSampleDimension transformColormap(int[] var1, int var2, GridSampleDimension var3, ParameterValueGroup var4);
}

