/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.neighborhood.Neighborhoods;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.LandscapeGenerator;
import org.flsgen.solver.LandscapeStructure;
import org.flsgen.solver.Terrain;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffReader;
import picocli.CommandLine;

@CommandLine.Command(name="generate", mixinStandardHelpOptions=true, description={"Generate landscapes from given structures. To produce more realistic landscape, the algorithm relies on a terrain either given as input or automatically generated as a fractal terrain."})
public class CLI_LandscapeGenerator
implements Runnable {
    @CommandLine.Parameters(description={"Output raster prefix path for generated landscape(s)"}, index="0")
    String outputPrefix;
    @CommandLine.Parameters(description={"JSON input file describing landscape structure -- Use \"-\" to read from STDIN (only possible with one structure as input) -- Use multiple space-separated paths to generate landscapes with different structures."}, index="1..*")
    String[] jsonPaths;
    @CommandLine.Option(names={"-e", "-et", "--export-terrain"}, description={"Set an output raster path to export the terrain used to generate the landscape"}, defaultValue="")
    String terrainOutput;
    @CommandLine.Option(names={"-l", "-lt", "--load-terrain"}, description={"Load the terrain used by the algorithm from a raster instead of generating it"}, defaultValue="")
    String terrainInput;
    @CommandLine.Option(names={"-R", "--roughness"}, description={"Roughness parameter (also called H), between 0 and 1 for fractal terrain generation. Lower values produce rougher terrain (default: 0.5)"}, defaultValue="0.5")
    double roughnessFactor;
    @CommandLine.Option(names={"-T", "--terrain-dependency"}, description={"Terrain dependency of the patch generation algorithm, between 0 and 1. 0 means no dependency to the terrain, and 1 mean that patch generation is entirely guided by the terrain (default: 0.5)"}, defaultValue="0.5")
    double terrainDependency;
    @CommandLine.Option(names={"-D", "--distance-between-patches"}, description={"Minimum distance (in number of cells) between patches from a same class (default: 2)."}, defaultValue="2")
    int minDistance;
    @CommandLine.Option(names={"-M", "--max-min-dist"}, description={"If set, the minimum distance between patches is variable between `minDistance` and `maxMinDistance`."}, defaultValue="-1")
    int maxMinDistance;
    @CommandLine.Option(names={"-x"}, description={"Top left x coordinate of the output raster (default: 0)"}, defaultValue="0")
    double x;
    @CommandLine.Option(names={"-y"}, description={"Top left y coordinate of the output raster (default: 0)"}, defaultValue="0")
    double y;
    @CommandLine.Option(names={"-r", "--resolution"}, description={"Spatial resolution of the output raster (in CRS unit, default: 0.0001)"}, defaultValue="0.0001")
    double resolution;
    @CommandLine.Option(names={"-s", "-srs", "--spatial-reference-system"}, description={"Spatial reference system of the output raster (default: EPSG:4326)"}, defaultValue="EPSG:4326")
    String srs;
    @CommandLine.Option(names={"-t", "-ot", "--output-template"}, description={"Raster template to use for output raster metadata"}, defaultValue="")
    String template;
    @CommandLine.Option(names={"-m", "-mt", "--max-try"}, description={"Maximum number or trials to generate the whole landscape (default: 100)."}, defaultValue="100")
    int maxTry;
    @CommandLine.Option(names={"-p", "-mtp", "--max-try-patch"}, description={"Maximum number of trials to generate a patch (default: 100)."}, defaultValue="100")
    int maxTryPatch;
    @CommandLine.Option(names={"-n", "--nb-landscapes"}, description={"Number of landscapes to generate (default: 1)."}, defaultValue="1")
    int nbLandscapes;
    @CommandLine.Option(names={"-c", "--connectivity"}, description={"Connectivity definition in the regular square grid - '4' (4-connected) or '8' (8-connected) (default: 4)."}, defaultValue="4")
    int connectivity;

    @Override
    public void run() {
        try {
            int i;
            if (this.roughnessFactor < 0.0 || this.roughnessFactor > 1.0) {
                System.err.println("\u001b[31mRoughness factor must be in [0, 1]\u001b[0m");
                return;
            }
            if (this.terrainDependency < 0.0 || this.terrainDependency > 1.0) {
                System.err.println("\u001b[31mTerrain dependency must be in [0, 1]\u001b[0m");
                return;
            }
            if (this.minDistance <= 0) {
                System.err.println("\u001b[31mMinimum distance between patches must be at least 1\u001b[0m");
                return;
            }
            if (this.maxTry <= 0) {
                System.err.println("\u001b[31mMaximum trials must be at least 1\u001b[0m");
                return;
            }
            if (this.maxTryPatch <= 0) {
                System.err.println("\u001b[31mMaximum patch trials must be at least 1\u001b[0m");
                return;
            }
            if (!this.template.equals("")) {
                this.initRasterMetadataFromTemplate(this.template);
            }
            if (this.connectivity != 4 && this.connectivity != 8) {
                System.err.println("\u001b[31mThe Connectivity definition must be either 4 or 8\u001b[0m");
            }
            String[] structNames = new String[this.jsonPaths.length];
            if (this.jsonPaths.length == 1 && this.jsonPaths[0].equals("-")) {
                structNames[0] = "STDIN";
            } else {
                for (i = 0; i < this.jsonPaths.length; ++i) {
                    structNames[i] = FilenameUtils.removeExtension(new File(this.jsonPaths[i]).getName());
                }
            }
            for (i = 0; i < this.jsonPaths.length; ++i) {
                INeighborhood bufferNeighborhood;
                Reader reader = this.jsonPaths.length == 1 && this.jsonPaths[0].equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new FileReader(this.jsonPaths[i]);
                LandscapeStructure s2 = LandscapeStructure.fromJSON(reader);
                ((Reader)reader).close();
                Terrain terrain = new Terrain(new RegularSquareGrid(s2.getNbRows(), s2.getNbCols()));
                if (this.terrainInput.equals("")) {
                    terrain.generateDiamondSquare(this.roughnessFactor);
                } else {
                    terrain.loadFromRaster(this.terrainInput);
                }
                if (this.maxMinDistance > 1) {
                    bufferNeighborhood = this.connectivity == 4 ? Neighborhoods.VARIABLE_WIDTH_FOUR_CONNECTED(this.minDistance, this.maxMinDistance) : Neighborhoods.VARIABLE_WIDTH_HEIGHT_CONNECTED(this.minDistance, this.maxMinDistance);
                } else {
                    switch (this.minDistance) {
                        case 1: {
                            bufferNeighborhood = this.connectivity == 4 ? Neighborhoods.FOUR_CONNECTED : Neighborhoods.HEIGHT_CONNECTED;
                            break;
                        }
                        case 2: {
                            bufferNeighborhood = this.connectivity == 4 ? Neighborhoods.TWO_WIDE_FOUR_CONNECTED : Neighborhoods.TWO_WIDE_HEIGHT_CONNECTED;
                            break;
                        }
                        default: {
                            bufferNeighborhood = this.connectivity == 4 ? Neighborhoods.K_WIDE_FOUR_CONNECTED(this.minDistance) : Neighborhoods.K_WIDE_HEIGHT_CONNECTED(this.minDistance);
                        }
                    }
                }
                INeighborhood c2 = this.connectivity == 4 ? Neighborhoods.FOUR_CONNECTED : Neighborhoods.HEIGHT_CONNECTED;
                LandscapeGenerator landscapeGenerator = new LandscapeGenerator(s2, c2, bufferNeighborhood, terrain);
                if (this.nbLandscapes == 1) {
                    boolean b2 = landscapeGenerator.generate(this.terrainDependency, this.maxTry, this.maxTryPatch);
                    if (!b2) {
                        System.out.println("FAIL");
                    } else {
                        System.out.println("Feasible landscape found after " + landscapeGenerator.getNbTry() + " tries");
                        landscapeGenerator.exportRaster(this.x, this.y, this.resolution, this.srs, this.outputPrefix + "_" + structNames[i] + ".tif");
                    }
                } else {
                    for (int n = 0; n < this.nbLandscapes; ++n) {
                        boolean b3 = landscapeGenerator.generate(this.terrainDependency, this.maxTry, this.maxTryPatch);
                        if (!b3) {
                            System.out.println("Failed to generate landscape " + (n + 1));
                        } else {
                            System.out.println("Feasible landscape " + (n + 1) + " found after " + landscapeGenerator.getNbTry() + " tries");
                            landscapeGenerator.exportRaster(this.x, this.y, this.resolution, this.srs, this.outputPrefix + "_" + structNames[i] + "_" + (n + 1) + ".tif");
                        }
                        landscapeGenerator.init();
                    }
                }
                if (this.terrainOutput.equals("")) continue;
                landscapeGenerator.getTerrain().exportRaster(this.x, this.y, this.resolution, this.srs, this.terrainOutput);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void initRasterMetadataFromTemplate(String input) throws IOException {
        File file = new File(input);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        this.resolution = gridCov.getEnvelope2D().getHeight() / (double)gridCov.getRenderedImage().getHeight();
        this.srs = gridCov.getEnvelope2D().getCoordinateReferenceSystem().getIdentifiers().iterator().next().toString();
        this.x = gridCov.getEnvelope2D().getMinX();
        this.y = gridCov.getEnvelope2D().getMinY();
        gridCov.dispose(true);
        reader.dispose();
    }
}

