/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.nary.sum.PropSum;
import org.chocosolver.solver.constraints.nary.sum.PropSumFullBool;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;

public class PropSumFullBoolIncr
extends PropSumFullBool {
    private final IStateInt bLB;
    private final IStateInt bUB;
    private boolean doFilter;

    public PropSumFullBoolIncr(BoolVar[] variables, int pos, Operator o, int b2) {
        super(variables, pos, o, b2, true);
        this.bLB = this.model.getEnvironment().makeInt();
        this.bUB = this.model.getEnvironment().makeInt();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int k;
            int i;
            int lb = 0;
            int ub = 0;
            for (i = 0; i < this.pos; ++i) {
                if (((IntVar[])this.vars)[i].isInstantiated()) {
                    k = ((IntVar[])this.vars)[i].getLB();
                    lb += k;
                    ub += k;
                    continue;
                }
                ++ub;
            }
            while (i < this.l) {
                if (((IntVar[])this.vars)[i].isInstantiated()) {
                    k = ((IntVar[])this.vars)[i].getLB();
                    lb -= k;
                    ub -= k;
                } else {
                    --lb;
                }
                ++i;
            }
            this.bLB.set(lb);
            this.bUB.set(ub);
        }
        this.doFilter = false;
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.pos) {
            int k = ((IntVar[])this.vars)[idxVarInProp].getLB();
            if (k == 1) {
                this.bLB.add(1);
                this.doFilter |= this.o != Operator.GE;
            } else {
                this.bUB.add(-1);
                this.doFilter |= this.o != Operator.LE;
            }
        } else if (idxVarInProp < this.l) {
            int k = ((IntVar[])this.vars)[idxVarInProp].getLB();
            if (k == 0) {
                this.bLB.add(1);
                this.doFilter |= this.o != Operator.GE;
            } else {
                this.bUB.add(-1);
                this.doFilter |= this.o != Operator.LE;
            }
        } else {
            this.doFilter = true;
        }
        if (this.doFilter) {
            this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
        }
    }

    @Override
    protected void prepare() {
        this.sumLB = this.bLB.get();
        this.sumUB = this.bUB.get();
    }

    @Override
    protected PropSum opposite() {
        BoolVar[] bvars = new BoolVar[((IntVar[])this.vars).length];
        System.arraycopy(this.vars, 0, bvars, 0, bvars.length);
        return new PropSumFullBoolIncr(bvars, this.pos, PropSumFullBoolIncr.nop(this.o), this.b + PropSumFullBoolIncr.nb(this.o));
    }
}

