/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nvalue;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.graph.G;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.mis.F;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.rules.R;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAMNV
extends Propagator<IntVar> {
    private final G graph;
    private final F heur;
    private final R[] rules;

    public PropAMNV(IntVar[] X2, IntVar N, G graph, F heur, R[] rules) {
        super((Variable[])ArrayUtils.concat(X2, N), (Priority)PropagatorPriority.CUBIC, true);
        this.graph = graph;
        this.heur = heur;
        this.rules = rules;
        graph.build();
    }

    @Override
    public int getPropagationConditions(int i) {
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.graph.update();
        }
        this.heur.prepare();
        do {
            this.heur.computeMIS();
            for (R rule : this.rules) {
                rule.filter((IntVar[])this.vars, this.graph, this.heur, this);
            }
        } while (this.heur.hasNextMIS());
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < ((IntVar[])this.vars).length - 1) {
            this.graph.update(idxVarInProp);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

