/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.FA.utils;

import org.chocosolver.solver.constraints.nary.automata.FA.utils.Bounds;
import org.chocosolver.solver.constraints.nary.automata.FA.utils.ICounter;

public class Counter
implements ICounter {
    private final int[][] costs;
    private Bounds bounds;

    public Counter(int[][] layer_value, int min2, int max) {
        this.costs = layer_value;
        this.bounds = Bounds.makeBounds(min2, min2, max, max);
    }

    public Counter(int[][][] layer_value_state) {
        this.costs = new int[layer_value_state.length][];
        for (int i = 0; i < layer_value_state.length; ++i) {
            this.costs[i] = new int[layer_value_state[i].length];
            for (int j = 0; j < this.costs[i].length; ++j) {
                this.costs[i][j] = layer_value_state[i][j][0];
            }
        }
    }

    @Override
    public Bounds bounds() {
        return this.bounds;
    }

    @Override
    public double cost(int layer, int value) {
        return this.costs[layer][value];
    }

    @Override
    public double cost(int layer, int value, int state) {
        return this.cost(layer, value);
    }
}

