/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;

public final class BorderExtenderConstant
extends BorderExtender {
    private double[] constants;

    public BorderExtenderConstant(double[] constants) {
        this.constants = constants;
    }

    /*
     * WARNING - void declaration
     */
    private int clamp(int band, int min2, int max) {
        void var5_5;
        double c2;
        int length = this.constants.length;
        if (length == 1) {
            c2 = this.constants[0];
        } else if (band < length) {
            c2 = this.constants[band];
        } else {
            throw new UnsupportedOperationException(JaiI18N.getString("BorderExtenderConstant0"));
        }
        return var5_5 > (double)min2 ? (var5_5 > (double)max ? max : (int)var5_5) : min2;
    }

    public final double[] getConstants() {
        return this.constants;
    }

    public final void extend(WritableRaster raster, PlanarImage im) {
        if (raster == null || im == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        int numBands = raster.getNumBands();
        int minX = raster.getMinX();
        int maxX = minX + width;
        int minY = raster.getMinY();
        int maxY = minY + height;
        int validMinX = Math.max(im.getMinX(), minX);
        int validMaxX = Math.min(im.getMaxX(), maxX);
        int validMinY = Math.max(im.getMinY(), minY);
        int validMaxY = Math.min(im.getMaxY(), maxY);
        int dataType = raster.getSampleModel().getDataType();
        if (dataType == 4) {
            float[] fBandData = new float[numBands];
            for (int b2 = 0; b2 < numBands; ++b2) {
                fBandData[b2] = b2 < this.constants.length ? (float)this.constants[b2] : 0.0f;
            }
            float[] fData = new float[width * numBands];
            int index = 0;
            for (int i = 0; i < width; ++i) {
                for (int b3 = 0; b3 < numBands; ++b3) {
                    fData[index++] = fBandData[b3];
                }
            }
            if (validMinX > validMaxX || validMinY > validMaxY) {
                for (int row = minY; row < maxY; ++row) {
                    raster.setPixels(minX, row, width, 1, fData);
                }
            } else {
                int row;
                for (row = minY; row < validMinY; ++row) {
                    raster.setPixels(minX, row, width, 1, fData);
                }
                for (row = validMinY; row < validMaxY; ++row) {
                    if (minX < validMinX) {
                        raster.setPixels(minX, row, validMinX - minX, 1, fData);
                    }
                    if (validMaxX >= maxX) continue;
                    raster.setPixels(validMaxX, row, maxX - validMaxX, 1, fData);
                }
                for (row = validMaxY; row < maxY; ++row) {
                    raster.setPixels(minX, row, width, 1, fData);
                }
            }
        } else if (dataType == 5) {
            double[] dBandData = new double[numBands];
            for (int b4 = 0; b4 < numBands; ++b4) {
                dBandData[b4] = b4 < this.constants.length ? this.constants[b4] : 0.0;
            }
            double[] dData = new double[width * numBands];
            int index = 0;
            for (int i = 0; i < width; ++i) {
                for (int b5 = 0; b5 < numBands; ++b5) {
                    dData[index++] = dBandData[b5];
                }
            }
            if (validMinX > validMaxX || validMinY > validMaxY) {
                for (int row = minY; row < maxY; ++row) {
                    raster.setPixels(minX, row, width, 1, dData);
                }
            } else {
                int row;
                for (row = minY; row < validMinY; ++row) {
                    raster.setPixels(minX, row, width, 1, dData);
                }
                for (row = validMinY; row < validMaxY; ++row) {
                    if (minX < validMinX) {
                        raster.setPixels(minX, row, validMinX - minX, 1, dData);
                    }
                    if (validMaxX >= maxX) continue;
                    raster.setPixels(validMaxX, row, maxX - validMaxX, 1, dData);
                }
                for (row = validMaxY; row < maxY; ++row) {
                    raster.setPixels(minX, row, width, 1, dData);
                }
            }
        } else {
            int[] iBandData = new int[numBands];
            switch (dataType) {
                case 0: {
                    int b6;
                    for (b6 = 0; b6 < numBands; ++b6) {
                        iBandData[b6] = this.clamp(b6, 0, 255);
                    }
                    break;
                }
                case 2: {
                    int b6;
                    for (b6 = 0; b6 < numBands; ++b6) {
                        iBandData[b6] = this.clamp(b6, Short.MIN_VALUE, Short.MAX_VALUE);
                    }
                    break;
                }
                case 1: {
                    int b6;
                    for (b6 = 0; b6 < numBands; ++b6) {
                        iBandData[b6] = this.clamp(b6, 0, 65535);
                    }
                    break;
                }
                case 3: {
                    int b6;
                    for (b6 = 0; b6 < numBands; ++b6) {
                        iBandData[b6] = this.clamp(b6, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
                }
            }
            int[] iData = new int[width * numBands];
            int index = 0;
            for (int i = 0; i < width; ++i) {
                for (int b7 = 0; b7 < numBands; ++b7) {
                    iData[index++] = iBandData[b7];
                }
            }
            if (validMinX > validMaxX || validMinY > validMaxY) {
                for (int row = minY; row < maxY; ++row) {
                    raster.setPixels(minX, row, width, 1, iData);
                }
            } else {
                int row;
                for (row = minY; row < validMinY; ++row) {
                    raster.setPixels(minX, row, width, 1, iData);
                }
                for (row = validMinY; row < validMaxY; ++row) {
                    if (minX < validMinX) {
                        raster.setPixels(minX, row, validMinX - minX, 1, iData);
                    }
                    if (validMaxX >= maxX) continue;
                    raster.setPixels(validMaxX, row, maxX - validMaxX, 1, iData);
                }
                for (row = validMaxY; row < maxY; ++row) {
                    raster.setPixels(minX, row, width, 1, iData);
                }
            }
        }
    }
}

