/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ContiguousRangeComposer {
    protected long currentRangeStart;
    protected long currentRangeEnd;
    protected boolean tileAdded = false;
    protected Set<long[]> ranges = new HashSet<long[]>();

    public ContiguousRangeComposer(long initialRangeStart, long initialRangeEnd) {
        this.currentRangeStart = initialRangeStart;
        this.currentRangeEnd = initialRangeEnd;
    }

    public void addTileRange(long start, long end) {
        this.tileAdded = true;
        if (start == this.currentRangeEnd + 1L) {
            this.currentRangeEnd = end;
        } else {
            this.ranges.add(new long[]{this.currentRangeStart, this.currentRangeEnd});
            this.currentRangeStart = start;
            this.currentRangeEnd = end;
        }
    }

    public Set<long[]> getRanges() {
        if (this.tileAdded) {
            HashSet<long[]> rangeCopy = new HashSet<long[]>(this.ranges);
            rangeCopy.add(new long[]{this.currentRangeStart, this.currentRangeEnd});
            return rangeCopy;
        }
        return Collections.EMPTY_SET;
    }
}

