/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageioimpl.plugins.cog.CachingCogImageInputStream;
import it.geosolutions.imageioimpl.plugins.cog.DefaultCogImageInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class CogImageInputStreamSpi
extends ImageInputStreamSpi {
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class<BasicAuthURI> inputClass = BasicAuthURI.class;

    public CogImageInputStreamSpi() {
        super(vendorName, version, inputClass);
    }

    @Override
    public ImageInputStream createInputStreamInstance(Object input, boolean useCache, File cacheDir) throws IOException {
        if (input instanceof BasicAuthURI) {
            return ((BasicAuthURI)input).isUseCache() ? new CachingCogImageInputStream((BasicAuthURI)input) : new DefaultCogImageInputStream((BasicAuthURI)input);
        }
        if (input instanceof String || input instanceof URL || input instanceof URI) {
            return useCache ? new CachingCogImageInputStream(new BasicAuthURI(input.toString())) : new DefaultCogImageInputStream(new BasicAuthURI(input.toString()).useCache(false));
        }
        throw new IOException("Invalid input.");
    }

    @Override
    public String getDescription(Locale locale) {
        return "Cloud Optimized GeoTIFF reader";
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        super.onRegistration(registry, category);
        Class<ImageInputStreamSpi> targetClass = ImageInputStreamSpi.class;
        Iterator<ImageInputStreamSpi> i = registry.getServiceProviders(targetClass, true);
        while (i.hasNext()) {
            ImageInputStreamSpi other = i.next();
            if (this == other) continue;
            registry.setOrdering(targetClass, this, other);
        }
    }
}

