/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageioimpl.plugins.cog.CacheConfig;
import it.geosolutions.imageioimpl.plugins.cog.CogTileCacheProvider;
import it.geosolutions.imageioimpl.plugins.cog.TileCacheEntryKey;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.xml.XmlConfiguration;

public enum CacheManagement implements CogTileCacheProvider
{
    DEFAULT;

    public static final String TILE_CACHE = "tile_cache";
    public static final String HEADER_CACHE = "header_cache";
    private CacheManager manager;
    private CacheConfig config = CacheConfig.getDefaultConfig();
    private static Logger LOGGER;

    private CacheManagement() {
        this.manager = this.buildCache(false);
    }

    private CacheManager buildCache(boolean removeCacheIfExists) {
        if (this.config.getXmlConfigPath() != null) {
            CacheManagement.logger().fine("XML configuration declared for ehcache at " + this.config.getXmlConfigPath());
            URL configUrl = this.getClass().getResource(this.config.getXmlConfigPath());
            XmlConfiguration xmlConfig = new XmlConfiguration(configUrl);
            this.manager = CacheManagerBuilder.newCacheManager((Configuration)xmlConfig);
            this.manager.init();
            return this.manager;
        }
        CacheManagerBuilder managerBuilder = CacheManagerBuilder.newCacheManagerBuilder();
        if (this.config.isUseDiskCache()) {
            managerBuilder.with(CacheManagerBuilder.persistence((String)this.config.getCacheDirectory()));
        }
        this.manager = managerBuilder.build(true);
        if (removeCacheIfExists) {
            this.manager.removeCache(TILE_CACHE);
            this.manager.removeCache(HEADER_CACHE);
        }
        ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.heap((long)this.config.getHeapEntries());
        if (this.config.isUseDiskCache()) {
            resourcePoolsBuilder.disk((long)this.config.getDiskCacheSize(), MemoryUnit.B, true);
        }
        if (this.config.isUseOffHeapCache()) {
            resourcePoolsBuilder.offheap((long)this.config.getOffHeapSize(), MemoryUnit.B);
        }
        this.manager.createCache(TILE_CACHE, this.buildCacheConfiguration(TileCacheEntryKey.class, byte[].class, resourcePoolsBuilder));
        this.manager.createCache(HEADER_CACHE, this.buildCacheConfiguration(String.class, byte[].class, resourcePoolsBuilder));
        return this.manager;
    }

    public <K extends Class, V extends Class> CacheConfiguration<K, V> buildCacheConfiguration(K keyType, V valueType, ResourcePoolsBuilder resourcePoolsBuilder) {
        CacheConfigurationBuilder cacheConfigurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)resourcePoolsBuilder);
        if (this.config.getTimeToLive() > 0L) {
            cacheConfigurationBuilder.withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)this.config.getTimeToLive(), (TimeUnit)TimeUnit.MILLISECONDS)));
        }
        if (this.config.getTimeToIdle() > 0L) {
            cacheConfigurationBuilder.withExpiry(Expirations.timeToIdleExpiration((Duration)Duration.of((long)this.config.getTimeToIdle(), (TimeUnit)TimeUnit.MILLISECONDS)));
        }
        return cacheConfigurationBuilder.build();
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger(CacheManagement.class.getCanonicalName());
        }
        return LOGGER;
    }

    private Cache<TileCacheEntryKey, byte[]> getTileCache() {
        return this.manager.getCache(TILE_CACHE, TileCacheEntryKey.class, byte[].class);
    }

    private Cache<String, byte[]> getHeaderCache() {
        return this.manager.getCache(HEADER_CACHE, String.class, byte[].class);
    }

    @Override
    public byte[] getTile(TileCacheEntryKey key) {
        return (byte[])this.getTileCache().get((Object)key);
    }

    @Override
    public void cacheTile(TileCacheEntryKey key, byte[] tileBytes) {
        this.getTileCache().put((Object)key, (Object)tileBytes);
    }

    @Override
    public boolean keyExists(TileCacheEntryKey key) {
        return this.getTileCache().containsKey((Object)key);
    }

    @Override
    public void cacheHeader(String key, byte[] headerBytes) {
        this.getHeaderCache().put((Object)key, (Object)headerBytes);
    }

    @Override
    public byte[] getHeader(String key) {
        return (byte[])this.getHeaderCache().get((Object)key);
    }

    @Override
    public boolean headerExists(String key) {
        return this.getHeaderCache().containsKey((Object)key);
    }

    public CacheConfig getCacheConfig() {
        return this.config;
    }
}

