/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class OrConstOpImage
extends ColormapOpImage {
    protected int[] constants;

    public OrConstOpImage(RenderedImage source, Map config, ImageLayout layout, int[] constants) {
        super(source, layout, config, true);
        int numBands = this.getSampleModel().getNumBands();
        if (constants.length < numBands) {
            this.constants = new int[numBands];
            for (int i = 0; i < numBands; ++i) {
                this.constants[i] = constants[0];
            }
        } else {
            this.constants = (int[])constants.clone();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] colormap) {
        for (int b2 = 0; b2 < 3; ++b2) {
            byte[] map = colormap[b2];
            int mapSize = map.length;
            int c2 = b2 < this.constants.length ? this.constants[b2] : this.constants[0];
            for (int i = 0; i < mapSize; ++i) {
                map[i] = ImageUtil.clampRoundByte(map[i] & 0xFF | c2);
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor src = new RasterAccessor(sources[0], srcRect, formatTags[0], this.getSource(0).getColorModel());
        switch (dst.getDataType()) {
            case 0: {
                this.computeRectByte(src, dst);
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(src, dst);
                break;
            }
            case 3: {
                this.computeRectInt(src, dst);
            }
        }
        dst.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        byte[][] dstData = dst.getByteDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            int c2 = this.constants[b2];
            byte[] d2 = dstData[b2];
            byte[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    d2[dstPixelOffset] = (byte)(s2[srcPixelOffset] | c2);
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            int c2 = this.constants[b2];
            short[] d2 = dstData[b2];
            short[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    d2[dstPixelOffset] = (short)(s2[srcPixelOffset] | c2);
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int[][] dstData = dst.getIntDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            int c2 = this.constants[b2];
            int[] d2 = dstData[b2];
            int[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                for (int w = 0; w < dstWidth; ++w) {
                    d2[dstPixelOffset] = s2[srcPixelOffset] | c2;
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }
}

