/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Quadrant;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;

public class DirectedEdge
extends GraphComponent
implements Comparable {
    protected Edge parentEdge;
    protected Node from;
    protected Node to;
    protected Coordinate p0;
    protected Coordinate p1;
    protected DirectedEdge sym = null;
    protected boolean edgeDirection;
    protected int quadrant;
    protected double angle;

    public static List toEdges(Collection dirEdges) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        Iterator i = dirEdges.iterator();
        while (i.hasNext()) {
            edges.add(((DirectedEdge)i.next()).parentEdge);
        }
        return edges;
    }

    public DirectedEdge(Node from, Node to, Coordinate directionPt, boolean edgeDirection) {
        this.from = from;
        this.to = to;
        this.edgeDirection = edgeDirection;
        this.p0 = from.getCoordinate();
        this.p1 = directionPt;
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        this.quadrant = Quadrant.quadrant(dx, dy);
        this.angle = Math.atan2(dy, dx);
    }

    public Edge getEdge() {
        return this.parentEdge;
    }

    public void setEdge(Edge parentEdge) {
        this.parentEdge = parentEdge;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public Coordinate getDirectionPt() {
        return this.p1;
    }

    public boolean getEdgeDirection() {
        return this.edgeDirection;
    }

    public Node getFromNode() {
        return this.from;
    }

    public Node getToNode() {
        return this.to;
    }

    public Coordinate getCoordinate() {
        return this.from.getCoordinate();
    }

    public double getAngle() {
        return this.angle;
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public void setSym(DirectedEdge sym) {
        this.sym = sym;
    }

    void remove() {
        this.sym = null;
        this.parentEdge = null;
    }

    @Override
    public boolean isRemoved() {
        return this.parentEdge == null;
    }

    public int compareTo(Object obj) {
        DirectedEdge de = (DirectedEdge)obj;
        return this.compareDirection(de);
    }

    public int compareDirection(DirectedEdge e2) {
        if (this.quadrant > e2.quadrant) {
            return 1;
        }
        if (this.quadrant < e2.quadrant) {
            return -1;
        }
        return Orientation.index(e2.p0, e2.p1, this.p1);
    }

    public void print(PrintStream out) {
        String className = this.getClass().getName();
        int lastDotPos = className.lastIndexOf(46);
        String name = className.substring(lastDotPos + 1);
        out.print("  " + name + ": " + this.p0 + " - " + this.p1 + " " + this.quadrant + ":" + this.angle);
    }
}

