/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotSurface_;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;

public class PlotSurface_AxesChart<ST extends AxesChartStyler, S extends Series>
extends PlotSurface_<ST, S> {
    private final ST stylerAxesChart;

    PlotSurface_AxesChart(Chart<ST, S> chart) {
        super(chart);
        this.stylerAxesChart = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void paint(Graphics2D g2) {
        Shape line;
        double yOffset;
        List<Double> yAxisTickLocations;
        Rectangle2D bounds = this.getBounds();
        Rectangle2D.Double rect = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        g2.setColor(((Styler)this.stylerAxesChart).getPlotBackgroundColor());
        g2.fill(rect);
        if (((AxesChartStyler)this.stylerAxesChart).isPlotGridHorizontalLinesVisible()) {
            yAxisTickLocations = this.chart.getYAxis().getAxisTickCalculator().getTickLocations();
            for (Double yAxisTickLocation : yAxisTickLocations) {
                yOffset = bounds.getY() + bounds.getHeight() - yAxisTickLocation;
                if (!(yOffset > bounds.getY()) || !(yOffset < bounds.getY() + bounds.getHeight())) continue;
                g2.setColor(((AxesChartStyler)this.stylerAxesChart).getPlotGridLinesColor());
                g2.setStroke(((AxesChartStyler)this.stylerAxesChart).getPlotGridLinesStroke());
                line = ((AxesChartStyler)this.stylerAxesChart).getPlotGridLinesStroke().createStrokedShape(new Line2D.Double(bounds.getX(), yOffset, bounds.getX() + bounds.getWidth(), yOffset));
                g2.draw(line);
            }
        }
        if (((AxesChartStyler)this.stylerAxesChart).isPlotTicksMarksVisible()) {
            yAxisTickLocations = this.chart.getAxisPair().getLeftMainYAxis().getAxisTickCalculator().getTickLocations();
            for (Double yAxisTickLocation : yAxisTickLocations) {
                yOffset = bounds.getY() + bounds.getHeight() - yAxisTickLocation;
                if (!(yOffset > bounds.getY()) || !(yOffset < bounds.getY() + bounds.getHeight())) continue;
                g2.setColor(((AxesChartStyler)this.stylerAxesChart).getAxisTickMarksColor());
                g2.setStroke(((AxesChartStyler)this.stylerAxesChart).getAxisTickMarksStroke());
                line = new Line2D.Double(bounds.getX(), yOffset, bounds.getX() + (double)((AxesChartStyler)this.stylerAxesChart).getAxisTickMarkLength(), yOffset);
                g2.draw(line);
            }
            yAxisTickLocations = this.chart.getAxisPair().getRightMainYAxis().getAxisTickCalculator().getTickLocations();
            for (Double yAxisTickLocation : yAxisTickLocations) {
                yOffset = bounds.getY() + bounds.getHeight() - yAxisTickLocation;
                if (!(yOffset > bounds.getY()) || !(yOffset < bounds.getY() + bounds.getHeight())) continue;
                g2.setColor(((AxesChartStyler)this.stylerAxesChart).getAxisTickMarksColor());
                g2.setStroke(((AxesChartStyler)this.stylerAxesChart).getAxisTickMarksStroke());
                line = new Line2D.Double(bounds.getX() + bounds.getWidth(), yOffset, bounds.getX() + bounds.getWidth() - (double)((AxesChartStyler)this.stylerAxesChart).getAxisTickMarkLength(), yOffset);
                g2.draw(line);
            }
        }
        if (((AxesChartStyler)this.stylerAxesChart).isPlotGridVerticalLinesVisible() || ((AxesChartStyler)this.stylerAxesChart).isPlotTicksMarksVisible()) {
            List<Double> xAxisTickLocations = this.chart.getXAxis().getAxisTickCalculator().getTickLocations();
            for (Double xAxisTickLocation : xAxisTickLocations) {
                Shape line2;
                double tickLocation = xAxisTickLocation;
                double xOffset = bounds.getX() + tickLocation;
                if (!(xOffset > bounds.getX()) || !(xOffset < bounds.getX() + bounds.getWidth())) continue;
                if (((AxesChartStyler)this.stylerAxesChart).isPlotGridVerticalLinesVisible()) {
                    g2.setColor(((AxesChartStyler)this.stylerAxesChart).getPlotGridLinesColor());
                    g2.setStroke(((AxesChartStyler)this.stylerAxesChart).getPlotGridLinesStroke());
                    line2 = ((AxesChartStyler)this.stylerAxesChart).getPlotGridLinesStroke().createStrokedShape(new Line2D.Double(xOffset, bounds.getY(), xOffset, bounds.getY() + bounds.getHeight()));
                    g2.draw(line2);
                }
                if (!((AxesChartStyler)this.stylerAxesChart).isPlotTicksMarksVisible()) continue;
                g2.setColor(((AxesChartStyler)this.stylerAxesChart).getAxisTickMarksColor());
                g2.setStroke(((AxesChartStyler)this.stylerAxesChart).getAxisTickMarksStroke());
                line2 = new Line2D.Double(xOffset, bounds.getY(), xOffset, bounds.getY() + (double)((AxesChartStyler)this.stylerAxesChart).getAxisTickMarkLength());
                g2.draw(line2);
                line2 = new Line2D.Double(xOffset, bounds.getY() + bounds.getHeight(), xOffset, bounds.getY() + bounds.getHeight() - (double)((AxesChartStyler)this.stylerAxesChart).getAxisTickMarkLength());
                g2.draw(line2);
            }
        }
        if (((Styler)this.stylerAxesChart).isPlotBorderVisible()) {
            g2.setColor(((Styler)this.stylerAxesChart).getPlotBorderColor());
            g2.setStroke(SOLID_STROKE);
            g2.draw(rect);
        }
    }
}

