/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.knowm.xchart.internal.chartpart.RenderableSeries;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.Series;

public class HeatMapSeries
extends AxesChartSeries {
    List<?> xData;
    List<?> yData;
    List<? extends Number[]> heatData;
    double min;
    double max;

    protected HeatMapSeries(String name, List<?> xData, List<?> yData, List<Number[]> heatData) {
        super(name, HeatMapSeries.getDataType(xData), HeatMapSeries.getDataType(yData));
        this.xData = xData;
        this.yData = yData;
        this.heatData = heatData;
        this.calculateMinMax();
    }

    public void replaceData(List<?> xData, List<?> yData, List<Number[]> heatData) {
        this.xData = xData;
        this.yData = yData;
        this.heatData = heatData;
        this.calculateMinMax();
    }

    @Override
    protected void calculateMinMax() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        Number number = null;
        for (Number[] numberArray : this.heatData) {
            if (numberArray == null || (number = numberArray[2]) == null) continue;
            if (this.min > number.doubleValue()) {
                this.min = number.doubleValue();
            }
            if (!(this.max < number.doubleValue())) continue;
            this.max = number.doubleValue();
        }
        this.xMin = HeatMapSeries.getMin(this.xData, this.xMin);
        this.xMax = HeatMapSeries.getMax(this.xData, this.xMax);
        this.yMin = HeatMapSeries.getMin(this.yData, this.yMin);
        this.yMax = HeatMapSeries.getMax(this.yData, this.yMax);
    }

    private static double getMin(List<?> list, double defaultValue) {
        if (list.isEmpty() || !(list.get(0) instanceof Number)) {
            return defaultValue;
        }
        return list.stream().map(x -> (Number)x).min(Comparator.comparing(Number::doubleValue)).orElse(defaultValue).doubleValue();
    }

    private static double getMax(List<?> list, double defaultValue) {
        if (list.isEmpty() || !(list.get(0) instanceof Number)) {
            return defaultValue;
        }
        return list.stream().map(x -> (Number)x).max(Comparator.comparing(Number::doubleValue)).orElse(defaultValue).doubleValue();
    }

    @Override
    public RenderableSeries.LegendRenderType getLegendRenderType() {
        return null;
    }

    private static Series.DataType getDataType(List<?> data) {
        Series.DataType axisType;
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = Series.DataType.Number;
        } else if (dataPoint instanceof Date) {
            axisType = Series.DataType.Date;
        } else if (dataPoint instanceof String) {
            axisType = Series.DataType.String;
        } else {
            throw new IllegalArgumentException("Series data must be either Number, Date or String type!!!");
        }
        return axisType;
    }

    public Collection<?> getXData() {
        return this.xData;
    }

    public Collection<?> getYData() {
        return this.yData;
    }

    public Collection<? extends Number[]> getHeatData() {
        return this.heatData;
    }

    public double getMin() {
        return this.min;
    }

    public HeatMapSeries setMin(double min2) {
        this.min = min2;
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public HeatMapSeries setMax(double max) {
        this.max = max;
        return this;
    }
}

