/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.staxex;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Base64EncoderStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private XMLStreamWriter outWriter;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64EncoderStream(OutputStream out) {
        super(out);
    }

    public Base64EncoderStream(XMLStreamWriter outWriter, OutputStream out) {
        super(out);
        this.outWriter = outWriter;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b2[off + i]);
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int c2) throws IOException {
        this.buffer[this.bufsize++] = (byte)c2;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
        try {
            this.outWriter.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Base64EncoderStream.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        char[] buf = new char[4];
        if (this.bufsize == 1) {
            byte a2 = this.buffer[0];
            int b2 = 0;
            boolean c2 = false;
            buf[0] = pem_array[a2 >>> 2 & 0x3F];
            buf[1] = pem_array[(a2 << 4 & 0x30) + (b2 >>> 4 & 0xF)];
            buf[2] = 61;
            buf[3] = 61;
        } else if (this.bufsize == 2) {
            byte a3 = this.buffer[0];
            byte b3 = this.buffer[1];
            int c3 = 0;
            buf[0] = pem_array[a3 >>> 2 & 0x3F];
            buf[1] = pem_array[(a3 << 4 & 0x30) + (b3 >>> 4 & 0xF)];
            buf[2] = pem_array[(b3 << 2 & 0x3C) + (c3 >>> 6 & 3)];
            buf[3] = 61;
        } else {
            byte a4 = this.buffer[0];
            byte b4 = this.buffer[1];
            byte c4 = this.buffer[2];
            buf[0] = pem_array[a4 >>> 2 & 0x3F];
            buf[1] = pem_array[(a4 << 4 & 0x30) + (b4 >>> 4 & 0xF)];
            buf[2] = pem_array[(b4 << 2 & 0x3C) + (c4 >>> 6 & 3)];
            buf[3] = pem_array[c4 & 0x3F];
        }
        try {
            this.outWriter.writeCharacters(buf, 0, 4);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Base64EncoderStream.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }
}

