/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.maskband.DefaultDatasetLayoutImpl;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GroundControlPoints;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultFileResourceInfo;
import org.geotools.data.DefaultFileServiceInfo;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FileGroupProvider;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger(AbstractGridCoverage2DReader.class);
    protected static double EPS = 1.0E-6;
    protected int numOverviews = 0;
    protected MathTransform raster2Model = null;
    protected CoordinateReferenceSystem crs = null;
    protected GeneralEnvelope originalEnvelope = null;
    protected String coverageName = "geotools_coverage";
    protected Object source = null;
    protected Hints hints = GeoTools.getDefaultHints();
    protected double[] highestRes = null;
    protected boolean closeMe;
    protected boolean gzipped;
    protected GridEnvelope originalGridRange = null;
    protected ImageInputStream inStream = null;
    protected double[][] overViewResolutions = null;
    protected GridCoverageFactory coverageFactory;
    protected Double[] scales;
    protected Double[] offsets;
    private Map<String, ArrayList<Resolution>> resolutionsLevelsMap = new HashMap<String, ArrayList<Resolution>>();
    protected ImageInputStreamSpi inStreamSPI;
    private ImageLayout imageLayout;
    protected DatasetLayout dtLayout;

    protected AbstractGridCoverage2DReader() {
    }

    public AbstractGridCoverage2DReader(Object input) throws DataSourceException {
        this(input, null);
    }

    public AbstractGridCoverage2DReader(Object input, Hints hints) throws DataSourceException {
        Object factory;
        if (hints == null) {
            this.hints = new Hints();
        }
        if (hints != null) {
            this.hints = hints.clone();
        }
        if (this.hints.containsKey(Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get(Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            this.coverageFactory = (GridCoverageFactory)factory;
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory(this.hints);
        }
        if (input == null) {
            IOException ex = new IOException(Errors.format(143, "input"));
            throw new DataSourceException(ex);
        }
        this.source = input;
    }

    protected boolean checkName(String coverageName) {
        Utilities.ensureNonNull("coverageName", coverageName);
        return coverageName.equalsIgnoreCase(this.coverageName);
    }

    @Override
    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        if (coverageName.equalsIgnoreCase(this.coverageName)) {
            return this.read(parameters);
        }
        throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
    }

    @Override
    public abstract GridCoverage2D read(GeneralParameterValue[] var1) throws IllegalArgumentException, IOException;

    protected Integer setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        return this.setReadParams(this.coverageName, overviewPolicy, readP, requestedEnvelope, requestedDim);
    }

    protected Integer setReadParams(String coverageName, OverviewPolicy overviewPolicy, ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        boolean useOverviews;
        Integer imageChoice = 0;
        if (overviewPolicy == null) {
            overviewPolicy = this.extractOverviewPolicy();
        }
        double[] requestedRes = AbstractGridCoverage2DReader.getResolution(requestedEnvelope, requestedDim, this.getCoordinateReferenceSystem(coverageName));
        this.decimationOnReadingControl(coverageName, imageChoice, readP, requestedRes);
        if (requestedRes == null) {
            return imageChoice;
        }
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        boolean bl = useOverviews = this.numOverviews > 0;
        if (useOverviews) {
            int newImageChoice = this.pickOverviewLevel(coverageName, overviewPolicy, requestedRes);
            if (imageChoice != newImageChoice) {
                imageChoice = newImageChoice;
                this.decimationOnReadingControl(coverageName, imageChoice, readP, requestedRes);
            }
        }
        return imageChoice;
    }

    private OverviewPolicy extractOverviewPolicy() {
        OverviewPolicy overviewPolicy = null;
        if (this.hints != null && this.hints.containsKey(Hints.OVERVIEW_POLICY)) {
            overviewPolicy = (OverviewPolicy)((Object)this.hints.get(Hints.OVERVIEW_POLICY));
        }
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        assert (overviewPolicy != null);
        return overviewPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer pickOverviewLevel(String coverageName, OverviewPolicy policy, double[] requestedRes) {
        double requestedScaleFactor;
        ArrayList<Resolution> resolutionsLevels;
        if (policy == null) {
            policy = this.extractOverviewPolicy();
        }
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            resolutionsLevels = this.resolutionsLevelsMap.get(coverageName);
            if (resolutionsLevels == null) {
                resolutionsLevels = new ArrayList();
                this.resolutionsLevelsMap.put(coverageName, resolutionsLevels);
                resolutionsLevels.add(new Resolution(1.0, this.getHighestRes()[0], this.getHighestRes()[1], 0));
                if (this.numOverviews > 0) {
                    for (int i = 0; i < this.overViewResolutions.length; ++i) {
                        resolutionsLevels.add(new Resolution(this.overViewResolutions[i][0] / this.getHighestRes()[0], this.overViewResolutions[i][0], this.overViewResolutions[i][1], i + 1));
                    }
                    Collections.sort(resolutionsLevels);
                }
            }
        }
        double reqx = requestedRes[0];
        double reqy = requestedRes[1];
        Resolution max = resolutionsLevels.get(0);
        double requestedScaleFactorX = reqx / max.resolutionX;
        double requestedScaleFactorY = reqy / max.resolutionY;
        boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
        double d2 = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (requestedScaleFactor <= 1.0) {
            return max.imageChoice;
        }
        Resolution min2 = resolutionsLevels.get(resolutionsLevels.size() - 1);
        if (requestedScaleFactor >= min2.scaleFactor) {
            return min2.imageChoice;
        }
        Resolution prev = max;
        int size = resolutionsLevels.size();
        for (int i = 1; i < size; ++i) {
            Resolution curr = resolutionsLevels.get(i);
            if (curr.scaleFactor == requestedScaleFactor) {
                return curr.imageChoice;
            }
            if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                if (policy == OverviewPolicy.QUALITY) {
                    return prev.imageChoice;
                }
                if (policy == OverviewPolicy.SPEED) {
                    return curr.imageChoice;
                }
                if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                    return prev.imageChoice;
                }
                return curr.imageChoice;
            }
            prev = curr;
        }
        return max.imageChoice;
    }

    @Override
    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.getReadingResolutions(this.coverageName, policy, requestedResolution);
    }

    @Override
    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        int imageIdx;
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        double[] result = this.numOverviews > 0 ? ((imageIdx = this.pickOverviewLevel(coverageName, policy, requestedResolution).intValue()) > 0 ? this.overViewResolutions[imageIdx - 1] : this.highestRes) : this.getHighestRes();
        double[] clone = new double[result.length];
        System.arraycopy(result, 0, clone, 0, result.length);
        return clone;
    }

    protected final void decimationOnReadingControl(String coverageName, Integer imageChoice, ImageReadParam readP, double[] requestedRes) {
        int h2;
        int w;
        double[] selectedRes = new double[2];
        int choice = imageChoice;
        if (choice == 0) {
            w = this.getOriginalGridRange(coverageName).getSpan(0);
            h2 = this.getOriginalGridRange(coverageName).getSpan(1);
            selectedRes[0] = this.getHighestRes()[0];
            selectedRes[1] = this.getHighestRes()[1];
        } else {
            selectedRes[0] = this.overViewResolutions[choice - 1][0];
            selectedRes[1] = this.overViewResolutions[choice - 1][1];
            w = (int)Math.round(this.getOriginalEnvelope(coverageName).getSpan(0) / selectedRes[0]);
            h2 = (int)Math.round(this.getOriginalEnvelope(coverageName).getSpan(1) / selectedRes[1]);
        }
        if (requestedRes == null) {
            readP.setSourceSubsampling(1, 1, 0, 0);
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h2 / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("coverageName:%s,imageChoice:%d,subSamplingFactorX:%d,subSamplingFactorY:%d", coverageName, (int)imageChoice, subSamplingFactorX, subSamplingFactorY));
            }
        }
    }

    protected final GridCoverage createImageCoverage(PlanarImage image) throws IOException {
        return this.createImageCoverage(this.coverageName, image);
    }

    protected final GridCoverage createImageCoverage(String coverageName, PlanarImage image) throws IOException {
        return this.createImageCoverage(coverageName, image, null);
    }

    protected final GridCoverage2D createImageCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        return this.createImageCoverage(this.coverageName, image, raster2Model);
    }

    protected final GridCoverage2D createImageCoverage(String coverageName, PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation(cm, i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension(colorInterpretation.name());
        }
        if (raster2Model != null) {
            return this.coverageFactory.create(coverageName, image, this.getCoordinateReferenceSystem(coverageName), raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)coverageName, (RenderedImage)image, new GeneralEnvelope(this.getOriginalEnvelope(coverageName)), bands, null, null);
    }

    protected static final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null && crs != null) {
                SingleCRS envelopeCrs2D = CRS.getHorizontalCRS(envelope.getCoordinateReferenceSystem());
                if (envelopeCrs2D != null && !CRS.equalsIgnoreMetadata(crs, envelopeCrs2D)) {
                    CoordinateOperationFactory operationFactory = CRS.getCoordinateOperationFactory(true);
                    CoordinateOperation op = operationFactory.createOperation(envelopeCrs2D, crs);
                    envelope = CRS.transform(op, (Envelope)envelope);
                    envelope.setCoordinateReferenceSystem(crs);
                }
                requestedRes = new double[]{envelope.getSpan(0) / dim.getWidth(), envelope.getSpan(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e2) {
            throw new DataSourceException("Unable to get resolution", e2);
        }
        catch (FactoryException e3) {
            throw new DataSourceException("Unable to get resolution", e3);
        }
    }

    @Override
    public GridEnvelope getOriginalGridRange() {
        return this.getOriginalGridRange(this.coverageName);
    }

    @Override
    public GridEnvelope getOriginalGridRange(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        assert (this.originalGridRange.getDimension() == 2);
        return new GridEnvelope2D(this.originalGridRange.getLow(0), this.originalGridRange.getLow(1), this.originalGridRange.getSpan(0), this.originalGridRange.getSpan(1));
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoordinateReferenceSystem(this.coverageName);
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.crs;
    }

    @Override
    public GeneralEnvelope getOriginalEnvelope() {
        return this.getOriginalEnvelope(this.coverageName);
    }

    @Override
    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return new GeneralEnvelope(this.originalEnvelope);
    }

    @Override
    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.getOriginalGridToWorld(this.coverageName, pixInCell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        AffineTransform tr;
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            if (this.raster2Model == null) {
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.getOriginalGridRange(coverageName), this.getOriginalEnvelope(coverageName));
                geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                this.raster2Model = geMapper.createTransform();
            }
        }
        if (pixInCell == PixelInCell.CELL_CENTER) {
            return this.raster2Model;
        }
        if (this.raster2Model instanceof AffineTransform) {
            tr = new AffineTransform((AffineTransform)((Object)this.raster2Model));
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        if (this.raster2Model instanceof IdentityTransform) {
            tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        throw new IllegalStateException("This reader's grid to world transform is invalud!");
    }

    @Override
    public final Object getSource() {
        return this.source;
    }

    @Override
    public void dispose() {
        block3: {
            if (this.inStream != null && this.closeMe) {
                try {
                    this.inStream.close();
                }
                catch (IOException e2) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                }
            }
        }
    }

    @Override
    public String[] getGridCoverageNames() {
        return new String[]{this.coverageName};
    }

    @Override
    public String[] getMetadataNames(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.getMetadataNames();
    }

    @Override
    public String[] getMetadataNames() {
        return null;
    }

    @Override
    public String getMetadataValue(String name) {
        return this.getMetadataValue(this.coverageName, name);
    }

    @Override
    public String getMetadataValue(String coverageName, String name) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return null;
    }

    @Override
    public int getGridCoverageCount() {
        return 1;
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info;
        try {
            List<FileGroupProvider.FileGroup> files = this.getFiles();
            info = files != null && !files.isEmpty() ? new DefaultFileServiceInfo(files) : new DefaultServiceInfo();
        }
        catch (IOException e2) {
            LOGGER.log(Level.WARNING, "Failed to locate source file list", e2);
            info = new DefaultServiceInfo();
        }
        info.setDescription(this.source == null ? null : String.valueOf(this.source));
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            info.setTitle(url.getFile());
            try {
                info.setSource(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                info.setTitle(file.getName());
            }
            info.setSource(file.toURI());
        }
        return info;
    }

    protected List<FileGroupProvider.FileGroup> getFiles() throws IOException {
        File file = this.getSourceAsFile();
        if (file == null) {
            return null;
        }
        return Collections.singletonList(new FileGroupProvider.FileGroup(file, null, null));
    }

    protected File getSourceAsFile() {
        File sf;
        File file = null;
        if (this.source instanceof File) {
            file = (File)this.source;
        } else if (this.source instanceof URL && (sf = URLs.urlToFile((URL)this.source)).exists()) {
            file = sf;
        }
        return file;
    }

    @Override
    public ResourceInfo getInfo(String coverageName) {
        DefaultResourceInfo info = null;
        try {
            List<FileGroupProvider.FileGroup> files = this.getFiles();
            info = files != null && !files.isEmpty() ? new DefaultFileResourceInfo(files) : new DefaultResourceInfo();
        }
        catch (IOException e2) {
            LOGGER.log(Level.WARNING, "Failed to locate source file list", e2);
            info = new DefaultResourceInfo();
        }
        return info;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.getDynamicParameters(this.coverageName);
    }

    @Override
    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        return Collections.emptySet();
    }

    @Override
    public DatasetLayout getDatasetLayout() {
        return this.getDatasetLayout(this.coverageName);
    }

    @Override
    public DatasetLayout getDatasetLayout(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + " is not supported");
        }
        if (this.dtLayout == null) {
            return new DefaultDatasetLayoutImpl(){

                @Override
                public int getNumInternalOverviews() {
                    return AbstractGridCoverage2DReader.this.numOverviews;
                }
            };
        }
        return this.dtLayout;
    }

    public GridEnvelope getOverviewGridEnvelope(int overviewIndex) throws IOException {
        return this.getOverviewGridEnvelope(this.coverageName, overviewIndex);
    }

    public GridEnvelope getOverviewGridEnvelope(String coverageName, int overviewIndex) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return null;
    }

    @Override
    public ImageLayout getImageLayout(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return (ImageLayout)this.imageLayout.clone();
    }

    @Override
    public ImageLayout getImageLayout() throws IOException {
        return this.getImageLayout(this.coverageName);
    }

    protected void setLayout(ImageReader reader) throws IOException {
        Utilities.ensureNonNull("reader", reader);
        ImageLayout2 layout = new ImageLayout2();
        ImageTypeSpecifier its = reader.getImageTypes(0).next();
        layout.setColorModel(its.getColorModel()).setSampleModel(its.getSampleModel());
        layout.setMinX(0).setMinY(0).setWidth(reader.getWidth(0)).setHeight(reader.getHeight(0));
        layout.setTileGridXOffset(0).setTileGridYOffset(0).setTileWidth(reader.getTileWidth(0)).setTileHeight(reader.getTileHeight(0));
        this.setlayout(layout);
    }

    protected void setlayout(ImageLayout layout) {
        Utilities.ensureNonNull("layout", layout);
        this.imageLayout = (ImageLayout)layout.clone();
    }

    @Override
    public double[][] getResolutionLevels() throws IOException {
        return this.getResolutionLevels(this.coverageName);
    }

    @Override
    public double[][] getResolutionLevels(String coverageName) throws IOException {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        double[][] returnValue = new double[this.numOverviews + 1][2];
        double[] hres = this.getHighestRes();
        if (hres == null) {
            return null;
        }
        System.arraycopy(hres, 0, returnValue[0], 0, 2);
        for (int i = 1; i < returnValue.length; ++i) {
            System.arraycopy(this.overViewResolutions[i - 1], 0, returnValue[i], 0, 2);
        }
        return returnValue;
    }

    protected double[] getHighestRes(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return this.highestRes;
    }

    double[] getHighestRes() {
        return this.getHighestRes(this.coverageName);
    }

    public GroundControlPoints getGroundControlPoints() {
        return null;
    }

    public GroundControlPoints getGroundControlPoints(String coverageName) {
        if (!this.checkName(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName " + coverageName + "is not supported");
        }
        return null;
    }

    protected AffineTransform getRescaledRasterToModel(RenderedImage coverageRaster) {
        int ssWidth = coverageRaster.getWidth();
        int ssHeight = coverageRaster.getHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Coverage read: width = " + ssWidth + " height = " + ssHeight);
        }
        double scaleX = (double)this.originalGridRange.getSpan(0) / (1.0 * (double)ssWidth);
        double scaleY = (double)this.originalGridRange.getSpan(1) / (1.0 * (double)ssHeight);
        AffineTransform tempRaster2Model = new AffineTransform((AffineTransform)((Object)this.raster2Model));
        AffineTransform scale = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
        if (!XAffineTransform.isIdentity(scale, EPS)) {
            tempRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            tempRaster2Model.concatenate(scale);
            tempRaster2Model.concatenate(CoverageUtilities.CORNER_TO_CENTER);
        }
        return tempRaster2Model;
    }

    protected static File getSibling(File file, String extension) {
        String parentPath = file.getParent();
        String filename = file.getName();
        int i = filename.lastIndexOf(46);
        filename = i == -1 ? filename : filename.substring(0, i);
        String base = parentPath != null ? parentPath + File.separator + filename : filename;
        File file2Parse = new File(base + extension);
        if (file2Parse.exists()) {
            return file2Parse;
        }
        return null;
    }

    protected void addAllSiblings(File file, List<File> files, String ... extensions) {
        String parentPath = file.getParent();
        String filename = file.getName();
        int i = filename.lastIndexOf(46);
        filename = i == -1 ? filename : filename.substring(0, i);
        String base = parentPath != null ? parentPath + File.separator + filename : filename;
        for (String extension : extensions) {
            File file2Parse = new File(base + extension);
            if (!file2Parse.exists()) continue;
            files.add(file2Parse);
        }
    }

    protected void addSiblings(List<File> files, File ... siblings) {
        for (File sibling : siblings) {
            if (sibling == null || !sibling.exists()) continue;
            files.add(sibling);
        }
    }

    protected MultiLevelROIProvider getMultiLevelROIProvider(String coverageName) {
        throw new UnsupportedOperationException("The abstract reader doesn't implement this method yet");
    }

    protected void collectScaleOffset(IIOMetadata iioMetadata) {
        if (iioMetadata instanceof CoreCommonImageMetadata) {
            CoreCommonImageMetadata ccm = (CoreCommonImageMetadata)iioMetadata;
            this.scales = ccm.getScales();
            this.offsets = ccm.getOffsets();
        }
    }

    private static class Resolution
    implements Comparable<Resolution> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public Resolution(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(Resolution other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "Resolution[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }
    }
}

