/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import org.ejml.data.CMatrix;
import org.ejml.data.Complex_F32;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseTriplet;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrixSparseTriplet;
import org.ejml.data.ReshapeMatrix;
import org.ejml.data.ZMatrix;
import org.ejml.ops.ReadMatrixCsv;

public class MatrixIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBin(DMatrix A2, String fileName) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(fileName);
        ObjectOutputStream stream = new ObjectOutputStream(fileStream);
        try {
            stream.writeObject(A2);
            stream.flush();
        }
        finally {
            try {
                stream.close();
            }
            finally {
                fileStream.close();
            }
        }
    }

    public static <T extends DMatrix> T loadBin(String fileName) throws IOException {
        DMatrix ret;
        FileInputStream fileStream = new FileInputStream(fileName);
        ObjectInputStream stream = new ObjectInputStream(fileStream);
        try {
            ret = (DMatrix)stream.readObject();
            if (stream.available() != 0) {
                throw new RuntimeException("File not completely read?");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        stream.close();
        return (T)ret;
    }

    public static void saveDenseCSV(DMatrix A2, String fileName) throws IOException {
        PrintStream fileStream = new PrintStream(fileName);
        fileStream.println(A2.getNumRows() + " " + A2.getNumCols() + " real");
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                fileStream.print(A2.get(i, j) + " ");
            }
            fileStream.println();
        }
        fileStream.close();
    }

    public static void saveSparseCSV(DMatrixSparseTriplet A2, String fileName) throws IOException {
        PrintStream fileStream = new PrintStream(fileName);
        fileStream.println(A2.getNumRows() + " " + A2.getNumCols() + " " + A2.nz_length + " real");
        for (int i = 0; i < A2.nz_length; ++i) {
            DMatrixSparseTriplet.Element e2 = A2.nz_data[i];
            fileStream.println(e2.row + " " + e2.col + " " + e2.value);
        }
        fileStream.close();
    }

    public static void saveSparseCSV(FMatrixSparseTriplet A2, String fileName) throws IOException {
        PrintStream fileStream = new PrintStream(fileName);
        fileStream.println(A2.getNumRows() + " " + A2.getNumCols() + " " + A2.nz_length + " real");
        for (int i = 0; i < A2.nz_length; ++i) {
            FMatrixSparseTriplet.Element e2 = A2.nz_data[i];
            fileStream.println(e2.row + " " + e2.col + " " + e2.value);
        }
        fileStream.close();
    }

    public static <T extends DMatrix> T loadCSV(String fileName, boolean doublePrecision) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileName);
        ReadMatrixCsv csv = new ReadMatrixCsv(fileStream);
        Object ret = doublePrecision ? csv.read64() : (DMatrix)csv.read32();
        fileStream.close();
        return (T)ret;
    }

    public static DMatrixRMaj loadCSV(String fileName, int numRows, int numCols) throws IOException {
        FileInputStream fileStream = new FileInputStream(fileName);
        ReadMatrixCsv csv = new ReadMatrixCsv(fileStream);
        DMatrixRMaj ret = csv.readDDRM(numRows, numCols);
        fileStream.close();
        return ret;
    }

    public static void print(PrintStream out, DMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, DMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, DMatrix mat, String format) {
        String type = ReshapeMatrix.class.isAssignableFrom(mat.getClass()) ? "dense64" : "dense64 fixed";
        out.println("Type = " + type + " real , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                out.printf(format, mat.get(y, x));
            }
            out.println();
        }
    }

    public static void printJava(PrintStream out, DMatrix mat, String format) {
        String type = mat.getType().getBits() == 64 ? "double" : "float";
        out.println("new " + type + "[][]{");
        format = format + " ";
        for (int y = 0; y < mat.getNumRows(); ++y) {
            out.print("{");
            for (int x = 0; x < mat.getNumCols(); ++x) {
                out.printf(format, mat.get(y, x));
                if (x + 1 >= mat.getNumCols()) continue;
                out.print(", ");
            }
            if (y + 1 < mat.getNumRows()) {
                out.println("},");
                continue;
            }
            out.println("}};");
        }
    }

    public static void print(PrintStream out, FMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, FMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f ";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, FMatrix mat, String format) {
        String type = mat.getClass().getSimpleName();
        out.println("Type = " + type + " , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                out.printf(format, Float.valueOf(mat.get(y, x)));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, DMatrix mat, String format, int row0, int row1, int col0, int col1) {
        out.println("Type = submatrix , rows " + row0 + " to " + row1 + "  columns " + col0 + " to " + col1);
        format = format + " ";
        for (int y = row0; y < row1; ++y) {
            for (int x = col0; x < col1; ++x) {
                out.printf(format, mat.get(y, x));
            }
            out.println();
        }
    }

    public static void printJava(PrintStream out, FMatrix mat, String format) {
        String type = mat.getType().getBits() == 64 ? "double" : "float";
        out.println("new " + type + "[][]{");
        format = format + " ";
        for (int y = 0; y < mat.getNumRows(); ++y) {
            out.print("{");
            for (int x = 0; x < mat.getNumCols(); ++x) {
                out.printf(format, Float.valueOf(mat.get(y, x)));
                if (x + 1 >= mat.getNumCols()) continue;
                out.print(", ");
            }
            if (y + 1 < mat.getNumRows()) {
                out.println("},");
                continue;
            }
            out.println("}};");
        }
    }

    public static void print(PrintStream out, FMatrix mat, String format, int row0, int row1, int col0, int col1) {
        out.println("Type = submatrix , rows " + row0 + " to " + row1 + "  columns " + col0 + " to " + col1);
        format = format + " ";
        for (int y = row0; y < row1; ++y) {
            for (int x = col0; x < col1; ++x) {
                out.printf(format, Float.valueOf(mat.get(y, x)));
            }
            out.println();
        }
    }

    public static void print(PrintStream out, ZMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, CMatrix mat) {
        MatrixIO.print(out, mat, 6, 3);
    }

    public static void print(PrintStream out, ZMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f + %" + numChar + "." + precision + "fi";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, CMatrix mat, int numChar, int precision) {
        String format = "%" + numChar + "." + precision + "f + %" + numChar + "." + precision + "fi";
        MatrixIO.print(out, mat, format);
    }

    public static void print(PrintStream out, ZMatrix mat, String format) {
        String type = "dense64";
        out.println("Type = " + type + " complex , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        Complex_F64 c2 = new Complex_F64();
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                mat.get(y, x, c2);
                out.printf(format, c2.real, c2.imaginary);
                if (x >= mat.getNumCols() - 1) continue;
                out.print(" , ");
            }
            out.println();
        }
    }

    public static void print(PrintStream out, CMatrix mat, String format) {
        String type = "dense32";
        out.println("Type = " + type + " complex , numRows = " + mat.getNumRows() + " , numCols = " + mat.getNumCols());
        format = format + " ";
        Complex_F32 c2 = new Complex_F32();
        for (int y = 0; y < mat.getNumRows(); ++y) {
            for (int x = 0; x < mat.getNumCols(); ++x) {
                mat.get(y, x, c2);
                out.printf(format, Float.valueOf(c2.real), Float.valueOf(c2.imaginary));
                if (x >= mat.getNumCols() - 1) continue;
                out.print(" , ");
            }
            out.println();
        }
    }
}

