/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.generic;

import java.util.Random;
import org.ejml.data.DMatrix;

public class GenericMatrixOps_F64 {
    public static boolean isEquivalent(DMatrix a2, DMatrix b2, double tol) {
        if (a2.getNumRows() != b2.getNumRows() || a2.getNumCols() != b2.getNumCols()) {
            return false;
        }
        for (int i = 0; i < a2.getNumRows(); ++i) {
            for (int j = 0; j < a2.getNumCols(); ++j) {
                double diff = Math.abs(a2.get(i, j) - b2.get(i, j));
                if (!(diff > tol)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(DMatrix a2, double tol) {
        for (int i = 0; i < a2.getNumRows(); ++i) {
            for (int j = 0; j < a2.getNumCols(); ++j) {
                if (!(i == j ? Math.abs(a2.get(i, j) - 1.0) > tol : Math.abs(a2.get(i, j)) > tol)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEquivalentTriangle(boolean upper, DMatrix a2, DMatrix b2, double tol) {
        if (a2.getNumRows() != b2.getNumRows() || a2.getNumCols() != b2.getNumCols()) {
            return false;
        }
        if (upper) {
            for (int i = 0; i < a2.getNumRows(); ++i) {
                for (int j = i; j < a2.getNumCols(); ++j) {
                    double diff = Math.abs(a2.get(i, j) - b2.get(i, j));
                    if (!(diff > tol)) continue;
                    return false;
                }
            }
        } else {
            for (int j = 0; j < a2.getNumCols(); ++j) {
                for (int i = j; i < a2.getNumRows(); ++i) {
                    double diff = Math.abs(a2.get(i, j) - b2.get(i, j));
                    if (!(diff > tol)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void copy(DMatrix from, DMatrix to) {
        int numCols = from.getNumCols();
        int numRows = from.getNumRows();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                to.set(i, j, from.get(i, j));
            }
        }
    }

    public static void setRandom(DMatrix a2, double min2, double max, Random rand) {
        for (int i = 0; i < a2.getNumRows(); ++i) {
            for (int j = 0; j < a2.getNumCols(); ++j) {
                double val = rand.nextDouble() * (max - min2) + min2;
                a2.set(i, j, val);
            }
        }
    }
}

