/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.graphs;

import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetDifference;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetIntersection;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetUnion;

public class UndirectedGraph
implements IGraph {
    private final ISet[] neighbors;
    private ISet nodes;
    private final int n;
    private final SetType edgeSetType;
    private final SetType nodeSetType;

    public UndirectedGraph(Model model, int n, SetType nodeSetType, SetType edgeSetType, boolean allNodes) {
        this.edgeSetType = edgeSetType;
        this.nodeSetType = nodeSetType;
        this.n = n;
        this.neighbors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.neighbors[i] = SetFactory.makeStoredSet(this.edgeSetType, 0, model);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeStoredSet(this.nodeSetType, 0, model);
    }

    public UndirectedGraph(Model model, int n, SetType edgeSetType, boolean allNodes) {
        this(model, n, SetType.BITSET, edgeSetType, allNodes);
    }

    public UndirectedGraph(int n, SetType nodeSetType, SetType edgeSetType, boolean allNodes) {
        this.edgeSetType = edgeSetType;
        this.nodeSetType = nodeSetType;
        this.n = n;
        this.neighbors = new ISet[n];
        for (int i = 0; i < n; ++i) {
            this.neighbors[i] = SetFactory.makeSet(edgeSetType, 0);
        }
        this.nodes = allNodes ? SetFactory.makeConstantSet(0, n - 1) : SetFactory.makeSet(nodeSetType, 0);
    }

    public UndirectedGraph(int n, SetType edgeSetType, boolean allNodes) {
        this(n, SetType.BITSET, edgeSetType, allNodes);
    }

    public UndirectedGraph(UndirectedGraph g2) {
        this.nodeSetType = SetType.FIXED_ARRAY;
        this.edgeSetType = SetType.FIXED_ARRAY;
        this.n = g2.getNbMaxNodes();
        this.nodes = SetFactory.makeConstantSet(g2.getNodes().toArray());
        this.neighbors = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.neighbors[i] = SetFactory.makeConstantSet(g2.getNeighborsOf(i).toArray());
        }
    }

    public UndirectedGraph(Model model, UndirectedGraph g2, ISet nodes, boolean exclude) {
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        this.nodes = exclude ? new SetDifference(model, g2.getNodes(), nodes) : new SetIntersection(model, g2.getNodes(), nodes);
        this.neighbors = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.neighbors[i] = exclude ? new SetDifference(model, g2.getNeighborsOf(i), nodes) : new SetIntersection(model, g2.getNeighborsOf(i), nodes);
        }
    }

    public UndirectedGraph(Model model, UndirectedGraph g2, UndirectedGraph UB, ISet nodes, boolean exclude) {
        int i;
        ISetIterator iSetIterator;
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        boolean needDynamic = false;
        ISet neighNeeded = UB.nodes;
        if (exclude) {
            iSetIterator = nodes.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!UB.getNodes().contains(i)) continue;
                needDynamic = true;
                this.nodes = new SetDifference(model, g2.getNodes(), nodes);
                neighNeeded = new SetDifference(model, UB.getNodes(), nodes);
                break;
            }
        } else {
            iSetIterator = UB.getNodes().iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (nodes.contains(i)) continue;
                needDynamic = true;
                SetType nodeSetType = g2.getNodeSetType();
                this.nodes = new SetIntersection(model, nodeSetType, 0, g2.getNodes(), nodes);
                neighNeeded = new SetIntersection(model, nodeSetType, 0, UB.getNodes(), nodes);
                break;
            }
        }
        if (!needDynamic) {
            this.nodes = g2.nodes;
        }
        this.neighbors = new ISet[this.n];
        iSetIterator = neighNeeded.iterator();
        while (iSetIterator.hasNext()) {
            int j;
            ISetIterator iSetIterator2;
            i = (Integer)iSetIterator.next();
            needDynamic = false;
            if (exclude) {
                iSetIterator2 = nodes.iterator();
                while (iSetIterator2.hasNext()) {
                    j = (Integer)iSetIterator2.next();
                    if (!UB.getNeighborsOf(i).contains(j)) continue;
                    needDynamic = true;
                    this.neighbors[i] = new SetDifference(model, g2.getNeighborsOf(i), nodes);
                    break;
                }
            } else {
                iSetIterator2 = UB.getNeighborsOf(i).iterator();
                while (iSetIterator2.hasNext()) {
                    j = (Integer)iSetIterator2.next();
                    if (nodes.contains(j)) continue;
                    needDynamic = true;
                    SetType edgeSetType = g2.getEdgeSetType();
                    this.neighbors[i] = new SetIntersection(model, edgeSetType, 0, g2.getNeighborsOf(i), nodes);
                    break;
                }
            }
            if (needDynamic) continue;
            this.neighbors[i] = g2.neighbors[i];
        }
    }

    public UndirectedGraph(Model model, UndirectedGraph g2, ISet[] edges, boolean exclude) {
        assert (edges.length == g2.getNbMaxNodes());
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        this.neighbors = new ISet[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.neighbors[i] = exclude ? new SetDifference(model, g2.getNeighborsOf(i), edges[i]) : new SetIntersection(model, g2.getNeighborsOf(i), edges[i]);
        }
        this.nodes = new SetUnion(model, this.neighbors);
    }

    public UndirectedGraph(Model model, UndirectedGraph g2, UndirectedGraph UB, ISet[] edges, boolean exclude) {
        assert (edges.length == g2.getNbMaxNodes());
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = g2.getNbMaxNodes();
        this.neighbors = new ISet[this.n];
        boolean nodeNeedDynamic = false;
        for (int i = 0; i < this.n; ++i) {
            int j;
            ISetIterator iSetIterator;
            boolean needDynamic = false;
            if (exclude) {
                iSetIterator = edges[i].iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (!UB.getNeighborsOf(i).contains(j)) continue;
                    needDynamic = true;
                    nodeNeedDynamic = true;
                    this.neighbors[i] = new SetDifference(model, g2.getNeighborsOf(i), edges[i]);
                    break;
                }
            } else {
                iSetIterator = UB.getNeighborsOf(i).iterator();
                while (iSetIterator.hasNext()) {
                    j = (Integer)iSetIterator.next();
                    if (edges[i].contains(j)) continue;
                    needDynamic = true;
                    nodeNeedDynamic = true;
                    this.neighbors[i] = new SetIntersection(model, g2.getEdgeSetType(), 0, g2.getNeighborsOf(i), edges[i]);
                    break;
                }
            }
            if (needDynamic) continue;
            this.neighbors[i] = g2.neighbors[i];
        }
        this.nodes = nodeNeedDynamic ? new SetUnion(model, g2.nodeSetType, 0, this.neighbors) : g2.nodes;
    }

    public UndirectedGraph(Model model, UndirectedGraph g2, int[][] edges, boolean exclude) {
        this(model, g2, UndirectedGraph.edgesArrayToEdgesSets(g2.getNbMaxNodes(), edges), exclude);
    }

    public UndirectedGraph(Model model, UndirectedGraph g2, UndirectedGraph UB, int[][] edges, boolean exclude) {
        this(model, g2, UB, UndirectedGraph.edgesArrayToEdgesSets(g2.getNbMaxNodes(), edges), exclude);
    }

    public UndirectedGraph(Model model, UndirectedGraph ... graphs) {
        int i2;
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = IntStream.range(0, graphs.length).map(i -> graphs[i].getNbMaxNodes()).max().getAsInt();
        ISet[] nodeSets = new ISet[graphs.length];
        for (i2 = 0; i2 < graphs.length; ++i2) {
            nodeSets[i2] = graphs[i2].getNodes();
        }
        this.nodes = new SetUnion(model, nodeSets);
        this.neighbors = new ISet[this.n];
        for (i2 = 0; i2 < this.n; ++i2) {
            ISet[] neighSet = new ISet[graphs.length];
            for (int j = 0; j < graphs.length; ++j) {
                neighSet[j] = graphs[j].getNeighborsOf(i2);
            }
            this.neighbors[i2] = new SetUnion(model, neighSet);
        }
    }

    public UndirectedGraph(Model model, ISet additionalNodes, ISet[] additionalNeigh, UndirectedGraph ... graphs) {
        int i2;
        this.nodeSetType = SetType.DYNAMIC;
        this.edgeSetType = SetType.DYNAMIC;
        this.n = IntStream.range(0, graphs.length).map(i -> graphs[i].getNbMaxNodes()).max().getAsInt();
        ISet[] nodeSets = new ISet[graphs.length + 1];
        for (i2 = 0; i2 < graphs.length; ++i2) {
            nodeSets[i2] = graphs[i2].getNodes();
        }
        nodeSets[graphs.length] = additionalNodes;
        this.nodes = new SetUnion(model, nodeSets);
        this.neighbors = new ISet[this.n];
        for (i2 = 0; i2 < this.n; ++i2) {
            ISet[] neighSet = new ISet[graphs.length + 1];
            for (int j = 0; j < graphs.length; ++j) {
                neighSet[j] = graphs[j].getNeighborsOf(i2);
            }
            neighSet[graphs.length] = additionalNeigh[i2];
            this.neighbors[i2] = new SetUnion(model, neighSet);
        }
    }

    public static ISet[] edgesArrayToEdgesSets(int n, int[][] edges) {
        ISet[] neigh = new ISet[n];
        for (int i = 0; i < n; ++i) {
            int finalI = i;
            neigh[i] = SetFactory.makeConstantSet(IntStream.range(0, edges.length).filter(v -> {
                assert (edges[v].length == 2);
                return edges[v][0] == finalI || edges[v][1] == finalI;
            }).map(v -> {
                if (edges[v][0] == finalI) {
                    return edges[v][1];
                }
                return edges[v][0];
            }).toArray());
        }
        return neigh;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes : \n").append(this.nodes).append("\n");
        sb.append("neighbors : \n");
        ISetIterator iSetIterator = this.nodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            sb.append(i).append(" -> {");
            ISetIterator iSetIterator2 = this.neighbors[i].iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                sb.append(j).append(" ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public ISet getNodes() {
        return this.nodes;
    }

    @Override
    public SetType getEdgeSetType() {
        return this.edgeSetType;
    }

    @Override
    public SetType getNodeSetType() {
        return this.nodeSetType;
    }

    @Override
    public boolean addNode(int x) {
        return this.nodes.add(x);
    }

    @Override
    public boolean removeNode(int x) {
        if (this.nodes.remove(x)) {
            ISetIterator nei = this.getNeighborsOf(x).iterator();
            while (nei.hasNext()) {
                this.neighbors[nei.nextInt()].remove(x);
            }
            this.neighbors[x].clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean addEdge(int x, int y) {
        this.addNode(x);
        this.addNode(y);
        if (x == y) {
            return this.neighbors[x].add(y);
        }
        if (this.neighbors[x].add(y)) {
            boolean b2 = this.neighbors[y].add(x);
            assert (b2) : "asymmetric adjacency matrix in an undirected graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEdge(int x, int y) {
        if (this.neighbors[x].contains(y)) {
            assert (this.neighbors[y].contains(x)) : "asymmetric adjacency matrix in an undirected graph";
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEdge(int x, int y) {
        if (x == y) {
            return this.neighbors[y].remove(x);
        }
        if (this.neighbors[x].remove(y)) {
            boolean b2 = this.neighbors[y].remove(x);
            assert (b2) : "asymmetric adjacency matrix in an undirected graph";
            return true;
        }
        return false;
    }

    public ISet getNeighborsOf(int x) {
        return this.neighbors[x];
    }

    @Override
    @Deprecated
    public ISet getPredecessorsOf(int x) {
        return this.neighbors[x];
    }

    @Override
    @Deprecated
    public ISet getSuccessorsOf(int x) {
        return this.neighbors[x];
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public int getDomainSize() {
        int size = 0;
        ISetIterator iSetIterator = this.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int n = (Integer)iSetIterator.next();
            size += this.getNeighborsOf(n).size() + 1;
        }
        return size;
    }

    public boolean equals(UndirectedGraph other) {
        if (this.getNodes().size() != other.getNodes().size()) {
            return false;
        }
        ISetIterator iSetIterator = this.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (!other.containsNode(i)) {
                return false;
            }
            if (this.getNeighborsOf(i).size() != other.getNeighborsOf(i).size()) {
                return false;
            }
            ISetIterator iSetIterator2 = this.getNeighborsOf(i).iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (other.containsEdge(i, j)) continue;
                return false;
            }
        }
        return true;
    }
}

