/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import java.util.Random;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableEvaluator;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.objects.setDataStructures.swapList.Set_Std_Swap;

public class RandomVar<T extends Variable>
implements VariableSelector<T>,
VariableEvaluator<T> {
    private final Set_Std_Swap sets;
    private final Random random;

    public RandomVar(long seed, IntVar[] scope) {
        this.sets = new Set_Std_Swap(scope[0].getEnvironment(), 0);
        for (int i = 0; i < scope.length; ++i) {
            this.sets.add(i);
        }
        this.random = new Random(seed);
    }

    @Override
    public T getVariable(T[] variables) {
        while (this.sets.size() > 0) {
            int nextIdx = this.random.nextInt(this.sets.size());
            int nextVal = this.sets.getNth(nextIdx);
            if (variables[nextVal].isInstantiated()) {
                this.sets.remove(nextVal);
                continue;
            }
            return variables[nextVal];
        }
        return null;
    }

    @Override
    public double evaluate(T variable) {
        return this.random.nextDouble();
    }
}

