/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.MathUtils;

public class PropTimesNaive
extends Propagator<IntVar> {
    protected static final int MAX = 0x7FFFFFFE;
    protected static final int MIN = -2147483647;
    private final IntVar v0;
    private final IntVar v1;
    private final IntVar v2;

    public PropTimesNaive(IntVar v1, IntVar v2, IntVar result) {
        super((Variable[])new IntVar[]{v1, v2, result}, (Priority)PropagatorPriority.TERNARY, false);
        this.v0 = ((IntVar[])this.vars)[0];
        this.v1 = ((IntVar[])this.vars)[1];
        this.v2 = ((IntVar[])this.vars)[2];
    }

    @Override
    public final int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        for (boolean hasChanged = true; hasChanged; hasChanged |= this.mul(this.v2, this.v0.getLB(), this.v0.getUB(), this.v1.getLB(), this.v1.getUB())) {
            hasChanged = this.div(this.v0, this.v2.getLB(), this.v2.getUB(), this.v1.getLB(), this.v1.getUB());
            hasChanged |= this.div(this.v1, this.v2.getLB(), this.v2.getUB(), this.v0.getLB(), this.v0.getUB());
        }
        if (this.v2.isInstantiatedTo(0) && (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(0))) {
            this.setPassive();
        }
    }

    @Override
    public final ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.v0.getValue() * this.v1.getValue() == this.v2.getValue());
        }
        return ESat.UNDEFINED;
    }

    private boolean div(IntVar var, int a2, int b2, int c2, int d2) throws ContradictionException {
        if (a2 <= 0 && b2 >= 0 && c2 <= 0 && d2 >= 0) {
            int min2 = -2147483647;
            int max = 0x7FFFFFFE;
            return var.updateLowerBound(min2, this) | var.updateUpperBound(max, this);
        }
        if (c2 != 0 || d2 != 0 || a2 <= 0 && b2 >= 0) {
            int max;
            if (c2 < 0 && d2 > 0 && (a2 > 0 || b2 < 0)) {
                int max2 = Math.max(Math.abs(a2), Math.abs(b2));
                int min3 = -max2;
                return var.updateLowerBound(min3, this) | var.updateUpperBound(max2, this);
            }
            if (c2 == 0 && d2 != 0 && (a2 > 0 || b2 < 0)) {
                return this.div(var, a2, b2, 1, d2);
            }
            if (c2 != 0 && d2 == 0 && (a2 > 0 || b2 < 0)) {
                return this.div(var, a2, b2, c2, -1);
            }
            float ac = (float)a2 / (float)c2;
            float ad = (float)a2 / (float)d2;
            float bc = (float)b2 / (float)c2;
            float bd = (float)b2 / (float)d2;
            float low = Math.min(Math.min(ac, ad), Math.min(bc, bd));
            float high = Math.max(Math.max(ac, ad), Math.max(bc, bd));
            int min4 = (int)Math.round(Math.ceil(low));
            if (min4 > (max = (int)Math.round(Math.floor(high)))) {
                this.fails();
            }
            return var.updateLowerBound(min4, this) | var.updateUpperBound(max, this);
        }
        this.fails();
        return false;
    }

    private boolean mul(IntVar var, int a2, int b2, int c2, int d2) throws ContradictionException {
        int min2 = Math.min(Math.min(MathUtils.safeMultiply(a2, c2), MathUtils.safeMultiply(a2, d2)), Math.min(MathUtils.safeMultiply(b2, c2), MathUtils.safeMultiply(b2, d2)));
        int max = Math.max(Math.max(MathUtils.safeMultiply(a2, c2), MathUtils.safeMultiply(a2, d2)), Math.max(MathUtils.safeMultiply(b2, c2), MathUtils.safeMultiply(b2, d2)));
        return var.updateLowerBound(min2, this) | var.updateUpperBound(max, this);
    }
}

