/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.nodes;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropNodeSetChannel
extends Propagator<Variable> {
    private final SetVar set;
    private final GraphVar<?> g;
    private final ISetDeltaMonitor sdm;
    private final IGraphDeltaMonitor gdm;
    private final IntProcedure forceG;
    private final IntProcedure forceS;
    private final IntProcedure remG;
    private final IntProcedure remS;

    public PropNodeSetChannel(SetVar vertexSet, GraphVar<?> gV) {
        super(new Variable[]{vertexSet, gV}, (Priority)PropagatorPriority.LINEAR, true);
        this.set = vertexSet;
        this.g = gV;
        this.sdm = this.set.monitorDelta(this);
        this.gdm = this.g.monitorDelta(this);
        this.forceS = element -> this.g.enforceNode(element, this);
        this.remS = element -> this.g.removeNode(element, this);
        this.forceG = element -> this.set.force(element, this);
        this.remG = element -> this.set.remove(element, this);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.ADD_TO_KER.getMask() + SetEventType.REMOVE_FROM_ENVELOPE.getMask();
        }
        return GraphEventType.ADD_NODE.getMask() + GraphEventType.REMOVE_NODE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        ISetIterator iSetIterator = this.set.getUB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getMandatoryNodes().contains(i)) {
                this.set.force(i, this);
                continue;
            }
            if (this.g.getPotentialNodes().contains(i)) continue;
            this.set.remove(i, this);
        }
        iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.set.getLB().contains(i)) {
                this.g.enforceNode(i, this);
                continue;
            }
            if (this.set.getUB().contains(i)) continue;
            this.g.removeNode(i, this);
        }
        this.sdm.startMonitoring();
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.sdm.forEach(this.forceS, SetEventType.ADD_TO_KER);
            this.sdm.forEach(this.remS, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            this.gdm.forEachNode(this.forceG, GraphEventType.ADD_NODE);
            this.gdm.forEachNode(this.remG, GraphEventType.REMOVE_NODE);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        ISetIterator iSetIterator = this.set.getLB().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.g.getPotentialNodes().contains(i)) continue;
            return ESat.FALSE;
        }
        iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            i = (Integer)iSetIterator.next();
            if (this.set.getUB().contains(i)) continue;
            return ESat.FALSE;
        }
        int n = this.g.getMandatoryNodes().size();
        if (n == this.g.getPotentialNodes().size() && n == this.set.getUB().size() && n == this.set.getLB().size()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

