/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.Arrays;
import java.util.function.Consumer;
import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.IntCircularQueue;
import org.chocosolver.util.objects.queues.CircularQueue;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public abstract class Propagator<V extends Variable>
implements ICause,
Identity,
Comparable<Propagator<V>> {
    private static final short NEW = 0;
    private static final short REIFIED = 1;
    protected static final short ACTIVE = 2;
    private static final short PASSIVE = 3;
    private boolean enabled = true;
    public static boolean DEFAULT_EXPL = true;
    public static boolean OUTPUT_DEFAULT_EXPL = false;
    private final int ID;
    protected short state = 0;
    protected IOperation[] operations;
    private final boolean swapOnPassivate;
    private boolean alive = true;
    protected final Priority priority;
    protected final boolean reactToFineEvt;
    protected Constraint constraint;
    protected final Model model;
    protected V[] vars;
    private int[] vindices;
    private boolean scheduled;
    private IntCircularQueue eventsets;
    private int[] eventmasks;
    private int position = -1;
    private IntIntConsumer fineevt = (i, m3) -> {};
    private BoolVar reifVar;

    protected Propagator(V[] vars, Priority priority, boolean reactToFineEvt, boolean swapOnPassivate) {
        assert (vars != null && vars.length > 0 && vars[0] != null) : "wrong variable set in propagator constructor";
        this.model = vars[0].getModel();
        this.reactToFineEvt = reactToFineEvt;
        this.priority = priority;
        this.vars = this.model.getSettings().cloneVariableArrayInPropagator() ? (Variable[])vars.clone() : vars;
        this.vindices = new int[vars.length];
        Arrays.fill(this.vindices, -1);
        this.ID = this.model.nextId();
        this.swapOnPassivate = this.model.getSettings().swapOnPassivate() & swapOnPassivate;
        if (this.swapOnPassivate) {
            this.operations = new IOperation[3 + vars.length];
            for (int i2 = 0; i2 < vars.length; ++i2) {
                int i0 = i2;
                this.operations[3 + i2] = () -> {
                    if (this.alive) {
                        this.doSwap(i0);
                    }
                };
            }
        } else {
            this.operations = new IOperation[3];
        }
        this.operations[0] = () -> {
            this.state = 0;
        };
        this.operations[1] = () -> {
            this.state = 1;
        };
        this.operations[2] = () -> {
            this.state = (short)2;
        };
        this.eventmasks = new int[vars.length];
        if (this.reactToFineEvent()) {
            this.eventsets = new IntCircularQueue(vars.length);
            this.eventmasks = new int[vars.length];
            this.fineevt = (i, m3) -> {
                if (this.eventmasks[i] == 0) {
                    this.eventsets.addLast(i);
                }
                int n = i;
                this.eventmasks[n] = this.eventmasks[n] | m3;
            };
        }
    }

    protected Propagator(V[] vars, Priority priority, boolean reactToFineEvt) {
        this((Variable[])vars, priority, reactToFineEvt, false);
    }

    @SafeVarargs
    protected Propagator(V ... vars) {
        this((Variable[])vars, PropagatorPriority.LINEAR, false);
    }

    @SafeVarargs
    protected final void addVariable(V ... nvars) {
        assert (!this.swapOnPassivate) : "Cannot add variable to a propagator that allows being swapped on passivate";
        V[] tmp = this.vars;
        this.vars = (Variable[])Arrays.copyOf(this.vars, this.vars.length + nvars.length);
        System.arraycopy(nvars, 0, this.vars, tmp.length, nvars.length);
        int[] itmp = this.vindices;
        this.vindices = new int[this.vars.length];
        System.arraycopy(itmp, 0, this.vindices, 0, itmp.length);
        for (int v = tmp.length; v < this.vars.length; ++v) {
            this.vindices[v] = this.vars[v].link(this, v);
        }
        if (this.reactToFineEvt) {
            itmp = this.eventmasks;
            this.eventmasks = new int[this.vars.length];
            System.arraycopy(itmp, 0, this.eventmasks, 0, itmp.length);
        }
        if (this.model.getSolver().getEngine().isInitialized()) {
            this.model.getSolver().getEngine().updateInvolvedVariables(this);
        }
    }

    public final void linkVariables() {
        for (int v = 0; v < this.vars.length; ++v) {
            if (this.vars[v].isAConstant()) continue;
            this.vindices[v] = this.vars[v].link(this, v);
        }
    }

    public final void unlinkVariables() {
        for (int v = 0; v < this.vars.length; ++v) {
            if (this.vars[v].isAConstant()) continue;
            this.vars[v].unlink(this, v);
            this.vindices[v] = -1;
            this.alive = false;
        }
    }

    void defineIn(Constraint c2) throws SolverException {
        if (this.constraint != null && this.constraint.getStatus() != Constraint.Status.FREE || c2.getStatus() != Constraint.Status.FREE) {
            throw new SolverException("This propagator is already defined in a constraint. This happens when a constraint is reified and posted.");
        }
        this.constraint = c2;
    }

    public int getPropagationConditions(int vIdx) {
        return 255;
    }

    public abstract void propagate(int var1) throws ContradictionException;

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (this.reactToFineEvt) {
            throw new SolverException(this + " has been declared to ignore which variable is modified.\nTo change the configuration, consider:\n- to set 'reactToFineEvt' to false or,\n- to override the following method:\n\t'public void propagate(int idxVarInProp, int mask) throws ContradictionException'.The latter enables incrementality but also to delay calls to complex filtering algorithm (see the method 'forcePropagate(EventType evt)'.");
        }
        this.propagate(PropagatorEventType.CUSTOM_PROPAGATION.getMask());
    }

    public final void forcePropagate(PropagatorEventType evt) throws ContradictionException {
        this.model.getSolver().getEngine().delayedPropagation(this, evt);
    }

    public void setActive() throws SolverException {
        if (!this.isStateLess()) {
            throw new SolverException("Try to activate a propagator already active, passive or reified.\n" + this + " of " + this.getConstraint());
        }
        this.state = (short)2;
        this.model.getEnvironment().save(this.operations[0]);
    }

    protected void setActive0() {
        this.state = (short)2;
    }

    public void setReifiedTrue() throws SolverException {
        if (!this.isReifiedAndSilent()) {
            throw new SolverException("Reification process tries to force activation of a propagator already active or passive.\n" + this + " of " + this.getConstraint());
        }
        this.state = (short)2;
        this.model.getEnvironment().save(this.operations[1]);
    }

    public void setReifiedSilent(BoolVar boolVar) throws SolverException {
        if (!this.isStateLess() && !this.isReifiedAndSilent()) {
            throw new SolverException("Reification process try to reify a propagator already active or posted.\n" + this + " of " + this.getConstraint());
        }
        this.state = 1;
        this.reifVar = boolVar;
    }

    public void setPassive() throws SolverException {
        if (this.isActive()) {
            this.state = (short)3;
            this.model.getEnvironment().save(this.operations[2]);
            this.model.getSolver().getEngine().desactivatePropagator(this);
            if (this.swapOnPassivate) {
                for (int i = 0; i < this.vars.length; ++i) {
                    if (this.vars[i].isInstantiated()) continue;
                    this.vindices[i] = this.vars[i].swapOnPassivate(this, i);
                    assert (this.vars[i].getPropagator(this.vindices[i]) == this);
                    this.model.getEnvironment().save(this.operations[3 + i]);
                }
            }
        } else {
            throw new SolverException("Try to passivate a propagator already passive or reified.\n" + this + " of " + this.getConstraint());
        }
    }

    private void doSwap(int i0) {
        this.vindices[i0] = this.vars[i0].swapOnActivate(this, i0);
    }

    protected void forcePropagationOnBacktrack() {
        if (this.isPassive()) {
            this.state = (short)2;
        }
        this.model.getSolver().getEngine().propagateOnBacktrack(this);
    }

    public abstract ESat isEntailed();

    public boolean isCompletelyInstantiated() {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public int arity() {
        int arity = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            arity += this.vars[i].isInstantiated() ? 0 : 1;
        }
        return arity;
    }

    public int dynPriority() {
        int arity = 0;
        for (int i = 0; i < this.vars.length && arity <= 3; arity += this.vars[i].isInstantiated() ? 0 : 1, ++i) {
        }
        if (arity > 3) {
            return this.priority.getValue();
        }
        return arity;
    }

    public void fails() throws ContradictionException {
        this.model.getSolver().throwsException(this, null, null);
    }

    @Override
    public int compareTo(Propagator o) {
        return this.ID - o.ID;
    }

    public BoolVar reifiedWith() {
        return this.reifVar;
    }

    public boolean isReified() {
        return this.reifVar != null;
    }

    @Override
    public int getId() {
        return this.ID;
    }

    public Model getModel() {
        return this.model;
    }

    public int hashCode() {
        return this.ID;
    }

    public boolean equals(Object o) {
        return o instanceof Propagator && ((Propagator)o).ID == this.ID;
    }

    public final V getVar(int i) {
        return this.vars[i];
    }

    public final V[] getVars() {
        return this.vars;
    }

    public int[] getVIndices() {
        return this.vindices;
    }

    public int getVIndice(int idx) {
        return this.vindices[idx];
    }

    public void setVIndices(int idx, int val) {
        this.vindices[idx] = val;
    }

    public final int getNbVars() {
        return this.vars.length;
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public boolean isStateLess() {
        return this.state == 0;
    }

    public boolean isReifiedAndSilent() {
        return this.state == 1;
    }

    public boolean isActive() {
        return this.state == 2 && this.enabled;
    }

    public boolean isPassive() {
        return this.state == 3;
    }

    public final boolean reactToFineEvent() {
        return this.reactToFineEvt;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append(this.getClass().getSimpleName()).append("(");
        int i = 0;
        if (this.vars.length >= 3) {
            st.append(this.vars[i++].getName()).append(", ");
        }
        if (this.vars.length >= 2) {
            st.append(this.vars[i++].getName()).append(", ");
        }
        if (this.vars.length >= 1) {
            st.append(this.vars[i++].getName());
        }
        if (i < this.vars.length) {
            if (this.vars.length > 4) {
                st.append(", ...");
            }
            st.append(", ").append(this.vars[this.vars.length - 1].getName());
        }
        st.append(')');
        return st.toString();
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (DEFAULT_EXPL) {
            if (OUTPUT_DEFAULT_EXPL) {
                this.model.getSolver().log().bold().printf("-- default explain for %s \n", this.getClass().getSimpleName());
            }
            Propagator.defaultExplain(this, p, explanation);
        } else {
            ICause.super.explain(p, explanation);
        }
    }

    public static void defaultExplain(Propagator<?> prop, int p, ExplanationForSignedClause explanation) {
        IntVar pivot = p > -1 ? explanation.readVar(p) : null;
        boolean found = false;
        for (int i = 0; i < prop.vars.length; ++i) {
            IntVar var = (IntVar)prop.vars[i];
            if (var == pivot) {
                if (found) continue;
                IntIterableRangeSet dom = explanation.complement(var);
                IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
                found = true;
                var.intersectLit(dom, explanation);
                continue;
            }
            var.unionLit(explanation.complement(var), explanation);
        }
        assert (found || p == -1) : pivot + " not declared in scope of " + prop;
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
        for (int i = 0; i < this.vars.length; ++i) {
            action.accept((IntVar)this.vars[i]);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int p) {
        this.position = p;
    }

    public final void unschedule() {
        this.scheduled = false;
    }

    private void schedule() {
        this.scheduled = true;
    }

    public final boolean isScheduled() {
        return this.scheduled;
    }

    public int doSchedule(CircularQueue<Propagator<?>>[] queues) {
        int prio = this.priority.getValue();
        if (!this.scheduled) {
            queues[prio].addLast(this);
            this.schedule();
        }
        return prio;
    }

    public void doScheduleEvent(int pindice, int mask) {
        this.fineevt.accept(pindice, mask);
    }

    public void doFinePropagation() throws ContradictionException {
        while (this.eventsets.size() > 0) {
            int v = this.eventsets.pollFirst();
            assert (this.isActive()) : "propagator is not active:" + this;
            int mask = this.eventmasks[v];
            this.eventmasks[v] = 0;
            this.propagate(v, mask);
        }
    }

    public void doFlush() {
        if (this.reactToFineEvent()) {
            while (this.eventsets.size() > 0) {
                int v = this.eventsets.pollLast();
                this.eventmasks[v] = 0;
            }
        }
        this.unschedule();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static interface IntIntConsumer {
        public void accept(int var1, int var2);
    }
}

