/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import java.awt.image.IndexColorModel;

public class SimpleColorIndexer
implements ColorIndexer {
    byte[][] colors;

    public SimpleColorIndexer(byte[][] colors) {
        this.colors = colors;
    }

    public SimpleColorIndexer(IndexColorModel icm) {
        this.colors = new byte[4][icm.getMapSize()];
        icm.getReds(this.colors[0]);
        icm.getGreens(this.colors[1]);
        icm.getBlues(this.colors[2]);
        icm.getAlphas(this.colors[3]);
    }

    @Override
    public IndexColorModel toIndexColorModel() {
        int bits = (int)Math.ceil(Math.log(this.colors[0].length) / Math.log(2.0));
        if (bits == 0) {
            bits = 1;
        }
        return new IndexColorModel(bits, this.colors[0].length, this.colors[0], this.colors[1], this.colors[2], this.colors[3]);
    }

    @Override
    public int getClosestIndex(int r, int g2, int b2, int a2) {
        int idx = 0;
        int distance = Integer.MAX_VALUE;
        for (int i = 0; i < this.colors[0].length; ++i) {
            int dr = r - (this.colors[0][i] & 0xFF);
            int dg = g2 - (this.colors[1][i] & 0xFF);
            int db = b2 - (this.colors[2][i] & 0xFF);
            int da = a2 - (this.colors[3][i] & 0xFF);
            int d2 = a2 == 0 && da == 0 ? 0 : 3 * dr * dr + 4 * dg * dg + 2 * db * db + 4 * da * da;
            if (d2 >= distance) continue;
            distance = d2;
            idx = i;
            if (distance == 0) break;
        }
        return idx;
    }
}

