/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.input.compressed;

import it.geosolutions.imageio.stream.input.compressed.InflaterImageInputStream;
import it.geosolutions.io.input.adapter.InputStreamAdapter;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Inflater;
import javax.imageio.stream.ImageInputStream;

public class GZIPImageInputStream
extends InflaterImageInputStream {
    private byte[] tmpbuf = new byte[128];
    public static final int GZIP_MAGIC = 35615;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;

    public GZIPImageInputStream(ImageInputStream iis) throws IOException {
        super(iis, new Inflater(true), 8192);
        this.usesDefaultInflater = true;
        this.readHeader();
        this.crc.reset();
    }

    private void readHeader() throws IOException {
        CheckedInputStream in = new CheckedInputStream(new InputStreamAdapter(this.iis), this.crc);
        this.crc.reset();
        if (this.readUShort(in) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (this.readUByte(in) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int flg = this.readUByte(in);
        this.skipBytes(in, 6);
        if ((flg & 4) == 4) {
            this.skipBytes(in, this.readUShort(in));
        }
        if ((flg & 8) == 8) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 0x10) == 16) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 2) == 2) {
            int v = (int)this.crc.getValue() & 0xFFFF;
            if (this.readUShort(in) != v) {
                throw new IOException("Corrupt GZIP header");
            }
        }
    }

    private void readTrailer() throws IOException {
        InputStream in = new InputStreamAdapter(this.iis);
        int n = this.inf.getRemaining();
        if (n > 0) {
            in = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), in);
        }
        if (this.readUInt(in) != this.crc.getValue() || this.readUInt(in) != ((long)this.inf.getTotalOut() & 0xFFFFFFFFL)) {
            throw new IOException("Corrupt GZIP trailer");
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        this.checkClosed();
        if (this.eos) {
            return -1;
        }
        if ((len = super.read(buf, off, len)) == -1) {
            this.readTrailer();
            this.eos = true;
        } else {
            this.crc.update(buf, off, len);
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }

    private long readUInt(InputStream in) throws IOException {
        long a2 = this.readUShort(in);
        long b2 = this.readUShort(in);
        return (b2 & 0xFFFFL) << 16 | a2 & 0xFFFFL;
    }

    private int readUShort(InputStream in) throws IOException {
        int a2 = this.readUByte(in);
        int b2 = this.readUByte(in);
        return (b2 & 0xFF) << 8 | a2 & 0xFF;
    }

    private int readUByte(InputStream in) throws IOException {
        int b2 = in.read();
        if (b2 == -1) {
            throw new EOFException();
        }
        return b2 & 0xFF;
    }

    private void skipBytes(InputStream in, int n) throws IOException {
        while (n > 0) {
            int len = in.read(this.tmpbuf, 0, n < this.tmpbuf.length ? n : this.tmpbuf.length);
            if (len == -1) {
                throw new EOFException();
            }
            n -= len;
        }
    }
}

