/*
 * Decompiled with CFR 0.152.
 */
package au.com.objectix.jgridshift;

public class Util {
    private Util() {
    }

    public static final int getIntLE(byte[] b2, int i) {
        return b2[i++] & 0xFF | b2[i++] << 8 & 0xFF00 | b2[i++] << 16 & 0xFF0000 | b2[i] << 24;
    }

    public static final int getIntBE(byte[] b2, int i) {
        return b2[i++] << 24 | b2[i++] << 16 & 0xFF0000 | b2[i++] << 8 & 0xFF00 | b2[i] & 0xFF;
    }

    public static final int getInt(byte[] b2, boolean bigEndian) {
        if (bigEndian) {
            return Util.getIntBE(b2, 0);
        }
        return Util.getIntLE(b2, 0);
    }

    public static final float getFloat(byte[] b2, boolean bigEndian) {
        int i = 0;
        i = bigEndian ? Util.getIntBE(b2, 0) : Util.getIntLE(b2, 0);
        return Float.intBitsToFloat(i);
    }

    public static final double getDouble(byte[] b2, boolean bigEndian) {
        int i = 0;
        int j = 0;
        if (bigEndian) {
            i = Util.getIntBE(b2, 0);
            j = Util.getIntBE(b2, 4);
        } else {
            i = Util.getIntLE(b2, 4);
            j = Util.getIntLE(b2, 0);
        }
        long l = (long)i << 32 | (long)j & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }
}

