## ----setup, include = FALSE-------------------------------------------------------------------------------------------
options(width=120)
knitr::opts_chunk$set(
   collapse = TRUE,
   eval=interactive(),
   echo=TRUE,
   comment = "#>"
)

## ----loadLibraries,  results='hide'-----------------------------------------------------------------------------------
#  library(shiny)
#  library(cyjShiny)

## ----app code, prompt=TRUE, message=TRUE, results="show"--------------------------------------------------------------
#  networks <- c("",
#                "tiny" = "simple/smallDemo.cyjs",
#                "galFiltered" = "galFiltered/galFiltered.cyjs")
#  
#  ui = shinyUI(fluidPage(
#  
#    tags$style("#cyjShiny{height:95vh !important;}"),
#    sidebarLayout(
#        sidebarPanel(
#            selectInput("loadNetworkFile", "Select Network: ", choices=networks)
#            ),
#       mainPanel(cyjShinyOutput('cyjShiny'), width=10),
#       fluid=FALSE
#    ) # sidebarLayout
#  ))
#  
#  server = function(input, output, session){
#  
#      observeEvent(input$loadNetworkFile,  ignoreInit=TRUE, {
#         print(" select network file")
#         })
#    }

## ----start app, prompt=TRUE, message=TRUE, results="show"-------------------------------------------------------------
#  app <- shinyApp(ui = ui, server = server)
#  app

