/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ErrorBasedMeritEvaluator;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.attributeSelection.WrapperSubsetEval;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.AbstractEvaluationMetric;
import weka.classifiers.evaluation.InformationRetrievalEvaluationMetric;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClassifierSubsetEval
extends HoldOutSubsetEvaluator
implements OptionHandler,
ErrorBasedMeritEvaluator {
    static final long serialVersionUID = 7532217899385278710L;
    private Instances m_trainingInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private Classifier m_ClassifierTemplate = new ZeroR();
    private Classifier m_Classifier = new ZeroR();
    private File m_holdOutFile = new File("Click to set hold out or test instances");
    private Instances m_holdOutInstances;
    private boolean m_useTraining = true;
    protected boolean m_usePercentageSplit;
    protected int m_seed = 1;
    protected String m_splitPercent = "90";
    public static final int EVAL_DEFAULT = 1;
    public static final int EVAL_ACCURACY = 2;
    public static final int EVAL_RMSE = 3;
    public static final int EVAL_MAE = 4;
    public static final int EVAL_FMEASURE = 5;
    public static final int EVAL_AUC = 6;
    public static final int EVAL_AUPRC = 7;
    public static final int EVAL_CORRELATION = 8;
    public static final int EVAL_PLUGIN = 9;
    protected static List<AbstractEvaluationMetric> PLUGIN_METRICS = AbstractEvaluationMetric.getPluginMetrics();
    public static final Tag[] TAGS_EVALUATION;
    protected Tag m_evaluationMeasure = TAGS_EVALUATION[0];
    protected int m_IRClassVal = -1;
    protected String m_IRClassValS = "";

    public String globalInfo() {
        return "Classifier subset evaluator:\n\nEvaluates attribute subsets on training data or a seperate hold out testing set. Uses a classifier to estimate the 'merit' of a set of attributes.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tclass name of the classifier to use for accuracy estimation.\n\tPlace any classifier options LAST on the command line\n\tfollowing a \"--\". eg.:\n\t\t-B weka.classifiers.bayes.NaiveBayes ... -- -K\n\t(default: weka.classifiers.rules.ZeroR)", "B", 1, "-B <classifier>"));
        newVector.addElement(new Option("\tUse the training data to estimate accuracy.", "T", 0, "-T"));
        newVector.addElement(new Option("\tName of the hold out/test set to \n\testimate accuracy on.", "H", 1, "-H <filename>"));
        newVector.addElement(new Option("\tPerform a percentage split on the training data.\n\tUse in conjunction with -T.", "percentage-split", 0, "-percentage-split"));
        newVector.addElement(new Option("\tSplit percentage to use (default = 90).", "P", 1, "-P"));
        newVector.addElement(new Option("\tRandom seed for percentage split (default = 1).", "S", 1, "-S"));
        newVector.addElement(new Option("\tPerformance evaluation measure to use for selecting attributes.\n\t(Default = default: accuracy for discrete class and rmse for numeric class)", "E", 1, "-E " + Tag.toOptionList(TAGS_EVALUATION)));
        newVector.addElement(new Option("\tOptional class value (label or 1-based index) to use in conjunction with\n\tIR statistics (f-meas, auc or auprc). Omitting this option will use\n\tthe class-weighted average.", "IRclass", 1, "-IRclass <label | index>"));
        if (this.m_ClassifierTemplate != null && this.m_ClassifierTemplate instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to scheme " + this.m_ClassifierTemplate.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_ClassifierTemplate)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('B', options);
        if (optionString.length() == 0) {
            optionString = ZeroR.class.getName();
        }
        this.setClassifier(AbstractClassifier.forName(optionString, Utils.partitionOptions(options)));
        optionString = Utils.getOption('H', options);
        if (optionString.length() != 0) {
            this.setHoldOutFile(new File(optionString));
        }
        this.setUsePercentageSplit(Utils.getFlag("percentage-split", options));
        optionString = Utils.getOption('P', options);
        if (optionString.length() > 0) {
            this.setSplitPercent(optionString);
        }
        this.setUseTraining(Utils.getFlag('T', options));
        optionString = Utils.getOption('E', options);
        if (optionString.length() != 0) {
            for (Tag t : TAGS_EVALUATION) {
                if (!t.getIDStr().equalsIgnoreCase(optionString)) continue;
                this.setEvaluationMeasure(new SelectedTag(t.getIDStr(), TAGS_EVALUATION));
                break;
            }
        }
        if ((optionString = Utils.getOption("IRClass", options)).length() > 0) {
            this.setIRClassValue(optionString);
        }
        if ((optionString = Utils.getOption("S", options)).length() > 0) {
            this.setSeed(Integer.parseInt(optionString));
        }
    }

    public String seedTipText() {
        return "The random seed to use for randomizing the training data prior to performing a percentage split";
    }

    public void setSeed(int s) {
        this.m_seed = s;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String usePercentageSplitTipText() {
        return "Evaluate using a percentage split on the training data";
    }

    public void setUsePercentageSplit(boolean p) {
        this.m_usePercentageSplit = p;
    }

    public boolean getUsePercentageSplit() {
        return this.m_usePercentageSplit;
    }

    public String splitPercentTipText() {
        return "The percentage split to use";
    }

    public void setSplitPercent(String sp) {
        this.m_splitPercent = sp;
    }

    public String getSplitPercent() {
        return this.m_splitPercent;
    }

    public void setIRClassValue(String val) {
        this.m_IRClassValS = val;
    }

    public String getIRClassValue() {
        return this.m_IRClassValS;
    }

    public String IRClassValueTipText() {
        return "The class label, or 1-based index of the class label, to use when evaluating subsets with an IR metric (such as f-measure or AUC. Leaving this unset will result in the class frequency weighted average of the metric being used.";
    }

    public String evaluationMeasureTipText() {
        return "The measure used to evaluate the performance of attribute combinations.";
    }

    public SelectedTag getEvaluationMeasure() {
        return new SelectedTag(this.m_evaluationMeasure.getIDStr(), TAGS_EVALUATION);
    }

    public void setEvaluationMeasure(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_EVALUATION) {
            this.m_evaluationMeasure = newMethod.getSelectedTag();
        }
    }

    public String classifierTipText() {
        return "Classifier to use for estimating the accuracy of subsets";
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_ClassifierTemplate = newClassifier;
        this.m_Classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_ClassifierTemplate;
    }

    public String holdOutFileTipText() {
        return "File containing hold out/test instances.";
    }

    public File getHoldOutFile() {
        return this.m_holdOutFile;
    }

    public void setHoldOutFile(File h) {
        this.m_holdOutFile = h;
    }

    public String useTrainingTipText() {
        return "Use training data instead of hold out/test instances.";
    }

    public boolean getUseTraining() {
        return this.m_useTraining;
    }

    public void setUseTraining(boolean t) {
        this.m_useTraining = t;
    }

    @Override
    public String[] getOptions() {
        String[] classifierOptions;
        Vector<String> options = new Vector<String>();
        if (this.getClassifier() != null) {
            options.add("-B");
            options.add(this.getClassifier().getClass().getName());
        }
        if (this.getUseTraining()) {
            options.add("-T");
        }
        options.add("-H");
        options.add(this.getHoldOutFile().getPath());
        if (this.getUsePercentageSplit()) {
            options.add("-percentage-split");
            options.add("-P");
            options.add(this.m_splitPercent);
            options.add("-S");
            options.add("" + this.getSeed());
        }
        options.add("-E");
        options.add(this.m_evaluationMeasure.getIDStr());
        if (this.m_IRClassValS != null && this.m_IRClassValS.length() > 0) {
            options.add("-IRClass");
            options.add(this.m_IRClassValS);
        }
        if (this.m_ClassifierTemplate != null && this.m_ClassifierTemplate instanceof OptionHandler && (classifierOptions = ((OptionHandler)((Object)this.m_ClassifierTemplate)).getOptions()).length > 0) {
            options.add("--");
            Collections.addAll(options, classifierOptions);
        }
        return options.toArray(new String[0]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getClassifier() == null) {
            result = super.getCapabilities();
            result.disableAll();
        } else {
            result = this.getClassifier().getCapabilities();
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainingInstances = new Instances(data);
        this.m_classIndex = this.m_trainingInstances.classIndex();
        this.m_numAttribs = this.m_trainingInstances.numAttributes();
        if (!this.m_useTraining && !this.getHoldOutFile().getPath().startsWith("Click to set")) {
            BufferedReader r = new BufferedReader(new FileReader(this.getHoldOutFile().getPath()));
            this.m_holdOutInstances = new Instances(r);
            this.m_holdOutInstances.setClassIndex(this.m_trainingInstances.classIndex());
            if (!this.m_trainingInstances.equalHeaders(this.m_holdOutInstances)) {
                throw new Exception("Hold out/test set is not compatable with training data.\n" + this.m_trainingInstances.equalHeadersMsg(this.m_holdOutInstances));
            }
        } else if (this.m_usePercentageSplit) {
            int splitPercentage = 90;
            try {
                splitPercentage = Integer.parseInt(this.m_splitPercent);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_trainingInstances.randomize(new Random(this.m_seed));
            int trainSize = Math.round(this.m_trainingInstances.numInstances() * splitPercentage / 100);
            int testSize = this.m_trainingInstances.numInstances() - trainSize;
            this.m_holdOutInstances = new Instances(this.m_trainingInstances, trainSize, testSize);
            this.m_trainingInstances = new Instances(this.m_trainingInstances, 0, trainSize);
        }
        if (this.m_IRClassValS != null && this.m_IRClassValS.length() > 0) {
            try {
                this.m_IRClassVal = Integer.parseInt(this.m_IRClassValS);
                --this.m_IRClassVal;
            }
            catch (NumberFormatException e) {
                this.m_IRClassVal = this.m_trainingInstances.classAttribute().indexOfValue(this.m_IRClassValS);
            }
        }
    }

    @Override
    public double evaluateSubset(BitSet subset) throws Exception {
        int i;
        double evalMetric = 0.0;
        int numAttributes = 0;
        Instances trainCopy = null;
        Instances testCopy = null;
        String[] cOpts = null;
        Evaluation evaluation = null;
        if (this.m_ClassifierTemplate instanceof OptionHandler) {
            cOpts = ((OptionHandler)((Object)this.m_ClassifierTemplate)).getOptions();
        }
        Classifier classifier = AbstractClassifier.forName(this.m_ClassifierTemplate.getClass().getName(), cOpts);
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        trainCopy = new Instances(this.m_trainingInstances);
        if (!this.m_useTraining) {
            if (this.m_holdOutInstances == null) {
                throw new Exception("Must specify a set of hold out/test instances with -H");
            }
            testCopy = new Instances(this.m_holdOutInstances);
        } else if (this.m_usePercentageSplit) {
            testCopy = new Instances(this.m_holdOutInstances);
        }
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++numAttributes;
        }
        int[] featArray = new int[numAttributes + 1];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            featArray[j++] = i;
        }
        featArray[j] = this.m_classIndex;
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        trainCopy = Filter.useFilter(trainCopy, delTransform);
        if (!this.m_useTraining || this.m_usePercentageSplit) {
            testCopy = Filter.useFilter(testCopy, delTransform);
        }
        classifier.buildClassifier(trainCopy);
        evaluation = new Evaluation(trainCopy);
        if (!this.m_useTraining || this.m_usePercentageSplit) {
            evaluation.evaluateModel(classifier, testCopy, new Object[0]);
        } else {
            evaluation.evaluateModel(classifier, trainCopy, new Object[0]);
        }
        String metricName = null;
        String statName = null;
        AbstractEvaluationMetric pluginMetric = null;
        switch (this.m_evaluationMeasure.getID()) {
            case 1: {
                evalMetric = evaluation.errorRate();
                break;
            }
            case 2: {
                evalMetric = evaluation.errorRate();
                break;
            }
            case 3: {
                evalMetric = evaluation.rootMeanSquaredError();
                break;
            }
            case 4: {
                evalMetric = evaluation.meanAbsoluteError();
                break;
            }
            case 5: {
                if (this.m_IRClassVal < 0) {
                    evalMetric = evaluation.weightedFMeasure();
                    break;
                }
                evalMetric = evaluation.fMeasure(this.m_IRClassVal);
                break;
            }
            case 6: {
                if (this.m_IRClassVal < 0) {
                    evalMetric = evaluation.weightedAreaUnderROC();
                    break;
                }
                evalMetric = evaluation.areaUnderROC(this.m_IRClassVal);
                break;
            }
            case 7: {
                evalMetric = this.m_IRClassVal < 0 ? evaluation.weightedAreaUnderPRC() : evaluation.areaUnderPRC(this.m_IRClassVal);
            }
            case 8: {
                evalMetric = evaluation.correlationCoefficient();
                break;
            }
            default: {
                if (this.m_evaluationMeasure.getID() >= 9) {
                    metricName = ((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getMetricName();
                    statName = ((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getStatisticName();
                    statName = ((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getStatisticName();
                    pluginMetric = evaluation.getPluginMetric(metricName);
                    if (pluginMetric == null) {
                        throw new Exception("Metric  " + metricName + " does not seem to be available");
                    }
                }
                if (pluginMetric instanceof InformationRetrievalEvaluationMetric) {
                    if (this.m_IRClassVal < 0) {
                        evalMetric = ((InformationRetrievalEvaluationMetric)((Object)pluginMetric)).getClassWeightedAverageStatistic(statName);
                        break;
                    }
                    evalMetric = ((InformationRetrievalEvaluationMetric)((Object)pluginMetric)).getStatistic(statName, this.m_IRClassVal);
                    break;
                }
                evalMetric = pluginMetric.getStatistic(statName);
            }
        }
        switch (this.m_evaluationMeasure.getID()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.m_trainingInstances.classAttribute().isNominal() && (this.m_evaluationMeasure.getID() == 1 || this.m_evaluationMeasure.getID() == 2)) {
                    evalMetric = 1.0 - evalMetric;
                    break;
                }
                evalMetric = -evalMetric;
                break;
            }
            default: {
                if (pluginMetric == null || pluginMetric.statisticIsMaximisable(statName)) break;
                evalMetric = -evalMetric;
            }
        }
        return evalMetric;
    }

    @Override
    public double evaluateSubset(BitSet subset, Instances holdOut) throws Exception {
        int i;
        double evalMetric = 0.0;
        int numAttributes = 0;
        Instances trainCopy = null;
        Instances testCopy = null;
        String[] cOpts = null;
        Evaluation evaluation = null;
        if (this.m_ClassifierTemplate instanceof OptionHandler) {
            cOpts = ((OptionHandler)((Object)this.m_ClassifierTemplate)).getOptions();
        }
        Classifier classifier = AbstractClassifier.forName(this.m_ClassifierTemplate.getClass().getName(), cOpts);
        if (!this.m_trainingInstances.equalHeaders(holdOut)) {
            throw new Exception("evaluateSubset : Incompatable instance types.\n" + this.m_trainingInstances.equalHeadersMsg(holdOut));
        }
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        trainCopy = new Instances(this.m_trainingInstances);
        testCopy = new Instances(holdOut);
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++numAttributes;
        }
        int[] featArray = new int[numAttributes + 1];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            featArray[j++] = i;
        }
        featArray[j] = this.m_classIndex;
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        trainCopy = Filter.useFilter(trainCopy, delTransform);
        testCopy = Filter.useFilter(testCopy, delTransform);
        classifier.buildClassifier(trainCopy);
        evaluation = new Evaluation(trainCopy);
        evaluation.evaluateModel(classifier, testCopy, new Object[0]);
        String metricName = null;
        String statName = null;
        AbstractEvaluationMetric pluginMetric = null;
        switch (this.m_evaluationMeasure.getID()) {
            case 1: {
                evalMetric = evaluation.errorRate();
                break;
            }
            case 2: {
                evalMetric = evaluation.errorRate();
                break;
            }
            case 3: {
                evalMetric = evaluation.rootMeanSquaredError();
                break;
            }
            case 4: {
                evalMetric = evaluation.meanAbsoluteError();
                break;
            }
            case 5: {
                if (this.m_IRClassVal < 0) {
                    evalMetric = evaluation.weightedFMeasure();
                    break;
                }
                evalMetric = evaluation.fMeasure(this.m_IRClassVal);
                break;
            }
            case 6: {
                if (this.m_IRClassVal < 0) {
                    evalMetric = evaluation.weightedAreaUnderROC();
                    break;
                }
                evalMetric = evaluation.areaUnderROC(this.m_IRClassVal);
                break;
            }
            case 7: {
                evalMetric = this.m_IRClassVal < 0 ? evaluation.weightedAreaUnderPRC() : evaluation.areaUnderPRC(this.m_IRClassVal);
            }
            case 8: {
                evalMetric = evaluation.correlationCoefficient();
                break;
            }
            default: {
                if (this.m_evaluationMeasure.getID() >= 9) {
                    metricName = ((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getMetricName();
                    statName = ((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getStatisticName();
                    statName = ((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getStatisticName();
                    pluginMetric = evaluation.getPluginMetric(metricName);
                    if (pluginMetric == null) {
                        throw new Exception("Metric  " + metricName + " does not seem to be available");
                    }
                }
                if (pluginMetric instanceof InformationRetrievalEvaluationMetric) {
                    if (this.m_IRClassVal < 0) {
                        evalMetric = ((InformationRetrievalEvaluationMetric)((Object)pluginMetric)).getClassWeightedAverageStatistic(statName);
                        break;
                    }
                    evalMetric = ((InformationRetrievalEvaluationMetric)((Object)pluginMetric)).getStatistic(statName, this.m_IRClassVal);
                    break;
                }
                evalMetric = pluginMetric.getStatistic(statName);
            }
        }
        switch (this.m_evaluationMeasure.getID()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.m_trainingInstances.classAttribute().isNominal() && (this.m_evaluationMeasure.getID() == 1 || this.m_evaluationMeasure.getID() == 2)) {
                    evalMetric = 1.0 - evalMetric;
                    break;
                }
                evalMetric = -evalMetric;
                break;
            }
            default: {
                if (pluginMetric == null || pluginMetric.statisticIsMaximisable(statName)) break;
                evalMetric = -evalMetric;
            }
        }
        return evalMetric;
    }

    @Override
    public double evaluateSubset(BitSet subset, Instance holdOut, boolean retrain) throws Exception {
        int i;
        if (this.m_evaluationMeasure.getID() != 1) {
            throw new Exception("Can only use default evaluation measure in the method");
        }
        int numAttributes = 0;
        Instances trainCopy = null;
        Instance testCopy = null;
        if (!this.m_trainingInstances.equalHeaders(holdOut.dataset())) {
            throw new Exception("evaluateSubset : Incompatable instance types.\n" + this.m_trainingInstances.equalHeadersMsg(holdOut.dataset()));
        }
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        trainCopy = new Instances(this.m_trainingInstances);
        testCopy = (Instance)holdOut.copy();
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++numAttributes;
        }
        int[] featArray = new int[numAttributes + 1];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            featArray[j++] = i;
        }
        featArray[j] = this.m_classIndex;
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        if (retrain) {
            trainCopy = Filter.useFilter(trainCopy, delTransform);
            this.m_Classifier.buildClassifier(trainCopy);
        }
        delTransform.input(testCopy);
        testCopy = delTransform.output();
        double[] distrib = this.m_Classifier.distributionForInstance(testCopy);
        double pred = this.m_trainingInstances.classAttribute().isNominal() ? distrib[(int)testCopy.classValue()] : distrib[0];
        double error = this.m_trainingInstances.classAttribute().isNominal() ? 1.0 - pred : testCopy.classValue() - pred;
        return -error;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainingInstances == null) {
            text.append("\tClassifier subset evaluator has not been built yet\n");
        } else {
            text.append("\tClassifier Subset Evaluator\n");
            text.append("\tLearning scheme: " + this.getClassifier().getClass().getName() + "\n");
            text.append("\tScheme options: ");
            String[] classifierOptions = new String[]{};
            if (this.m_ClassifierTemplate instanceof OptionHandler) {
                for (String classifierOption : classifierOptions = ((OptionHandler)((Object)this.m_ClassifierTemplate)).getOptions()) {
                    text.append(classifierOption + " ");
                }
            }
            text.append("\n");
            text.append("\tHold out/test set: ");
            if (!this.m_useTraining) {
                if (this.getHoldOutFile().getPath().startsWith("Click to set")) {
                    text.append("none\n");
                } else {
                    text.append(this.getHoldOutFile().getPath() + '\n');
                }
            } else if (this.m_usePercentageSplit) {
                text.append("Percentage split: " + this.m_splitPercent + "\n");
            } else {
                text.append("Training data\n");
            }
            String IRClassL = "";
            if (this.m_IRClassVal >= 0) {
                IRClassL = "(class value: " + this.m_trainingInstances.classAttribute().value(this.m_IRClassVal) + ")";
            }
            switch (this.m_evaluationMeasure.getID()) {
                case 1: 
                case 2: {
                    if (this.m_trainingInstances.attribute(this.m_classIndex).isNumeric()) {
                        text.append("\tSubset evaluation: RMSE\n");
                        break;
                    }
                    text.append("\tSubset evaluation: classification error\n");
                    break;
                }
                case 3: {
                    if (this.m_trainingInstances.attribute(this.m_classIndex).isNumeric()) {
                        text.append("\tSubset evaluation: RMSE\n");
                        break;
                    }
                    text.append("\tSubset evaluation: RMSE (probability estimates)\n");
                    break;
                }
                case 4: {
                    if (this.m_trainingInstances.attribute(this.m_classIndex).isNumeric()) {
                        text.append("\tSubset evaluation: MAE\n");
                        break;
                    }
                    text.append("\tSubset evaluation: MAE (probability estimates)\n");
                    break;
                }
                case 5: {
                    text.append("\tSubset evaluation: F-measure " + (this.m_IRClassVal >= 0 ? IRClassL : "") + "\n");
                    break;
                }
                case 6: {
                    text.append("\tSubset evaluation: area under the ROC curve " + (this.m_IRClassVal >= 0 ? IRClassL : "") + "\n");
                    break;
                }
                case 7: {
                    text.append("\tSubset evalation: area under the precision-recal curve " + (this.m_IRClassVal >= 0 ? IRClassL : "") + "\n");
                    break;
                }
                case 8: {
                    text.append("\tSubset evaluation: correlation coefficient\n");
                    break;
                }
                default: {
                    text.append("\tSubset evaluation: " + this.m_evaluationMeasure.getReadable());
                    if (((WrapperSubsetEval.PluginTag)this.m_evaluationMeasure).getMetric() instanceof InformationRetrievalEvaluationMetric) {
                        text.append(" " + (this.m_IRClassVal > 0 ? IRClassL : ""));
                    }
                    text.append("\n");
                }
            }
        }
        return text.toString();
    }

    protected void resetOptions() {
        this.m_trainingInstances = null;
        this.m_ClassifierTemplate = new ZeroR();
        this.m_holdOutFile = new File("Click to set hold out or test instances");
        this.m_holdOutInstances = null;
        this.m_useTraining = false;
        this.m_splitPercent = "90";
        this.m_usePercentageSplit = false;
        this.m_evaluationMeasure = TAGS_EVALUATION[0];
        this.m_IRClassVal = -1;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10332 $");
    }

    public static void main(String[] args) {
        ClassifierSubsetEval.runEvaluator(new ClassifierSubsetEval(), args);
    }

    static {
        int totalPluginCount = 0;
        if (PLUGIN_METRICS != null) {
            for (AbstractEvaluationMetric m : PLUGIN_METRICS) {
                totalPluginCount += m.getStatisticNames().size();
            }
        }
        TAGS_EVALUATION = new Tag[8 + totalPluginCount];
        ClassifierSubsetEval.TAGS_EVALUATION[0] = new Tag(1, "default", "Default: accuracy (discrete class); RMSE (numeric class)");
        ClassifierSubsetEval.TAGS_EVALUATION[1] = new Tag(2, "acc", "Accuracy (discrete class only)");
        ClassifierSubsetEval.TAGS_EVALUATION[2] = new Tag(3, "rmse", "RMSE (of the class probabilities for discrete class)");
        ClassifierSubsetEval.TAGS_EVALUATION[3] = new Tag(4, "mae", "MAE (of the class probabilities for discrete class)");
        ClassifierSubsetEval.TAGS_EVALUATION[4] = new Tag(5, "f-meas", "F-measure (discrete class only)");
        ClassifierSubsetEval.TAGS_EVALUATION[5] = new Tag(6, "auc", "AUC (area under the ROC curve - discrete class only)");
        ClassifierSubsetEval.TAGS_EVALUATION[6] = new Tag(7, "auprc", "AUPRC (area under the precision-recall curve - discrete class only)");
        ClassifierSubsetEval.TAGS_EVALUATION[7] = new Tag(8, "corr-coeff", "Correlation coefficient - numeric class only");
        if (PLUGIN_METRICS != null) {
            int index = 8;
            for (AbstractEvaluationMetric m : PLUGIN_METRICS) {
                for (String stat : m.getStatisticNames()) {
                    ClassifierSubsetEval.TAGS_EVALUATION[index++] = new WrapperSubsetEval.PluginTag(index + 1, m, stat);
                }
            }
        }
    }
}

