/*
 * Decompiled with CFR 0.152.
 */
package dr.matrix;

import dr.matrix.Matrix;

public interface MutableMatrix
extends Matrix {
    public void setDimension(int var1);

    public void setDimension(int var1, int var2);

    public void setMatrix(Matrix var1);

    public void setElements(double[][] var1);

    public void setElements(double[] var1);

    public void setElements(double var1);

    public void setElement(int var1, int var2, double var3);

    public void setElement(int var1, double var2);

    public void setRow(int var1, double[] var2);

    public void setColumn(int var1, double[] var2);

    public void setUpperTriangle(double[] var1) throws Matrix.NotSquareException;

    public void setLowerTriangle(double[] var1) throws Matrix.NotSquareException;

    public void setDiagonal(double[] var1) throws Matrix.NotSquareException;

    public void makeTransposed();

    public void makeSymmetricFromUpperTriangle() throws Matrix.NotSquareException;

    public void makeSymmetricFromLowerTriangle() throws Matrix.NotSquareException;

    public void makeIdentity() throws Matrix.NotSquareException;

    public static abstract class AbstractMutableMatrix
    extends Matrix.AbstractMatrix
    implements MutableMatrix {
        public AbstractMutableMatrix() {
        }

        public AbstractMutableMatrix(int n) {
            this.setDimension(n);
        }

        public AbstractMutableMatrix(int n, int n2) {
            this.setDimension(n, n2);
        }

        public AbstractMutableMatrix(Matrix matrix) {
            this.setDimension(matrix.getRowCount(), matrix.getColumnCount());
            this.setMatrix(matrix);
        }

        public AbstractMutableMatrix(double[][] dArray) {
            this.setDimension(dArray.length, dArray[0].length);
            this.setElements(dArray);
        }

        public AbstractMutableMatrix(int n, int n2, double[] dArray) {
            this.setDimension(n, n2);
            this.setElements(dArray);
        }

        public AbstractMutableMatrix(int n, int n2, double d) {
            this.setDimension(n, n2);
            this.setElements(d);
        }

        @Override
        public void setDimension(int n) {
            this.setDimension(n, n);
        }

        @Override
        public void setMatrix(Matrix matrix) {
            int n = matrix.getRowCount();
            int n2 = matrix.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.setElement(i, j, matrix.getElement(i, j));
                }
            }
        }

        @Override
        public void setElements(double[][] dArray) {
            this.setDimension(dArray.length, dArray[0].length);
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    this.setElement(i, j, dArray[i][j]);
                }
            }
        }

        @Override
        public void setElements(double[] dArray) {
            int n = 0;
            int n2 = this.getRowCount();
            int n3 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.setElement(i, j, dArray[n]);
                    ++n;
                }
            }
        }

        @Override
        public void setElements(double d) {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.setElement(i, j, d);
                }
            }
        }

        @Override
        public void setElement(int n, double d) {
            int n2 = n / this.getColumnCount();
            int n3 = n % this.getColumnCount();
            this.setElement(n2, n3, d);
        }

        @Override
        public void setRow(int n, double[] dArray) {
            int n2 = this.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                this.setElement(n, i, dArray[i]);
            }
        }

        @Override
        public void setColumn(int n, double[] dArray) {
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                this.setElement(i, n, dArray[i]);
            }
        }

        @Override
        public void setUpperTriangle(double[] dArray) throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            int n = 0;
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                for (int j = i + 1; j < n2; ++j) {
                    this.setElement(i, j, dArray[n]);
                    ++n;
                }
            }
        }

        @Override
        public void setLowerTriangle(double[] dArray) throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            int n = 0;
            int n2 = this.getRowCount();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < i; ++j) {
                    this.setElement(i, j, dArray[n]);
                    ++n;
                }
            }
        }

        @Override
        public void setDiagonal(double[] dArray) throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            int n = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                this.setElement(i, i, dArray[i]);
            }
        }

        @Override
        public void makeTransposed() {
            double[][] dArray = this.getElements2D();
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            this.setDimension(n2, n);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.setElement(i, j, dArray[j][i]);
                }
            }
        }

        @Override
        public void makeSymmetricFromUpperTriangle() throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            double[] dArray = this.getUpperTriangle();
            this.setLowerTriangle(dArray);
        }

        @Override
        public void makeSymmetricFromLowerTriangle() throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            double[] dArray = this.getUpperTriangle();
            this.setLowerTriangle(dArray);
        }

        @Override
        public void makeIdentity() throws Matrix.NotSquareException {
            if (!this.getIsSquare()) {
                throw new Matrix.NotSquareException();
            }
            this.setElements(0.0);
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setElement(i, i, 1.0);
            }
        }
    }
}

