/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.distributions.Distribution;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.NormalKDEDistribution;

public class MultivariateKDEDistribution
implements MultivariateDistribution,
GradientProvider {
    public static final String TYPE = "multivariateKDE";
    public static final boolean DEBUG = false;
    private Distribution[] multivariateKDE;
    private int dimension;

    public MultivariateKDEDistribution(Distribution[] distributionArray) {
        if (distributionArray.length <= 0) {
            throw new RuntimeException("Creation error in MultivariateKDEDistribution(Distribution[] multivariateKDE)");
        }
        this.multivariateKDE = distributionArray;
        this.dimension = distributionArray.length;
    }

    public MultivariateKDEDistribution(Distribution[] distributionArray, boolean[] blArray) {
        if (distributionArray.length <= 0) {
            throw new RuntimeException("Creation error in MultivariateKDEDistribution(Distribution[] multivariateKDE, boolean[] flags)");
        }
        this.multivariateKDE = distributionArray;
        this.dimension = distributionArray.length;
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = 0.0;
        if (dArray.length != this.dimension) {
            throw new IllegalArgumentException("data array is of the wrong dimension");
        }
        for (int i = 0; i < this.dimension; ++i) {
            d += this.multivariateKDE[i].logPdf(dArray[i]);
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        if (dArray.length != this.dimension) {
            throw new IllegalArgumentException("data array is of the wrong dimension");
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < this.dimension; ++i) {
            assert (this.multivariateKDE[i] instanceof NormalKDEDistribution) : "Gradient of the working prior is only implemented for the (transformed) normal KDE estimator.";
            dArray2[i] = ((NormalKDEDistribution)this.multivariateKDE[i]).getGradLogDensity(dArray[i]);
        }
        return dArray2;
    }
}

