/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class ExponentialDistribution
implements Distribution {
    private UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return ExponentialDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    double lambda;

    public ExponentialDistribution(double d) {
        this.lambda = d;
    }

    @Override
    public double pdf(double d) {
        return ExponentialDistribution.pdf(d, this.lambda);
    }

    @Override
    public double logPdf(double d) {
        return ExponentialDistribution.logPdf(d, this.lambda);
    }

    public double gradLogPdf(double d) {
        return ExponentialDistribution.gradLogPdf(d, this.lambda);
    }

    @Override
    public double cdf(double d) {
        return ExponentialDistribution.cdf(d, this.lambda);
    }

    @Override
    public double quantile(double d) {
        return ExponentialDistribution.quantile(d, this.lambda);
    }

    @Override
    public double mean() {
        return ExponentialDistribution.mean(this.lambda);
    }

    @Override
    public double variance() {
        return ExponentialDistribution.variance(this.lambda);
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2) {
        if (d < 0.0) {
            return 0.0;
        }
        return d2 * Math.exp(-d2 * d);
    }

    public static double logPdf(double d, double d2) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(d2) - d2 * d;
    }

    public static double gradLogPdf(double d, double d2) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -d2;
    }

    public static double hessianLogPdf(double d, double d2) {
        return 0.0;
    }

    public static double cdf(double d, double d2) {
        return 1.0 - Math.exp(-d2 * d);
    }

    public static double quantile(double d, double d2) {
        return -(1.0 / d2) * Math.log(1.0 - d);
    }

    public static double mean(double d) {
        return 1.0 / d;
    }

    public static double variance(double d) {
        return 1.0 / (d * d);
    }
}

