/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.VectorSliceParameter;
import java.util.ArrayList;
import java.util.List;

public class TransposedMatrixParameter
extends MatrixParameter {
    private List<Parameter> slices = null;

    public TransposedMatrixParameter(String string) {
        super(string + ".transpose");
    }

    public TransposedMatrixParameter(String string, Parameter[] parameterArray) {
        super(string + ".transpose", parameterArray);
    }

    public static TransposedMatrixParameter recast(String string, CompoundParameter compoundParameter) {
        int n = compoundParameter.getParameterCount();
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = compoundParameter.getParameter(i);
        }
        return new TransposedMatrixParameter(string, parameterArray);
    }

    @Override
    public int getColumnDimension() {
        return super.getParameter(0).getDimension();
    }

    @Override
    public int getRowDimension() {
        return super.getParameterCount();
    }

    @Override
    public int getParameterCount() {
        return this.getColumnDimension();
    }

    @Override
    public double[][] getParameterAsMatrix() {
        int n = this.getColumnDimension();
        int n2 = this.getRowDimension();
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = this.getParameterValue(i, j);
            }
        }
        return dArray;
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = n;
        return super.getParameterValue(n2);
    }

    @Override
    public Parameter getParameter(int n) {
        if (this.slices == null) {
            this.slices = new ArrayList<Parameter>();
            for (int i = 0; i < this.getColumnDimension(); ++i) {
                VectorSliceParameter vectorSliceParameter = new VectorSliceParameter(this.getParameterName() + "." + i, i);
                for (int j = 0; j < this.getRowDimension(); ++j) {
                    vectorSliceParameter.addParameter(super.getParameter(j));
                }
                this.slices.add(vectorSliceParameter);
            }
        }
        return this.slices.get(n);
    }

    MatrixParameter transposeBack() {
        return MatrixParameter.recast(null, this);
    }
}

