/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.math.MathUtils;
import dr.util.Identifiable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.OrRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.List;

public class RandomSubsetTaxaParser
extends AbstractXMLObjectParser {
    public static final String RANDOM_SUBSET_TAXA = "randomSubsetTaxa";
    public static final String COUNT = "total";
    public static final String WITH_REPLACEMENT = "withReplacement";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new OrRule(new ElementRule(Taxa.class, 1, Integer.MAX_VALUE), new ElementRule(Taxon.class, 1, Integer.MAX_VALUE)), AttributeRule.newIntegerRule("total"), AttributeRule.newBooleanRule("withReplacement")};

    @Override
    public String getParserName() {
        return RANDOM_SUBSET_TAXA;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Taxa taxa = new Taxa();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Identifiable identifiable;
            Object object = xMLObject.getChild(i);
            if (object instanceof Taxon) {
                identifiable = (Taxon)object;
                taxa.addTaxon((Taxon)identifiable);
                continue;
            }
            if (object instanceof TaxonList) {
                identifiable = (TaxonList)object;
                for (int j = 0; j < identifiable.getTaxonCount(); ++j) {
                    taxa.addTaxon(identifiable.getTaxon(j));
                }
                continue;
            }
            this.throwUnrecognizedElement(xMLObject);
        }
        List<Taxon> list = taxa.asList();
        int n = xMLObject.getAttribute(COUNT, list.size());
        if (n < 2) {
            throw new XMLParseException("Must sample atleast two taxa");
        }
        boolean bl = xMLObject.getAttribute(WITH_REPLACEMENT, false);
        Taxa taxa2 = new Taxa();
        for (int i = 0; i < n; ++i) {
            int n2 = MathUtils.nextInt(list.size());
            Taxon taxon = list.get(n2);
            taxa2.addTaxon(taxon);
            if (bl) continue;
            list.remove(n2);
        }
        return taxa2;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Defines a set of taxon objects.";
    }

    @Override
    public Class getReturnType() {
        return Taxa.class;
    }
}

